/*******************************************************

Original Author...Tor Jonas Onsrud
Purpose...........matrix4 math

Description:
This is a matrix4 math class for fusausion.
It is templetized to support different types.

********************************************************/

//TODO:
/*
- needs to be tested out in action.
*/
#ifndef H_xxFUSA_MATRIX4xx_H
#define H_xxFUSA_MATRIX4xx_H

#include "fusa_vectormath.h"
#include "fusa_mathfuncs.h"
#include <iostream>


namespace fusa
{
	template<class te>
	struct sData4
	{
		te _00;
		te _10;
		te _20;
		te _30;
		
		te _01;
		te _11;
		te _21;
		te _31;
		
		te _02;
		te _12;
		te _22;
		te _32;
	
		te _03;
		te _13;
		te _23;
		te _33;
	};
	template<class ta>
	/*
	@class cMatrix4
	@brief cMatrix4 is a mathematical 4*4 matrix structure. the datatype is templetized
	*/
	class cMatrix4
	{
	public:
		cMatrix4()
		{
			m_identityMatrix._00=1;	m_identityMatrix._01=0;	m_identityMatrix._02=0;	m_identityMatrix._03=0;
			m_identityMatrix._10=0;	m_identityMatrix._11=1;	m_identityMatrix._12=0;	m_identityMatrix._13=0;
			m_identityMatrix._20=0;	m_identityMatrix._21=0;	m_identityMatrix._22=1;	m_identityMatrix._23=0;
			m_identityMatrix._30=0;	m_identityMatrix._31=0;	m_identityMatrix._32=0;	m_identityMatrix._33=1;

			m_matrixData=m_identityMatrix;
		}
		cMatrix4(ta _00,ta _01, ta _02, ta _03,
				  ta _10,ta _11, ta _12, ta _13,
				  ta _20,ta _21, ta _22, ta _23,
				  ta _30,ta _31, ta _32, ta _33)
		{
			m_matrixData._00=_00;m_matrixData._01=_01;m_matrixData._02=_02;m_matrixData._03=_03;
			m_matrixData._10=_10;m_matrixData._11=_11;m_matrixData._12=_12;m_matrixData._13=_13;
			m_matrixData._20=_20;m_matrixData._21=_21;m_matrixData._22=_22;m_matrixData._23=_23;
			m_matrixData._30=_30;m_matrixData._31=_31;m_matrixData._32=_32;m_matrixData._33=_33;

			m_identityMatrix._00=1;	m_identityMatrix._01=0;	m_identityMatrix._02=0;	m_identityMatrix._03=0;
			m_identityMatrix._10=0;	m_identityMatrix._11=1;	m_identityMatrix._12=0;	m_identityMatrix._13=0;
			m_identityMatrix._20=0;	m_identityMatrix._21=0;	m_identityMatrix._22=1;	m_identityMatrix._23=0;
			m_identityMatrix._30=0;	m_identityMatrix._31=0;	m_identityMatrix._32=0;	m_identityMatrix._33=1;
		}
		~cMatrix4(){;}
		///Sets the m_matrixData to the current matrix
		void setMatrix4(ta _00,ta _01, ta _02, ta _03,
						ta _10,ta _11, ta _12, ta _13,
						ta _20,ta _21, ta _22, ta _23,
						ta _30,ta _31, ta _32, ta _33)
		{
			m_matrixData._00=_00;m_matrixData._01=_01;m_matrixData._02=_02;m_matrixData._03=_03;
			m_matrixData._10=_10;m_matrixData._11=_11;m_matrixData._12=_12;m_matrixData._13=_13;
			m_matrixData._20=_20;m_matrixData._21=_21;m_matrixData._22=_22;m_matrixData._23=_23;
			m_matrixData._30=_30;m_matrixData._31=_31;m_matrixData._32=_32;m_matrixData._33=_33;
		}
		///Operator overloaded, multiplying two matrix and leave the result in the first matrix.
		void operator *=(const cMatrix4 &matrix)
		{
			m_matrixDataI._00=(m_matrixData._00 * matrix.m_matrixData._00) + (m_matrixData._01 * matrix.m_matrixData._10) + (m_matrixData._02 * matrix.m_matrixData._20) + (m_matrixData._03 * matrix.m_matrixData._30);
			m_matrixDataI._01=(m_matrixData._00 * matrix.m_matrixData._01) + (m_matrixData._01 * matrix.m_matrixData._11) + (m_matrixData._02 * matrix.m_matrixData._21) + (m_matrixData._03 * matrix.m_matrixData._31);
			m_matrixDataI._02=(m_matrixData._00 * matrix.m_matrixData._02) + (m_matrixData._01 * matrix.m_matrixData._12) + (m_matrixData._02 * matrix.m_matrixData._22) + (m_matrixData._03 * matrix.m_matrixData._32);
			m_matrixDataI._03=(m_matrixData._00 * matrix.m_matrixData._03) + (m_matrixData._01 * matrix.m_matrixData._13) + (m_matrixData._02 * matrix.m_matrixData._23) + (m_matrixData._03 * matrix.m_matrixData._33);

			m_matrixDataI._10=(m_matrixData._10 * matrix.m_matrixData._00) + (m_matrixData._11 * matrix.m_matrixData._10) + (m_matrixData._12 * matrix.m_matrixData._20) + (m_matrixData._13 * matrix.m_matrixData._30);
			m_matrixDataI._11=(m_matrixData._10 * matrix.m_matrixData._01) + (m_matrixData._11 * matrix.m_matrixData._11) + (m_matrixData._12 * matrix.m_matrixData._21) + (m_matrixData._13 * matrix.m_matrixData._31);
			m_matrixDataI._12=(m_matrixData._10 * matrix.m_matrixData._02) + (m_matrixData._11 * matrix.m_matrixData._12) + (m_matrixData._12 * matrix.m_matrixData._22) + (m_matrixData._13 * matrix.m_matrixData._32);
			m_matrixDataI._13=(m_matrixData._10 * matrix.m_matrixData._03) + (m_matrixData._11 * matrix.m_matrixData._13) + (m_matrixData._12 * matrix.m_matrixData._23) + (m_matrixData._13 * matrix.m_matrixData._33);

			m_matrixDataI._20=(m_matrixData._20 * matrix.m_matrixData._00) + (m_matrixData._21 * matrix.m_matrixData._10) + (m_matrixData._22 * matrix.m_matrixData._20) + (m_matrixData._23 * matrix.m_matrixData._30);
			m_matrixDataI._21=(m_matrixData._20 * matrix.m_matrixData._01) + (m_matrixData._21 * matrix.m_matrixData._11) + (m_matrixData._22 * matrix.m_matrixData._21) + (m_matrixData._23 * matrix.m_matrixData._31);
			m_matrixDataI._22=(m_matrixData._20 * matrix.m_matrixData._02) + (m_matrixData._21 * matrix.m_matrixData._12) + (m_matrixData._22 * matrix.m_matrixData._22) + (m_matrixData._23 * matrix.m_matrixData._32);
			m_matrixDataI._23=(m_matrixData._20 * matrix.m_matrixData._03) + (m_matrixData._21 * matrix.m_matrixData._13) + (m_matrixData._22 * matrix.m_matrixData._23) + (m_matrixData._23 * matrix.m_matrixData._33);

			m_matrixDataI._30=(m_matrixData._30 * matrix.m_matrixData._00) + (m_matrixData._31 * matrix.m_matrixData._10) + (m_matrixData._32 * matrix.m_matrixData._20) + (m_matrixData._33 * matrix.m_matrixData._30);
			m_matrixDataI._31=(m_matrixData._30 * matrix.m_matrixData._01) + (m_matrixData._31 * matrix.m_matrixData._11) + (m_matrixData._32 * matrix.m_matrixData._21) + (m_matrixData._33 * matrix.m_matrixData._31);
			m_matrixDataI._32=(m_matrixData._30 * matrix.m_matrixData._02) + (m_matrixData._31 * matrix.m_matrixData._12) + (m_matrixData._32 * matrix.m_matrixData._22) + (m_matrixData._33 * matrix.m_matrixData._32);
			m_matrixDataI._33=(m_matrixData._30 * matrix.m_matrixData._03) + (m_matrixData._31 * matrix.m_matrixData._13) + (m_matrixData._32 * matrix.m_matrixData._23) + (m_matrixData._33 * matrix.m_matrixData._33);

			m_matrixData = m_matrixDataI;

		}
		///Operator overloaded, multiplying two matrix and returns the new one.
		cMatrix4 operator *(const cMatrix4 &matrix)const
		{
			cMatrix4 res;
			res.m_matrixData._00=(m_matrixData._00 * matrix.m_matrixData._00) + (m_matrixData._01 * matrix.m_matrixData._10) + (m_matrixData._02 * matrix.m_matrixData._20) + (m_matrixData._03 * matrix.m_matrixData._30);
			res.m_matrixData._01=(m_matrixData._00 * matrix.m_matrixData._01) + (m_matrixData._01 * matrix.m_matrixData._11) + (m_matrixData._02 * matrix.m_matrixData._21) + (m_matrixData._03 * matrix.m_matrixData._31);
			res.m_matrixData._02=(m_matrixData._00 * matrix.m_matrixData._02) + (m_matrixData._01 * matrix.m_matrixData._12) + (m_matrixData._02 * matrix.m_matrixData._22) + (m_matrixData._03 * matrix.m_matrixData._32);
			res.m_matrixData._03=(m_matrixData._00 * matrix.m_matrixData._03) + (m_matrixData._01 * matrix.m_matrixData._13) + (m_matrixData._02 * matrix.m_matrixData._23) + (m_matrixData._03 * matrix.m_matrixData._33);

			res.m_matrixData._10=(m_matrixData._10 * matrix.m_matrixData._00) + (m_matrixData._11 * matrix.m_matrixData._10) + (m_matrixData._12 * matrix.m_matrixData._20) + (m_matrixData._13 * matrix.m_matrixData._30);
			res.m_matrixData._11=(m_matrixData._10 * matrix.m_matrixData._01) + (m_matrixData._11 * matrix.m_matrixData._11) + (m_matrixData._12 * matrix.m_matrixData._21) + (m_matrixData._13 * matrix.m_matrixData._31);
			res.m_matrixData._12=(m_matrixData._10 * matrix.m_matrixData._02) + (m_matrixData._11 * matrix.m_matrixData._12) + (m_matrixData._12 * matrix.m_matrixData._22) + (m_matrixData._13 * matrix.m_matrixData._32);
			res.m_matrixData._13=(m_matrixData._10 * matrix.m_matrixData._03) + (m_matrixData._11 * matrix.m_matrixData._13) + (m_matrixData._12 * matrix.m_matrixData._23) + (m_matrixData._13 * matrix.m_matrixData._33);

			res.m_matrixData._20=(m_matrixData._20 * matrix.m_matrixData._00) + (m_matrixData._21 * matrix.m_matrixData._10) + (m_matrixData._22 * matrix.m_matrixData._20) + (m_matrixData._23 * matrix.m_matrixData._30);
			res.m_matrixData._21=(m_matrixData._20 * matrix.m_matrixData._01) + (m_matrixData._21 * matrix.m_matrixData._11) + (m_matrixData._22 * matrix.m_matrixData._21) + (m_matrixData._23 * matrix.m_matrixData._31);
			res.m_matrixData._22=(m_matrixData._20 * matrix.m_matrixData._02) + (m_matrixData._21 * matrix.m_matrixData._12) + (m_matrixData._22 * matrix.m_matrixData._22) + (m_matrixData._23 * matrix.m_matrixData._32);
			res.m_matrixData._23=(m_matrixData._20 * matrix.m_matrixData._03) + (m_matrixData._21 * matrix.m_matrixData._13) + (m_matrixData._22 * matrix.m_matrixData._23) + (m_matrixData._23 * matrix.m_matrixData._33);

			res.m_matrixData._30=(m_matrixData._30 * matrix.m_matrixData._00) + (m_matrixData._31 * matrix.m_matrixData._10) + (m_matrixData._32 * matrix.m_matrixData._20) + (m_matrixData._33 * matrix.m_matrixData._30);
			res.m_matrixData._31=(m_matrixData._30 * matrix.m_matrixData._01) + (m_matrixData._31 * matrix.m_matrixData._11) + (m_matrixData._32 * matrix.m_matrixData._21) + (m_matrixData._33 * matrix.m_matrixData._31);
			res.m_matrixData._32=(m_matrixData._30 * matrix.m_matrixData._02) + (m_matrixData._31 * matrix.m_matrixData._12) + (m_matrixData._32 * matrix.m_matrixData._22) + (m_matrixData._33 * matrix.m_matrixData._32);
			res.m_matrixData._33=(m_matrixData._30 * matrix.m_matrixData._03) + (m_matrixData._31 * matrix.m_matrixData._13) + (m_matrixData._32 * matrix.m_matrixData._23) + (m_matrixData._33 * matrix.m_matrixData._33);

			return res;

		}

		cVec4<ta> operator*(const cVec4<ta> &inVec)
		{
			cVec4<ta> ans = inVec;
			for(int i = 0; i < 4; i++)
			{
				ans[i] = getRow(i).dotProd(inVec);
			}
			return ans;
		}

		///Generates the translation matrix based on the inparameters.
		void toTranslateMatrix(const cVec3<ta> &m_position)
		{
			m_matrixData=m_identityMatrix;

			m_matrixData._03=m_position.x;
			m_matrixData._13=m_position.y;
			m_matrixData._23=m_position.z;

		}
		///Generates the scale matrix based on the inparameter.
		void toScaleMatrix(const cVec3f &m_scale)
		{
			m_matrixData=m_identityMatrix;

			m_matrixData._00=m_scale.x;
			m_matrixData._11=m_scale.y;
			m_matrixData._22=m_scale.z;
		}
		///Generates the rotation around z matrix based on the inparameter. The rotation is in radians
		void toRotateyzxMatrix(ta rads)
		{
			ta m_Cosine=(ta)cos(rads),m_Sine=(ta)sin(rads);
			m_matrixData=m_identityMatrix;

			m_matrixData._00= +m_Cosine;
			m_matrixData._01= -m_Sine;
			m_matrixData._10= +m_Sine;
			m_matrixData._11= +m_Cosine;
		}
		///Generates the rotation around x matrix based on the inparameter. The rotation is in radians
		void toRotatezxyMatrix(ta rads)
		{
			ta m_Cosine=(ta)cos(rads),m_Sine=(ta)sin(rads);
			m_matrixData=m_identityMatrix;

			m_matrixData._11= +m_Cosine;
			m_matrixData._12= -m_Sine;
			m_matrixData._21= +m_Sine;
			m_matrixData._22= +m_Cosine;
		}
		///Generates the rotation matrix around y based on the inparameter. The rotation is in radians
		void toRotatexyzMatrix(ta rads)
		{
			ta m_Cosine=(ta)cos(rads),m_Sine=(ta)sin(rads);
			m_matrixData=m_identityMatrix;

			m_matrixData._00= +m_Cosine;
			m_matrixData._02= +m_Sine;
			m_matrixData._20= -m_Sine;
			m_matrixData._22= +m_Cosine;
		}

		///Generates the perpsective matrix, with same parameters as gluPerspective. for this reason fovy is
		///angles and NOT radians.
		void toPerspective(ta fovy, ta aspect, ta zNear, ta zFar)
		{

		  ta radians = fovy/ta(180) * (float)M_PI;
		  ta tf=tan(radians/ta(2));
		  ta f = ta(1) / tf;
		  
		  setColumn(0,cVec4<ta> (tf/aspect, 0 , 0 , 0));
		  setColumn(1,cVec4<ta> (0, f , 0 , 0));
		  setColumn(2,cVec4<ta> (0, 0 , (zFar + zNear)/(zNear - zFar)  , -1));
		  setColumn(3,cVec4<ta> (0, 0 , (ta(2) * zFar * zNear) / (zNear - zFar) , 0));
		}

		///Generates a matrix that projects in orthographic mode.
		///takes same parameters as glOrtho
		void toOrtho(ta left, ta right,ta bottom,ta top, ta zNear, ta zFar)
		{
			ta rSubl = right - left;
			ta tSubb = top - bottom;
			ta fSubn = zFar - zNear;

			ta tx = -((right + left) / (rSubl));
			ta ty = -((top + bottom) / (tSubb));
			ta tz = -((zFar + zNear) / (fSubn));

			setColumn(0,cVec4<ta> (ta(2)/rSubl, 0 , 0 , 0));
			setColumn(1,cVec4<ta> (0, ta(2)/tSubb , 0 , 0));
			setColumn(2,cVec4<ta> (0, 0 , ta(-2)/fSubn , 0));
			setColumn(3,cVec4<ta> (tx, ty , tz , 1));
		}

		///Getting the row, starting at 0.
		cVec4f getRow(int row)const
		{
			if (row==0)
			{
				return cVec4f(m_matrixData._00,m_matrixData._01,m_matrixData._02,m_matrixData._03);
			}
			if (row==1)
			{
				return cVec4f(m_matrixData._10,m_matrixData._11,m_matrixData._12,m_matrixData._13);
			}
			if (row==2)
			{
				return cVec4f(m_matrixData._20,m_matrixData._21,m_matrixData._22,m_matrixData._23);
			}
			if (row==3)
			{
				return cVec4f(m_matrixData._30,m_matrixData._31,m_matrixData._32,m_matrixData._33);
			}
		}

		void setRow(int row,cVec4<ta> rowData)
		{
			if (row==0)
			{
				m_matrixData._00=rowData.x;
				m_matrixData._01=rowData.y;
				m_matrixData._02=rowData.z;
				m_matrixData._03=rowData.w;
				return;
			}
			if (row==1)
			{
				m_matrixData._10=rowData.x;
				m_matrixData._11=rowData.y;
				m_matrixData._12=rowData.z;
				m_matrixData._13=rowData.w;
				return;
			}
			if (row==2)
			{
				m_matrixData._20=rowData.x;
				m_matrixData._21=rowData.y;
				m_matrixData._22=rowData.z;
				m_matrixData._23=rowData.w;
				return;
			}
			if (row==3)
			{
				m_matrixData._30=rowData.x;
				m_matrixData._31=rowData.y;
				m_matrixData._32=rowData.z;
				m_matrixData._33=rowData.w;
				return;
			}
		}

		///Getting the Collumn starting at 0.
		cVec4f getColumn(int col)
		{
			if (col==0)
			{
				return cVec4f(m_matrixData._00,m_matrixData._10,m_matrixData._20,m_matrixData._30);
			}
			if (col==1)
			{
				return cVec4f(m_matrixData._01,m_matrixData._11,m_matrixData._21,m_matrixData._31);
			}
			if (col==2)
			{
				return cVec4f(m_matrixData._02,m_matrixData._12,m_matrixData._22,m_matrixData._32);
			}
			if (col==3)
			{
				return cVec4f(m_matrixData._03,m_matrixData._13,m_matrixData._23,m_matrixData._33);
			}
			//Dummy return to avoid warning
			return cVec4f(0,0,0,0);
		}

		void setColumn(int col,cVec4<ta> colData)
		{
			if (col==0)
			{	m_matrixData._00=colData.x;
				m_matrixData._10=colData.y;
				m_matrixData._20=colData.z;
				m_matrixData._30=colData.w;
				return;
			}
			if (col==1)
			{
				m_matrixData._01=colData.x;
				m_matrixData._11=colData.y;
				m_matrixData._21=colData.z;
				m_matrixData._31=colData.w;
				return;
			}
			if (col==2)
			{
				m_matrixData._02=colData.x;
				m_matrixData._12=colData.y;
				m_matrixData._22=colData.z;
				m_matrixData._32=colData.w;
				return;
			}
			if (col==3)
			{
				m_matrixData._03=colData.x;
				m_matrixData._13=colData.y;
				m_matrixData._23=colData.z;
				m_matrixData._33=colData.w;
				return;
			}
		}
		///Inversing the matrix through "rekkereduksjon".
            void invers()
		{
			m_matrixDataI=m_identityMatrix;

			m_V1=m_matrixData._00;
			m_matrixData._00=m_matrixData._00 / m_V1;	m_matrixData._01=m_matrixData._01 / m_V1;	m_matrixData._02=m_matrixData._02 / m_V1;	m_matrixData._03=m_matrixData._03 / m_V1;	/**/  m_matrixDataI._00=m_matrixDataI._00 / m_V1;	m_matrixDataI._01=m_matrixDataI._01 / m_V1;	m_matrixDataI._02=m_matrixDataI._02 / m_V1;	m_matrixDataI._03=m_matrixDataI._03 / m_V1;
			m_V2=m_matrixData._10;
			m_matrixData._10=m_matrixData._10 - (m_V2 * m_matrixData._00);	m_matrixData._11=m_matrixData._11 - (m_V2 * m_matrixData._01);	m_matrixData._12=m_matrixData._12 - (m_V2 * m_matrixData._02);	m_matrixData._13=m_matrixData._13 - (m_V2 * m_matrixData._03);	/**/ m_matrixDataI._10=m_matrixDataI._10 - (m_V2 * m_matrixDataI._00);	m_matrixDataI._11=m_matrixDataI._11 - (m_V2 * m_matrixDataI._01);	m_matrixDataI._12=m_matrixDataI._12 - (m_V2 * m_matrixDataI._02);	m_matrixDataI._13=m_matrixDataI._13 - (m_V2 * m_matrixDataI._03);
			m_V3=m_matrixData._20;
			m_matrixData._20=m_matrixData._20 - (m_V3 * m_matrixData._00);	m_matrixData._21=m_matrixData._21 - (m_V3 * m_matrixData._01);	m_matrixData._22=m_matrixData._22 - (m_V3 * m_matrixData._02);	m_matrixData._23=m_matrixData._23 - (m_V3 * m_matrixData._03);	/**/ m_matrixDataI._20=m_matrixDataI._20 - (m_V3 * m_matrixDataI._00);	m_matrixDataI._21=m_matrixDataI._21 - (m_V3 * m_matrixDataI._01);	m_matrixDataI._22=m_matrixDataI._22 - (m_V3 * m_matrixDataI._02);	m_matrixDataI._23=m_matrixDataI._23 - (m_V3 * m_matrixDataI._03);
			m_V4=m_matrixData._30;
			m_matrixData._30=m_matrixData._30 - (m_V4 * m_matrixData._00);	m_matrixData._31=m_matrixData._31 - (m_V4 * m_matrixData._01);	m_matrixData._32=m_matrixData._32 - (m_V4 * m_matrixData._02);	m_matrixData._33=m_matrixData._33 - (m_V4 * m_matrixData._03);	/**/ m_matrixDataI._30=m_matrixDataI._30 - (m_V4 * m_matrixDataI._00);	m_matrixDataI._31=m_matrixDataI._31 - (m_V4 * m_matrixDataI._01);	m_matrixDataI._32=m_matrixDataI._32 - (m_V4 * m_matrixDataI._02);	m_matrixDataI._33=m_matrixDataI._33 - (m_V4 * m_matrixDataI._03);


			m_V1=m_matrixData._11;
			m_matrixData._10=m_matrixData._10 / m_V1;	m_matrixData._11=m_matrixData._11 / m_V1;	m_matrixData._12=m_matrixData._12 / m_V1;	m_matrixData._13=m_matrixData._13 / m_V1; /**/ m_matrixDataI._10=m_matrixDataI._10 / m_V1;	m_matrixDataI._11=m_matrixDataI._11 / m_V1;	m_matrixDataI._12=m_matrixDataI._12 / m_V1;m_matrixDataI._13=m_matrixDataI._13 / m_V1;
			m_V2=m_matrixData._01;
			m_matrixData._00=m_matrixData._00 - (m_V2 * m_matrixData._10); m_matrixData._01=m_matrixData._01 - (m_V2 * m_matrixData._11);	m_matrixData._02=m_matrixData._02 - (m_V2 * m_matrixData._12); m_matrixData._03=m_matrixData._03 - (m_V2 * m_matrixData._13);	/**/ m_matrixDataI._00=m_matrixDataI._00 - (m_V2 * m_matrixDataI._10); m_matrixDataI._01=m_matrixDataI._01 - (m_V2 * m_matrixDataI._11);	m_matrixDataI._02=m_matrixDataI._02 - (m_V2 * m_matrixDataI._12);	m_matrixDataI._03=m_matrixDataI._03 - (m_V2 * m_matrixDataI._13);
			m_V3=m_matrixData._21;
			m_matrixData._20=m_matrixData._20 - (m_V3 * m_matrixData._10); m_matrixData._21=m_matrixData._21 - (m_V3 * m_matrixData._11);	m_matrixData._22=m_matrixData._22 - (m_V3 * m_matrixData._12); m_matrixData._23=m_matrixData._23 - (m_V3 * m_matrixData._13); /**/ m_matrixDataI._20=m_matrixDataI._20 - (m_V3 * m_matrixDataI._10); m_matrixDataI._21=m_matrixDataI._21 - (m_V3 * m_matrixDataI._11);	m_matrixDataI._22=m_matrixDataI._22 - (m_V3 * m_matrixDataI._12);	m_matrixDataI._23=m_matrixDataI._23 - (m_V3 * m_matrixDataI._13);
			m_V4=m_matrixData._31;
			m_matrixData._30=m_matrixData._30 - (m_V4 * m_matrixData._10); m_matrixData._31=m_matrixData._31 - (m_V4 * m_matrixData._11);	m_matrixData._32=m_matrixData._32 - (m_V4 * m_matrixData._12); m_matrixData._33=m_matrixData._33 - (m_V4 * m_matrixData._13); /**/ m_matrixDataI._30=m_matrixDataI._30 - (m_V4 * m_matrixDataI._10); m_matrixDataI._31=m_matrixDataI._31 - (m_V4 * m_matrixDataI._11);	m_matrixDataI._32=m_matrixDataI._32 - (m_V4 * m_matrixDataI._12);	m_matrixDataI._33=m_matrixDataI._33 - (m_V4 * m_matrixDataI._13);


			m_V1=m_matrixData._22;
			m_matrixData._20=m_matrixData._20 / m_V1; m_matrixData._21=m_matrixData._21 / m_V1; m_matrixData._22=m_matrixData._22 / m_V1; m_matrixData._23=m_matrixData._23 / m_V1; /**/ m_matrixDataI._20=m_matrixDataI._20 / m_V1; m_matrixDataI._21=m_matrixDataI._21 / m_V1;	m_matrixDataI._22=m_matrixDataI._22 / m_V1;m_matrixDataI._23=m_matrixDataI._23 / m_V1;
			m_V2=m_matrixData._02;
			m_matrixData._00=m_matrixData._00 - (m_V2 * m_matrixData._20); m_matrixData._01=m_matrixData._01 - (m_V2 * m_matrixData._21);	m_matrixData._02=m_matrixData._02 - (m_V2 * m_matrixData._22); m_matrixData._03=m_matrixData._03 - (m_V2 * m_matrixData._23);/**/ m_matrixDataI._00=m_matrixDataI._00 - (m_V2 * m_matrixDataI._20); m_matrixDataI._01=m_matrixDataI._01 - (m_V2 * m_matrixDataI._21);	m_matrixDataI._02=m_matrixDataI._02 - (m_V2 * m_matrixDataI._22);	m_matrixDataI._03=m_matrixDataI._03 - (m_V2 * m_matrixDataI._23);
			m_V3=m_matrixData._12;
			m_matrixData._10=m_matrixData._10 - (m_V3 * m_matrixData._20); m_matrixData._11=m_matrixData._11 - (m_V3 * m_matrixData._21); m_matrixData._12=m_matrixData._12 - (m_V3 * m_matrixData._22); m_matrixData._13=m_matrixData._13 - (m_V3 * m_matrixData._23);/**/ m_matrixDataI._10=m_matrixDataI._10 - (m_V3 * m_matrixDataI._20); m_matrixDataI._11=m_matrixDataI._11 - (m_V3 * m_matrixDataI._21);	m_matrixDataI._12=m_matrixDataI._12 - (m_V3 * m_matrixDataI._22);	m_matrixDataI._13=m_matrixDataI._13 - (m_V3 * m_matrixDataI._23);
			m_V4=m_matrixData._32;
			m_matrixData._30=m_matrixData._30 - (m_V4 * m_matrixData._20); m_matrixData._31=m_matrixData._31 - (m_V4 * m_matrixData._21); m_matrixData._32=m_matrixData._32 - (m_V4 * m_matrixData._22); m_matrixData._33=m_matrixData._33 - (m_V4 * m_matrixData._23);/**/ m_matrixDataI._30=m_matrixDataI._30 - (m_V4 * m_matrixDataI._20); m_matrixDataI._31=m_matrixDataI._31 - (m_V4 * m_matrixDataI._21);	m_matrixDataI._32=m_matrixDataI._32 - (m_V4 * m_matrixDataI._22);	m_matrixDataI._33=m_matrixDataI._33 - (m_V4 * m_matrixDataI._23);


			m_V1=m_matrixData._33;
			m_matrixData._30=m_matrixData._30 / m_V1; m_matrixData._31=m_matrixData._31 / m_V1; m_matrixData._32=m_matrixData._32 / m_V1; m_matrixData._33=m_matrixData._33 / m_V1; /**/ m_matrixDataI._30=m_matrixDataI._30 / m_V1; m_matrixDataI._31=m_matrixDataI._31 / m_V1;	m_matrixDataI._32=m_matrixDataI._32 / m_V1;m_matrixDataI._33=m_matrixDataI._33 / m_V1;
			m_V2=m_matrixData._03;
			m_matrixData._00=m_matrixData._00 - (m_V2 * m_matrixData._30); m_matrixData._01=m_matrixData._01 - (m_V2 * m_matrixData._31); m_matrixData._02=m_matrixData._02 - (m_V2 * m_matrixData._32); m_matrixData._03=m_matrixData._03 - (m_V2 * m_matrixData._33);/**/ m_matrixDataI._00=m_matrixDataI._00 - (m_V2 * m_matrixDataI._30); m_matrixDataI._01=m_matrixDataI._01 - (m_V2 * m_matrixDataI._31);	m_matrixDataI._02=m_matrixDataI._02 - (m_V2 * m_matrixDataI._32);	m_matrixDataI._03=m_matrixDataI._03 - (m_V2 * m_matrixDataI._33);
			m_V3=m_matrixData._13;
			m_matrixData._10=m_matrixData._10 - (m_V3 * m_matrixData._30); m_matrixData._11=m_matrixData._11 - (m_V3 * m_matrixData._31); m_matrixData._12=m_matrixData._12 - (m_V3 * m_matrixData._32); m_matrixData._13=m_matrixData._13 - (m_V3 * m_matrixData._33);/**/ m_matrixDataI._10=m_matrixDataI._10 - (m_V3 * m_matrixDataI._30); m_matrixDataI._11=m_matrixDataI._11 - (m_V3 * m_matrixDataI._31);	m_matrixDataI._12=m_matrixDataI._12 - (m_V3 * m_matrixDataI._32);	m_matrixDataI._13=m_matrixDataI._13 - (m_V3 * m_matrixDataI._33);
			m_V4=m_matrixData._23;
			m_matrixData._20=m_matrixData._20 - (m_V4 * m_matrixData._30); m_matrixData._21=m_matrixData._21 - (m_V4 * m_matrixData._31); m_matrixData._22=m_matrixData._22 - (m_V4 * m_matrixData._32); m_matrixData._23=m_matrixData._23 - (m_V4 * m_matrixData._33);/**/ m_matrixDataI._20=m_matrixDataI._20 - (m_V4 * m_matrixDataI._30); m_matrixDataI._21=m_matrixDataI._21 - (m_V4 * m_matrixDataI._31); m_matrixDataI._22=m_matrixDataI._22 - (m_V4 * m_matrixDataI._32); m_matrixDataI._23=m_matrixDataI._23 - (m_V4 * m_matrixDataI._33);

			m_matrixData=m_matrixDataI;

		}
		///Transposing the matrix.
		void transpose()
		{
			cMatrix4 mat = *this;
			for(int i=0; i < 4; i++)
			{
				this->setColumn(i,mat.getRow(i));
			}
		}
		
	  ///Generates the identity matrix.
		void toIdentityMatrix()
		{
			m_matrixData=m_identityMatrix;
		}

	  void toLookAt(const cVec3f &eye,
			const cVec3f &target,
			const cVec3f &up)
	  {
	    cMatrix4<ta> trans;
	    cVec3<ta> F = target - eye;
	    F.normalize();
	    cVec3<ta> UP = up.getNormalized();

	    cVec3<ta> s = F.crossProd(UP);
	    cVec3<ta> u = s.crossProd(F);
	    s.normalize();
	    u.normalize();
	    setColumn(0,cVec4<ta>(s.x,u.x,-F.x,0));
	    setColumn(1,cVec4<ta>(s.y,u.y,-F.y,0));
	    setColumn(2,cVec4<ta>(s.z,u.z,-F.z,0));
	    setColumn(3,cVec4<ta>(0,0,0,1));
	    
	    trans.toTranslateMatrix(-eye);
	    (*this) *= trans;
	  }
	  
		///Holding the actually matrix data.
		sData4<ta> m_matrixData;

	private:
		///Holding the identity matrix at all time.
		sData4<ta> m_identityMatrix;
		///Helping structure, used in the function inverse etc.
		sData4<ta> m_matrixDataI;
		///Helping structures, used in the function inverse etc.
		ta m_V1,m_V2,m_V3,m_V4;

	};
}
#endif

