/*******************************************************

Original Author...Tor Jonas Onsrud
Purpose...........quaternion math

Description:
This is a quaternion math class for fusausion.
It is templetized to support different types.

********************************************************/
//TODO:
/*
- needs to be tested out in action.
*/

#ifndef H_xxFUSA_QUATxx_H
#define H_xxFUSA_QUATxx_H

#include "fusa_vectormath.h"
#include "fusa_MATRIX4.h"
#include "fusa_MATRIX3.h"

#include <iostream>
namespace fusa
{
	template <class ta>
	/*
	@class cQuat
	@brief cQuat is a mathematical rotation structure. the datatype is templetized
	*/
	class cQuat
	{
	public:
		cQuat()
		{	
			m_w=1;
			m_vec.x=0;
			m_vec.y=0;
			m_vec.z=0;

		}
		///Setting the quaternion
		cQuat(ta m_inU,ta m_inX,ta m_inY,ta m_inZ)
		{
			m_w=m_inU;
			m_vec.x=m_inX;
			m_vec.y=m_inY;
			m_vec.z=m_inZ;			
		}
		///Setting the quaternion based on a rotation and a vector.The rotation is in radians.
		cQuat(ta rads,const cVec3<ta> &inVec)
		{
			//take -rads to make it behave like opengl.
			rads = rads;
			m_w=cos(rads/2);
			cVec3<ta> m_vecTemp=inVec;
			m_vecTemp.normalize();
			m_vecTemp=m_vecTemp * sin(rads/2);
			m_vec.x=m_vecTemp.x;
			m_vec.y=m_vecTemp.y;
			m_vec.z=m_vecTemp.z;

			//m_w=m_inW;
			//m_vec=m_inVec;
			
		}
		~cQuat(){;}
		///Adding together two quaternions
		cQuat operator +(const cQuat &inQuat)const
		{
			ta wI=m_w + inQuat.m_w;
			cVec3<ta> vecI=m_vec + inQuat.m_vec;	
			return cQuat(wI,vecI);
		}
		//float operator *(cQuat m_inQuat) //M kanskje gjres om slik at det ikke brukes operator trigger her.
		//{
	//		return (m_w * m_inQuat.m_w) + (m_vec.x * m_inQuat.m_vec.y) + (m_vec.y * m_inQuat.m_vec.y) + (m_vec.z * m_inQuat.m_vec.y); 
	//	}
		
		void conjugateMe()
		{
			m_vec*=-1;
		}
		
		cQuat<ta> conjugate()const
		{
			cQuat<ta> result = *this;
			result.conjugateMe();
			return result;
		}

		ta norm()
		{
			///Kanskje ta rota av hele utrykket til slutt??
			return sqrt(pow(m_w,2) + pow(m_vec.x,2) + pow(m_vec.y,2) + pow(m_vec.z,2));
		}
		void inverseMe()
		{
			conjugateMe();
			ta n=norm();

			m_w=m_w/n;
			m_vec/=n;
		}

		cQuat<ta> inverse()const
		{
			cQuat<ta> result = *this;
			result.inverseMe();
			return result;
		}

		///Operator overloaded, multiplying two quaternions and leave the result in the first quaternion.
		void operator*=(const cQuat &b)
		{
			*this = *this * b;
		}
		///Operator overloaded, multiplying two quaternions and returning the new one.
		cQuat operator*(const cQuat &b)const
		{
			/*cQuat res;
			res.m_vec = this->m_vec.crossProd(b.m_vec) + b.m_w * this->m_vec + this->m_w * b.m_vec;
			res.m_w = this->m_w * b.m_w - this->m_vec.dotProd(b.m_vec);
			return res;*/

			return cQuat(m_w*b.m_w - m_vec.x*b.m_vec.x - m_vec.y*b.m_vec.y - m_vec.z*b.m_vec.z,
						 m_w*b.m_vec.x + m_vec.x*b.m_w + m_vec.y*b.m_vec.z - m_vec.z*b.m_vec.y,
						 m_w*b.m_vec.y + m_vec.y*b.m_w + m_vec.z*b.m_vec.x - m_vec.x*b.m_vec.z,
						 m_w*b.m_vec.z + m_vec.z*b.m_w + m_vec.x*b.m_vec.y - m_vec.y*b.m_vec.x);
		}
		///Operator overloaded, multiplying a quaternion with a vector and returning a vector/point.
		cVec3<ta> operator*(const cVec3<ta> &v)const
		{
			cQuat temp(1,v.x,v.y,v.z);
			temp = *this * temp * this->conjugate();
			return temp.m_vec;
		}
		///Rotating the current quaternion.
		void rotate(ta rads,const cVec3<ta> &inVec)
		{
			cQuat<ta> temp(rads,inVec);
			(*this)*=temp;
					
		
		}

		///sets the quaternion to this rotation.
		void setRotation(ta rads,const cVec3<ta> &inVec)
		{
			//take -rads to make it behave like opengl.
			rads = rads;
			m_w=cos(rads/ta(2));
			cVec3<ta> m_vecTemp=inVec;
			m_vecTemp.normalize();
			m_vecTemp=m_vecTemp * sin(rads/ta(2));
			m_vec.x=m_vecTemp.x;
			m_vec.y=m_vecTemp.y;
			m_vec.z=m_vecTemp.z;
		}
		
		///Converting the quaternion to a matrix4 and returning it.
		cMatrix4<ta> getMatrix4()const //s493
		{	
			cMatrix4<ta> result;
			float wx,wy,wz,xx,yy,yz,xy,xz,zz,x2,y2,z2;

			x2=m_vec.x + m_vec.x;
			y2=m_vec.y + m_vec.y;
			z2=m_vec.z + m_vec.z;

			xx=m_vec.x * x2; xy=m_vec.x * y2; xz=m_vec.x * z2;
			yy=m_vec.y * y2; yz=m_vec.y * z2; zz=m_vec.z * z2; 
			wx=m_w * x2;	 wy = m_w * y2;	  wz=m_w * z2;

			//first is row, second is column.

			result.m_matrixData._00=1.0 - (yy + zz); result.m_matrixData._01=xy -wz;
			result.m_matrixData._02=xz + wy; result.m_matrixData._03=0.0;
			result.m_matrixData._10=xy + wz; result.m_matrixData._11=1.0 - (xx + zz);
			result.m_matrixData._12=yz - wx; result.m_matrixData._13=0.0;
			result.m_matrixData._20=xz - wy; result.m_matrixData._21=yz + wx;
			result.m_matrixData._22=1.0 - (xx + yy); result.m_matrixData._23=0.0;
			result.m_matrixData._30=0.0; result.m_matrixData._31=0;
			result.m_matrixData._32=0.0; result.m_matrixData._33=1;

			
			return result;
		}
		///Converting the quaternion to a matrix3 and returning it.
		cMatrix3<ta> getMatrix3()const
		{
			float wx,wy,wz,xx,yy,yz,xy,xz,zz,x2,y2,z2;

			x2=m_vec.x + m_vec.x;
			y2=m_vec.y + m_vec.y;
			z2=m_vec.z + m_vec.z;

			xx=m_vec.x * x2; xy=m_vec.x * y2; xz=m_vec.x * z2;
			yy=m_vec.y * y2; yz=m_vec.y * z2; zz=m_vec.z * z2; 
			wx=m_w * x2;	 wy = m_w * 2;	  wz=m_w * z2;

			cMatrix3<ta> m_matrix;
			m_matrix.m_matrixData._00=1.0 - (yy + zz); m_matrix.m_matrixData._10=xy -wz;
			m_matrix.m_matrixData._20=xz + wy; m_matrix.m_matrixData._30=0.0;
			m_matrix.m_matrixData._01=xy + wz; m_matrix.m_matrixData._11=1.0 - (xx + zz);
			m_matrix.m_matrixData._21=yz - wx; m_matrix.m_matrixData._31=0.0;
			m_matrix.m_matrixData._02=xz - wy; m_matrix.m_matrixData._12=yz + wx;
			m_matrix.m_matrixData._22=1.0 - (xx + yy); m_matrix.m_matrixData._32=0.0;
			m_matrix.m_matrixData._03=0.0; m_matrix.m_matrixData._13=0;
			m_matrix.m_matrixData._23=0.0; m_matrix.m_matrixData._33=1;

			//m_matrix.transpose();
			/*return cMatrix3<ta> (1.0 - (yy + zz),xy + wz,xz - wy,
								xy -wz,1.0 - (xx + zz),yz + wx,
								xz + wy,yz - wx,1.0);*/
			return m_matrix;
		}
		//Getting the quaternion vecpart.
		cVec3<ta>& VecPart()
		{
			return m_vec;
		}
		//Getting the quaternion vecPart.
		const cVec3<ta>& VecPart()const
		{
			return m_vec;
		}
		//Getting the quaternion realPart.
		ta& RealPart()
		{
			return m_w;
		}
		//Getting the quaternion realPart.
		ta RealPart()const
		{
			return m_w;
		}
		// Getting the quaternion dot product.
		ta dot(cQuat<ta> b)const
		{
			return m_w*b.m_w + m_vec.x*b.m_vec.x + m_vec.y*b.m_vec.y,m_vec.z*b.m_vec.z;
		}
		

	private:
		///Holding the actually quaternion data.
		ta m_w;
		cVec3<ta> m_vec;
		
		

	};

}

#endif
