#include "fusa_mathincludes.h"

using namespace fusa;



namespace fusa
{


	cVec3f from2DClipSpaceToWorldSpace(const cVec2f &clipCoord, const cMatrix4<float> &projection,const cMatrix4<float> &camera)
	{
		cMatrix4<float> mat=(projection);
		mat.invers();
		cMatrix4<float> mat2=(camera);
		mat2.invers();
		cVec4f tmp = mat * cVec4f(clipCoord.x,clipCoord.y,0,1);
		tmp = tmp/tmp.w;
		tmp = mat2*tmp;

		return  cVec3f (tmp.x,tmp.y,tmp.z);

	}

	void mergeSpheres(const cVec3f &sphere1,const cVec3f &sphere2,float r1,float r2, cVec3f &resSpherePos,float &resRad)
	{
		resSpherePos = sphere2-sphere1;
		//discover if one is inside the other.
		float sphereDis = abs(resSpherePos.magnitude());
		if(sphereDis < r1 + r2)
		{
			//find out which is smallest of them
			if(r1 < r2)
			{
				resRad = r2;
				resSpherePos = sphere2;
				return;
			}
			resRad = r1;
			resSpherePos = sphere1;
			return;
		}
		resRad = sphereDis + r1 + r2;
		resSpherePos = sphere1 + resSpherePos*0.5;
	}

}
