/*******************************************************

Original Author...Hvard Christensen
Purpose...........Various Math Funcs

Description:

********************************************************/

#ifndef H_xxFUSA_MATHFUNCSxx_H
#define H_xxFUSA_MATHFUNCSxx_H
#ifndef M_PI
#define M_PI 3.1415926535897932384626433832795
#endif
namespace fusa
{
	//any regular math functions which is needed, but not in standard libs can be put here.

	///clamps a value t between min and max.
	inline float clamp(float t,float min,float max)
	{
		if(t>max)
		{
			return max;
		}
		else if(t<min)
		{
			return min;
		}
		return t;
	}

	///if val is less than 0, it returns -1 , otheriwse it returns 1.
	inline float sign(float val)
	{
		return val<0 ? -1.0f : 1.0f;
	}

	inline int sign(int val)
	{
		return val<0 ? -1 : 1;
	}

	inline float sfrand()
	{
		return (rand() * 2.0f / (float) RAND_MAX) - 1.0f;
	}

	inline bool epsCheck(double val1,double val2,double eps=0.00001)
	{
		return ( (val1-eps) <= val2 && (val1+eps) >= val2);
	}
	
}

//hack, we create overloaded functions for our fixed point types (overload abs, sin,cos, tan, acos, etc.
//FIX_ME , write these optimizations
namespace std
{

}

#endif
