/*******************************************************

Original Author...Håvard Christensen
Purpose...........

*/

#ifndef H_xxFUSA_FRAMEBUFFERxx_H
#define H_xxFUSA_FRAMEBUFFERxx_H

#include "../graphicIncludes.h"
#include "../math/fusa_mathincludes.h"
#include <stack>

namespace fusa
{
	inline void checkErrors(const char *message=0)
	{
		if(message)
		std::cout<<message<<std::endl;
		GLenum error = glGetError();
		while(error != GL_NO_ERROR)
		{
			std::cout<<"gl error:"<<error<<std::endl;
			error = glGetError();
		}
	}
  ///Allows for FBO support
  class cFrameBuffer
  {
  public:
    cFrameBuffer(int sizeX,int sizeY,GLint bufferTypes);
    virtual void start()=0;
    virtual void finish()=0;
    virtual void clear()=0;
    void setClearColor(const cVec4f &clearCol);
    const cVec4f& getClearColor()const;
    void setAutoClear(bool trueFalse);
    bool getAutoClear()const;
    void setSize(const cVec2f &s)
    {
      m_size = s;
    }
	const cVec2f& getSize()const;
  protected:
    GLint getGLBufferTypes();
   
    virtual void resume();
    void stackResume();
    static std::stack<cFrameBuffer*> fbStack;

  private:
    cVec4f m_clearColor;
    cVec2f m_size;
    GLint m_buffTypes;
    bool m_autoClear;

  };

  class cDirectFrameBuffer : public cFrameBuffer
  {
  public:
    cDirectFrameBuffer(int sizeX,int sizeY,GLint bufferTypes);
    void start();
    void finish();
    void clear();
  };

  class cRenderBuffer
  {
  public:
    cRenderBuffer(int sizeX,int sizeY,GLint storage);
    GLuint m_renderBuffer;
  };

  class cRenderableTexture;
  class cOffscreenFrameBuffer : public cFrameBuffer
  {
  public:
    cOffscreenFrameBuffer(int sizeX,int sizeY,GLint bufferTypes);
    
    void setDrawAndReadBuffer(GLint drawBuffer,GLint readBuffer);
	void setDrawBuffers(const GLenum *drawBuffers,int numBuffs);


    void attachRenderBuffer(cRenderBuffer* buff,
			    GLint attachmentPoint);
    void attachTexture(cRenderableTexture* texture,
		       GLint attachmentPoint,
		       int miplevel=0);
    
    void start();
    void finish();
    void clear();
    GLuint m_framebuffer;

    bool checkCompleteness();
    std::vector<cRenderableTexture*> attachedTextures;


  };
}
#endif
