#include "fusa_material.h"
#include <fstream>
#include <string>
#include "../fusa.h"
using namespace fusa;

void cMaterial::loadFromFile(const std::string &filename)
{
  std::ifstream f_in;
  f_in.open(filename.c_str());
  std::string parse;
  
  readTextParameter(f_in,parse);
  if(glEnumLookup(parse)==GL_TRUE)
    m_zBufferTesting = true;
  else
    m_zBufferTesting = false;

  readTextParameter(f_in,parse);
  if(glEnumLookup(parse)==GL_TRUE)
    m_zBufferWriting = true;
  else
    m_zBufferWriting = false;

  std::getline(f_in,parse,':');
  f_in>>m_lineWidth;
  std::getline(f_in,parse,':');
  f_in>>m_pointSize;
  readTextParameter(f_in,parse);
  m_primitiveMode = glEnumLookup(parse);
  m_cullFace = glEnumLookup(parse);
  readTextParameter(f_in,parse);
  if(glEnumLookup(parse)==GL_TRUE)
    m_cullEnabled = true;
  else
    m_cullEnabled = false;

  readTextParameter(f_in,parse);
  m_blendSrc = glEnumLookup(parse);
  readTextParameter(f_in,parse);
  m_blendDst = glEnumLookup(parse);

  readTextParameter(f_in,parse);
  if(glEnumLookup(parse)==GL_TRUE)
    m_isBlending = true;
  else
    m_isBlending = false;

  int nrOfVertexShaders=0;
  std::getline(f_in,parse,':');
  f_in>>nrOfVertexShaders;
  std::vector<std::string> vertexFiles;
  for(unsigned int i=0; i < nrOfVertexShaders; i++)
    {
      readTextParameter(f_in,parse);
      vertexFiles.push_back(parse);
    }

  int nrOfPixelShaders=0;
  std::getline(f_in,parse,':');
  f_in>>nrOfPixelShaders;
  std::vector<std::string> pixelFiles;
  for(unsigned int i=0; i < nrOfPixelShaders; i++)
    {
      readTextParameter(f_in,parse);
      pixelFiles.push_back(parse);
    }

  if(m_shader)
    m_shader->load(vertexFiles,pixelFiles);
  else
    {
      m_shader = new cFileShader;
      m_shader->load(vertexFiles,pixelFiles);
    }
  
}

