#include "fusa_renderer.h"
#include "../fusa.h"
#include <list>
using namespace fusa;

void fusa::drawNode(cSpatialNode *nd,cShader* sh,GLint drawMode)
{
  std::list<cSpatialNode*>::iterator it=  nd->ChildList().begin();
  while(it!=nd->ChildList().end())
    {
      drawNode(*it,sh);
      it++;
    }
  if(nd->getNodeType()==cSpatialNode::ntGeometry)
    {
      cGeometryNode *gmn = static_cast<cGeometryNode*> (nd);
      if(gmn->mptr_hMesh)
	{
	  gmn->mptr_hMesh->draw(sh,drawMode);
	}
      
    }
}

void fusa::setPerspective(cMatrix4<float> &m,
		      float fov,float aspect,float near,float far)
{
  glMatrixMode(GL_PROJECTION);
  glPushMatrix();
  glLoadIdentity();
  gluPerspective(fov,aspect,near,far);
  glGetFloatv(GL_PROJECTION_MATRIX, &m.m_matrixData._00);
  glPopMatrix();
  glMatrixMode(GL_MODELVIEW);
}

void fusa::setOglMatrix(cMatrix4<float> &m,
						GLint matrix)
{
  glMatrixMode(matrix);
  glLoadMatrixf(&m.m_matrixData._00);
  glMatrixMode(GL_MODELVIEW);
}

void fusa::setCamera(cMatrix4<float> &cam, cMatrix4<float> &proj)
{
  glMatrixMode(GL_MODELVIEW);
  glMultMatrixf(&cam.m_matrixData._00);
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  glMultMatrixf(&proj.m_matrixData._00);
  glMatrixMode(GL_MODELVIEW);
}
