#include "../graphicIncludes.h"
#include "fusa_shader.h"
#include "../common/fusa_logging.h"
#include <fstream>
using namespace fusa;


cVertexProgram::cVertexProgram()
{
  m_vertProg = -1;
}

bool cVertexProgram::compile()
{
  std::string program;
  for(unsigned int i=0; i < SourceCode().size(); i++)
    {
      program+=SourceCode()[i]+"\n";
    }
  if(m_vertProg!=-1)
    {
      glDeleteShader(m_vertProg);
    }
  m_vertProg = glCreateShader(GL_VERTEX_SHADER);
  const char* sourcePtr = program.c_str();
  int size = program.size();
  glShaderSource(m_vertProg,1,&sourcePtr,&size);
  glCompileShader(m_vertProg);

  GLint noErrors;
  glGetShaderiv(m_vertProg,GL_COMPILE_STATUS,&noErrors);
  if(noErrors==GL_FALSE)
    {
      int length=0;
      glGetShaderiv(m_vertProg,GL_INFO_LOG_LENGTH,&length);
      char *log = new char[length+1];
      glGetShaderInfoLog(m_vertProg,length,0,log);
      logger<<log<<std::endl;
      delete[] log;
      return false;
    }

  return true;
}

cFragmentProgram::cFragmentProgram()
{
  m_fragProg = -1;
}

bool cFragmentProgram::compile()
{

  std::string program;
  for(unsigned int i=0; i < SourceCode().size(); i++)
    {
      program+=SourceCode()[i]+"\n";
    }
  if(m_fragProg!=-1)
    {
      glDeleteShader(m_fragProg);
    }
  m_fragProg = glCreateShader(GL_FRAGMENT_SHADER);
  const char* sourcePtr = program.c_str();
  int size = program.size();

  glShaderSource(m_fragProg,1,&sourcePtr,&size);

  glCompileShader(m_fragProg);

  GLint noErrors;
  glGetShaderiv(m_fragProg,GL_COMPILE_STATUS,&noErrors);
  if(noErrors==GL_FALSE)
    {
      int length=0;
      glGetShaderiv(m_fragProg,GL_INFO_LOG_LENGTH,&length);
      char *log = new char[length+1];
      glGetShaderInfoLog(m_fragProg,length,0,log);
      logger<<log<<std::endl;
      delete[] log;
      return false;
    }

  return true;
}

cShader::cShader()
{
  m_shaderProgram = -1;
}

GLint cShader::getAttribLocation(const std::string &attribName)
{
  if(m_shaderProgram==-1)
    return -1;

  std::map<std::string,GLint>::iterator it = m_attribLocs.find(attribName);
  GLint loc=-1;
  if(it==m_attribLocs.end())
    {

      activate();
      loc = glGetAttribLocation(m_shaderProgram,attribName.c_str());
      m_attribLocs[attribName]=loc;
    }
  else
    {
      loc = m_attribLocs[attribName];
    }
  return loc;
}

GLint cShader::getUniformLocation(const std::string &uniformName)
{
  if(m_shaderProgram==-1)
    return -1;
  activate();
  return  glGetUniformLocation(m_shaderProgram,uniformName.c_str());
}

bool cShader::compileAndLink()
{
  m_attribLocs.clear();
  if(m_shaderProgram!=-1)
    {
      glDeleteShader(m_shaderProgram);
    }
  m_shaderProgram = glCreateProgram();
  if(!m_vertProg.compile())
    {
      return false;
    }
  if(!m_fragProg.compile())
    {
      return false;
    }
  glAttachShader(m_shaderProgram,m_fragProg.getProgram());
  glAttachShader(m_shaderProgram,m_vertProg.getProgram());
  glLinkProgram(m_shaderProgram);
  return true;
}

void cShader::activate()
{
  if(m_shaderProgram!=-1)
    glUseProgram(m_shaderProgram);
}







void cFileShader::load(const std::vector<std::string> &vertFiles,
		       const std::vector<std::string> &fragFiles)
{
  for(unsigned int i = 0; i < vertFiles.size(); i++)
    {
      std::ifstream f_in;
	  std::string fn = "data\\" + vertFiles[i];
      f_in.open(fn.c_str());
      if(!f_in.is_open())
	{
	  logger<<"file error:"<<vertFiles[i]<<std::endl;
	  return;
	}
      std::string sourceLine;
      std::getline(f_in,sourceLine);
      while(f_in.good())
	{
	  VertProg().SourceCode().push_back(sourceLine);
	  std::getline(f_in,sourceLine);
	}
      VertProg().SourceCode().push_back(sourceLine);
    }
 
  for(unsigned int i = 0; i < fragFiles.size(); i++)
    {
      std::ifstream f_in;
	  std::string fn = "data\\" + fragFiles[i];
      f_in.open(fn.c_str());
      if(!f_in.is_open())
	{
	  logger<<"file error:"<<fragFiles[i]<<std::endl;
	  return;
	}
      std::string sourceLine;
      std::getline(f_in,sourceLine);
      while(f_in.good())
	{
	  FragProg().SourceCode().push_back(sourceLine);
	  std::getline(f_in,sourceLine);
	}
	  FragProg().SourceCode().push_back(sourceLine);
    }
  if(!compileAndLink())
    {
      logger<<"compile and link failed"<<std::endl;
      return;
    }
}
void cFileShader::load(const std::string &vertFile,
		       const std::string &fragFile)
{
  std::vector<std::string> vFiles;
  vFiles.push_back(vertFile);
  std::vector<std::string> fFiles;
  fFiles.push_back(fragFile);
  load(vFiles,fFiles);
}


void cShVarVec2f::send()
{
  if(m_shaderProg!=-1 && m_location!=-1)
    {
      glUseProgram(m_shaderProg);
      glUniform2fv(m_location,1,&(x));
    }
}

void cShVarVec3f::send()
{
  if(m_shaderProg!=-1 && m_location!=-1)
    {
      glUseProgram(m_shaderProg);
      glUniform3fv(m_location,1,&(x));
    }
}

void cShVarVec4f::send()
{
  if(m_shaderProg!=-1 && m_location!=-1)
    {
      glUseProgram(m_shaderProg);
      glUniform4fv(m_location,1,&(x));
    }
}

void cShVarMat4f::send()
{
  if(m_shaderProg!=-1 && m_location!=-1)
    {
      glUseProgram(m_shaderProg);
      glUniformMatrix4fv(m_location,1,false,&(m_matrixData._00));
    }
}
