#ifndef H_xxFUSA_MESHxx_H
#define H_xxFUSA_MESHxx_H
#include "../math/fusa_mathincludes.h"
#include "../graphicIncludes.h"
#include <vector>
#include <map>
/*******************************************************

Original Author...Hvard Christensen
Purpose...........Mesh structure

//TODO:
/*
- Add fix-point support (very important)
*/


namespace fusa
{

  /*!
    @class sFace
    @brief This is a face structure.
  */
  struct sFace
  {
    sFace()
    {
      v1=v2=v3=0;
    }
    sFace(unsigned int V1,unsigned int V2, unsigned int V3)
    {
      v1 = V1;
      v2 = V2;
      v3 = V3;
    }
    sFace(const sFace &v)
    {
      v1 = v.v1;
      v2 = v.v2;
      v3 = v.v3;
    }
    unsigned int v1,v2,v3;
  };

  struct sMultiIndexedMesh
  {
	  std::map<std::string,std::vector<unsigned int> > smoothingGroupForAttributes;
	  std::map<std::string,std::vector<unsigned int> > indexForAttributes;
	  
	  std::vector<unsigned int> vertexIndices;
	  std::vector<cVec3f> vertices;

	  std::map<std::string,std::vector<float> > attributeData;
	  std::map<std::string,std::vector<cVec2f> > attributeDataVec2;
	  std::map<std::string,std::vector<cVec3f> > attributeDataVec3;
	  std::map<std::string,std::vector<cVec4f> > attributeDataVec4;
	  std::map<std::string,std::vector<cMatrix3<float> > > attributeDataMat3;
	  std::map<std::string,std::vector<cMatrix4<float> > > attributeDataMat4;
  };

  struct sIndexedMesh
  {
	  
	  std::vector<unsigned int> indices;
	  std::vector<cVec3f> vertices;

	  std::map<std::string,std::vector<float> > attributeData;
	  std::map<std::string,std::vector<cVec2f> > attributeDataVec2;
	  std::map<std::string,std::vector<cVec3f> > attributeDataVec3;
	  std::map<std::string,std::vector<cVec4f> > attributeDataVec4;
	  std::map<std::string,std::vector<cMatrix3<float> > > attributeDataMat3;
	  std::map<std::string,std::vector<cMatrix4<float> > > attributeDataMat4;
  };

  class cMesh;
  sIndexedMesh convertMeshTypes(sMultiIndexedMesh &inMesh);


  class cHardMesh;
  /*!
    @class cMesh
    @brief cMesh holds all geometrical data. it also contains attribute maps.
  */
  class cMesh
  {
  public:


    cMesh()
    {
      boundingSphereRadius = 0.0f;
    }

    
    ///takes data stored in this mesh structure(client stored ) and
    ///loads it into a hardware(server) stored mesh.
    void mapSoftMeshToHardMesh(cHardMesh *hm,
			       GLint indexStorageSpec=GL_STATIC_DRAW_ARB,
			       GLint vertexStorageSpec=GL_STATIC_DRAW_ARB,
			       GLint defAttribStorageSpec=GL_STATIC_DRAW_ARB,
				  std::map<std::string,GLint> *attribStorageSpec=0);
	
    ///the faces in the mesh.
    std::vector<sFace> faces;
    ///the vertices of the mesh.
    std::vector<cVec3f> vertices;
    ///attribute map. vec3
    /*!use like , i.e . 
      vec3AttributeMap["normal"] = std::vector<cVec3f> ();
    */
    std::map<std::string,std::vector<cVec3f> > vec3AttributeMap;
    ///attribute map. vec2
    std::map<std::string,std::vector<cVec2f> > vec2AttributeMap;
    ///attribute map. vec4
    std::map<std::string,std::vector<cVec4f> > vec4AttributeMap;
	  
    std::map<std::string,std::vector<float> > vec1AttributeMap;

    std::map<std::string,std::vector<cMatrix3<float> > > mat3x3AttributeMap;

    ///calculates the bounding sphere given the current vertices.
    void calculateBoundingSphere()
    {
      cVec3f min;
      cVec3f max;

      for(int i=0; i< vertices.size(); i++)
	{
	  if(i==0)
	    {
	      min = max = vertices[0];
	      continue;	
	    }

	  if(min.x > vertices[i].x)
	    {
	      min.x = vertices[i].x;
	    }
	  if(min.y > vertices[i].y)
	    {
	      min.y = vertices[i].y;
	    }
	  if(min.z > vertices[i].z)
	    {
	      min.z = vertices[i].z;
	    }

	  if(max.x < vertices[i].x)
	    {
	      max.x = vertices[i].x;
	    }
	  if(max.y < vertices[i].y)
	    {
	      max.y = vertices[i].y;
	    }
	  if(max.z < vertices[i].z)
	    {
	      max.z = vertices[i].z;
	    }
	}
			
      cVec3f maxMinDiff = max-min;
      setBoundingSphere( fabs(maxMinDiff.magnitude())*0.5 );
      boundSphereOffset = min + maxMinDiff*0.5;
    }

    float getBoundingSphereRadius()const
    {
      return boundingSphereRadius;
    }

    void setBoundingSphere(float r)
    {
      boundingSphereRadius = r;
    }

    ///A boundSphereOffset
    /*!

     */
    cVec3f boundSphereOffset;

    void generateTangents(const std::string &tangentAttribName,
			  const std::string &normalName,
			  const std::string &textureCoordName)
    {
	if(vec2AttributeMap.find(textureCoordName)==vec2AttributeMap.end())
			return;
	if(vec3AttributeMap.find(normalName)==vec3AttributeMap.end())
			return;
      std::vector<cVec2f> &txtCrds =vec2AttributeMap[textureCoordName];

      vec3AttributeMap["tangent"] = std::vector<cVec3f>();
      std::vector<cVec3f> &tangents = vec3AttributeMap[tangentAttribName];

      std::vector<cVec3f> &normals = vec3AttributeMap[normalName];
			
      if(tangents.size()!=vertices.size())
	tangents.resize(vertices.size());

      std::vector<cVec3f> tan1,tan2;
      tan1.resize(vertices.size());
      tan2.resize(vertices.size());

      for(unsigned int i =0; i<faces.size(); i++)
	{
	  //yeah. you voilla.
	  int r1 = faces[i].v1;
	  int r2 = faces[i].v2;
	  int r3 = faces[i].v3;

	  float x1 = vertices[r2].x - vertices[r1].x;
	  float x2 = vertices[r3].x - vertices[r1].x;

	  float y1 = vertices[r2].y - vertices[r1].y;
	  float y2 = vertices[r3].y - vertices[r1].y;

	  float z1 = vertices[r2].z - vertices[r1].z;
	  float z2 = vertices[r3].z - vertices[r1].z;

	  float s1 = txtCrds[r2].x - txtCrds[r1].x;
	  float s2 = txtCrds[r3].x - txtCrds[r1].x;

	  float t1 = txtCrds[r2].y - txtCrds[r1].y;
	  float t2 = txtCrds[r3].y - txtCrds[r1].y;

	  float r = 1.0f/(s1*t2-s2*t1);
	  cVec3f tangent((t2*x1 - t1*x2)*r,
			 (t2*y1 - t1*y2)*r,
			 (t2*z1 - t1*z2)*r);
	  tangent.normalize();
	  tan1[r1]+=tangent;
	  tan1[r2]+=tangent;
	  tan1[r3]+=tangent;


	  tangent.x = (s1*x2-s2*x1)*r;
	  tangent.y = (s1*y2-s2*y1)*r;
	  tangent.y = (s1*z2-s2*z1)*r;

	  tan2[r1]+=tangent;
	  tan2[r2]+=tangent;
	  tan2[r3]+=tangent;


	}


      for (unsigned int i = 0; i < tangents.size(); i++)
	{
	  cVec3f n = normals[i];
	  cVec3f t = tan1[i];

	  // Gram-Schmidt orthogonalize
	  tangents[i] = (t - n * n.dotProd(t));
	  tangents[i].normalize();
	}
    }

    void addMesh(cMesh &mesh)
    {
      //int ind = mesh.vertices.size();
      int atIndex = vertices.size();

std::map<std::string,std::vector<float> >::iterator vec1It = mesh.vec1AttributeMap.begin();
			
      std::map<std::string,std::vector<cVec2f> >::iterator vec2It = mesh.vec2AttributeMap.begin();
      std::map<std::string,std::vector<cVec3f> >::iterator vec3It = mesh.vec3AttributeMap.begin();
      std::map<std::string,std::vector<cVec4f> >::iterator vec4It = mesh.vec4AttributeMap.begin();

      std::map<std::string,std::vector<cMatrix3<float> > >::iterator mat3x3It = mesh.mat3x3AttributeMap.begin();

      while(vec1It!=mesh.vec1AttributeMap.end())
	{

	  if(vec1AttributeMap.find(vec1It->first)!=vec1AttributeMap.end())
	    {
	      for(int i=0; i< mesh.vertices.size(); i++)
		{
		  vec1AttributeMap[vec1It->first].push_back(vec1It->second[i]);
		}
	    }
	  vec1It++;
	}

      while(vec2It!=mesh.vec2AttributeMap.end())
	{

	  if(vec2AttributeMap.find(vec2It->first)!=vec2AttributeMap.end())
	    {
	      for(int i=0; i< mesh.vertices.size(); i++)
		{
		  vec2AttributeMap[vec2It->first].push_back(vec2It->second[i]);
		}
	    }
	  vec2It++;
	}
      while(vec3It!=mesh.vec3AttributeMap.end())
	{
	  if(vec3AttributeMap.find(vec3It->first)!=vec3AttributeMap.end())
	    {
	      for(int i=0; i< mesh.vertices.size(); i++)
		{
		  vec3AttributeMap[vec3It->first].push_back(vec3It->second[i]);
		}
	    }
	  vec3It++;
	}

      while(vec4It!=mesh.vec4AttributeMap.end())
	{
	  if(vec4AttributeMap.find(vec4It->first)!=vec4AttributeMap.end())
	    {
	      for(int i=0; i< mesh.vertices.size(); i++)
		{
		  vec4AttributeMap[vec4It->first].push_back(vec4It->second[i]);
		}
	    }
	  vec4It++;
	}
      while(mat3x3It!=mesh.mat3x3AttributeMap.end())
	{
	  if(mat3x3AttributeMap.find(mat3x3It->first)!=mat3x3AttributeMap.end())
	    {
	      for(int i=0; i< mesh.vertices.size(); i++)
		{
		  mat3x3AttributeMap[mat3x3It->first].push_back(mat3x3It->second[i]);
		}
	    }
	  mat3x3It++;
	}

			
      for(int i=0; i< mesh.vertices.size(); i++)
	{
	  vertices.push_back(mesh.vertices[i]);
	}

      //now indices.

      for(int i=0; i < mesh.faces.size(); i++)
	{
	  sFace f = mesh.faces[i];
	  f.v1 +=atIndex;
	  f.v2 +=atIndex;
	  f.v3 +=atIndex;
	  faces.push_back(f);
	}
    }

		
		
  protected:
		
    int genBufferId;
    float boundingSphereRadius;
	
		
		
  };
}

#endif
