/*******************************************************

Original Author...Christer Vasseng
Purpose...........

//TODO:
/*
*/

#ifndef h__fusa__particleNode
#define h__fusa__particleNode

#include "fusa_spatialNode.h"
#include "fusa_geometryNode.h"

namespace fusa
{
	class cScenegraph;

	///Particle System
	class cParticleNode : public cSpatialNode
	{
	public:
		friend class cScenegraph;
		enum ParticleSystemType
		{
			pstExplosion,
			pstSpit,

		};

		NodeType getNodeType()const
		{
			return ntParticle;
		}

		///init particles
		void initParticles(int count);

		///set particle properties
		void preUpdate(float t,cSpatialNode *ptr_parent);

		
	protected:
	private:
		float m_growthRate;
		float m_spreadRadius;
		float m_currentParticleCount;
		float m_globalSpeed;
		float m_decaySpeed;
		cVec3f m_globalForce;
		int m_particleCount;

		ParticleSystemType m_systemType;
		
		cGeometryNode *mptr_geomNode;

		cParticleNode(cScenegraph *ptr_sceneLink);
	};

}

#endif
