#ifndef H_xxFUSA_SCENEGRAPHxx_H
#define H_xxFUSA_SCENEGRAPHxx_H
#include "fusa_spatialNode.h"
#include "fusa_geometryNode.h"
#include "fusa_cameraNode.h"
#include "fusa_linkNode.h"
#include "fusa_particleNode.h"
#include "fusa_postProcOverlay.h"


/*******************************************************

Original Author...Håvard Christensen
Purpose...........scenegraph

Description:
This is the scenegraph. it holds a tree of nodes and provides functionality to access these nodes.


//TODO:
/*
- Clean up,
*/

namespace fusa
{
  /*!
    @class cScenegraph
    @brief cScenegraph is the scenegraph for fusa.
    @it contains nodes and information on how to render these nodes.
  */

  class cScenegraph
  {
  public:
    cScenegraph();


    ///loads a file
    /*!given a filename and binary flag.
      returns true on success*/
    bool loadFile(const std::string &filename,bool binForm=false);

    ///loads up a scene/file
    /*!and adds it to the current scene.
      returns the top-node of loaded scene,
      or 0-pointer on fail. ptr_root can contain a
      pointer which will act as the root for
      the scene to be loaded.*/
    cSpatialNode* addFileToScene(const std::string &filename,bool binForm=false,cSpatialNode *ptr_root=0);

    ///gets a node by id,
    /*! returns 0 pointer on fail.*/
    cSpatialNode* getNode(int id)const;

    ///gets a node by name,
    /*! returns 0 pointer on fail.*/
    cSpatialNode* getNode(const std::string &name)const;

    ///updates the scenegraph at time t, t should be in the range 0 - 1
    void update(float t);

    ///gets the active camera.
    /*!returns 0-pointer on fail.*/
    cCameraNode* getActiveCamera();

    ///inserts node as the parent of a node with given name
    void insertNodeAsParent(cSpatialNode *ptr_node, const std::string &name);

    ///inserts node insertNode as the parent of the node node.
    void insertNodeAsParent(cSpatialNode *ptr_insertNode,cSpatialNode *ptr_node);

    ///inserts node insertNode as parent to the node with nodeId as id.
    void insertNodeAsParent(cSpatialNode *ptr_insertNode,int nodeId);

    /// disable/enable rendering of the whole scenegraph
    void setRenderBool(bool doRender);

    /// should the scenegraph get rendered?
    /*!returns true if it's the case, otherwise false.*/
    bool shouldGetRendered()const;

    /// delete the whole scenegraph.
    void deleteWholeScenegraph();

    ///sets the active camera,
    /*!returns true and updates active camera if successfull, returns false
      if there is no camera node at the Id given and does not update the m_activeCamera variable.*/
    void setActiveCamera(cCameraNode *cam);

    cSpatialNode* getRoot();

    ///create a new spatial node.
    cSpatialNode* createSpatialNode();

    ///create a new geometry node
    cGeometryNode* createGeometryNode();

    ///create a new camera node
    cCameraNode* createCameraNode();

    cLinkNode* createLinkNode();

    cParticleNode* createParticleNode();

    ///Deletes node ptr_deleteNode and deletes the subtree of ptr_deleteNode as well.
    /*!
      Remember, you should also deinit the node in the renderer.
      this will clear up the resources it holds in the renderer.
    */
    void deleteNodeAndSubtree(cSpatialNode *ptr_deleteNode);

    ///Deletes node ptr_deleteNode from the scenegraph, replaces its place in the hierarchy with ptr_replaceNode
    ///this keeps the subtree of ptr_deleteNode intact.
    /*!
      Remember, you should also deinit the node in the renderer.
      this will clear up the resources it holds in the renderer.
      Also, the replacement node should be inited by the renderer, so that the data it uses
      is initialized.
    */
    void deleteNode(cSpatialNode *ptr_deleteNode,cSpatialNode* ptr_replaceNode);

    ///Deletes node ptr_deleteNode from the scenegraph,
    ///removes the link it has to its parent
    /*!
      Remember, you should also deinit the node in the renderer.
      this will clear up the resources it holds in the renderer.
      Also, the replacement node should be inited by the renderer, so that the data it uses
      is initialized.
    */
    void deleteNode(cSpatialNode *ptr_deleteNode);


    //camera stuff
    unsigned int getNumberOfCameras()const;
    cCameraNode* getCamera(unsigned int i);

    ///get Culled Render List (CRL).
    /*!
      This gets the CRL. CRL is built up by choosing which camera you want,
      and what cameraPass you want. This will then be culled against the view-frustrum.
      this final flattend list will be outputted
      through the crl vector/array, which is passed in by reference.
      the scenegraph should have been updated allready when this is called.
    */
    void getCulledRenderList(unsigned int cameraNr, std::vector<cSpatialNode*> &crl);

    virtual ~cScenegraph();

    cSpatialNode* getPickedNode()
    {
      return mptr_pickedNode;
    }


    void setReady(bool b){m_ready=b;}

  protected:
    ///recursive update call.
    virtual void recursiveUpdate(cSpatialNode* ptr_node,float t);

    ///returns top node of loaded scene. returns 0-pointer if failed.
    cSpatialNode* loadFormat1Ascii(std::ifstream &in,const std::string &filename);

    ///returns top node of loaded scene. returns 0-pointer if failed.
    cSpatialNode* loadFormat1Bin(std::ifstream &in,const std::string &filename);

    ///updates scenenode ID's to internal values after loading (internal function)
    void updateSceneNodeIdToInternalValues(cSpatialNode *ptr_node);

    ///deletes nodes recursivly.
    void deleteRecursive(cSpatialNode *ptr_node);

    ///recursive culling.
    void recursiveCull(std::vector<cSpatialNode*> &crl,cCameraNode *ptr_cam,cSpatialNode *node);

    ///recursive camerapass pruning
    void recursivePrune(std::vector<cSpatialNode*> &crlSource,std::vector<cSpatialNode*> &crl,std::vector<int> &crlRenderPass,cCameraPass *pass,cSpatialNode* node,bool pruneIt,int rPAss);

    ///generates a new ID for new nodes (internal).
    /*!
      A new node generated through the createNode-interfaces
      will get a correct id through this interface. it all happens automagically for the
      user of a scenegraph.
    */
    int generateId()
    {
      m_idGenerator++;
      return m_idGenerator-1;

    }

    int m_idGenerator;
    bool m_doRender;



    cSpatialNode* mptr_root;

    ///the node which is currently picked.
    /*!
      this is not implemented at the moment.
    */
    cSpatialNode* mptr_pickedNode;

    ///we contain cameras here so that we don't have to search the whole tree to obtain them.
    std::vector<cCameraNode*> cameras;

    ///active camera.
    /*! we store a active-camera. This can be used
      to gain access to the camera which is seeing(rendering) the scene during
      the render-code.*/
    cCameraNode *m_activeCamera;




  private:

    bool m_ready;

  };

  ///interface to the global scenegraph.
  cScenegraph* Scenegraph();
}

#endif
