
#include <iostream>
#include <fusa.h>
#include <SDL.h>
#include "gamecore.h"
using namespace fusa;


std::string levelPath;
sGame rb;
float dTimes=0.0f;


bool posOutOfGrid(const cVec2f &pos,float radi)
{
	if(pos.x + radi < 0.0f)
		{
			return true;
		}
		if(pos.x - radi > 1024.0f)
		{
			return true;
		}
		if(pos.y - radi > 768.0f)
		{
			return true;
		}
		if(pos.y + radi < 0.0f)
		{
			return true;
		}
		return false;
}

void sPlayer::doBounding()
{
	if(pos.x - radi < 0.0f)
	{
		pos.x = radi;
		velocity.x = 0;
	}
	if(pos.x + radi > 1024.0f)
	{
		pos.x = 1024.0f - radi;
		velocity.x = 0;
	}
	if(pos.y + radi > 768.0f)
	{
		pos.y = 768.0f - radi;
		velocity.y = 0;
	}
	if(pos.y - radi < 0.0f)
	{
		pos.y = radi;
		velocity.y = 0;
	}
		
}

void sGameObj::draw()
{
	getTexture(texture).bindTexture();
	drawSprite(pos,cVec2f(radi,radi));
}

void sGameObj::loadFile(const std::string &file)
{

	loadedFrom = file;
	std::ifstream f_in;
	f_in.open((levelPath + file).c_str());
	if(f_in.good())
	{
		std::string tmp;
		std::getline(f_in,tmp,':');
		f_in>>radi;
		std::getline(f_in,tmp,':');
		f_in>>colRadi;
		std::getline(f_in,tmp,':');
		std::getline(f_in,texture,':');
		subLoad(f_in);
	}
	pos.set(500.0f,500.0f);
}

void sGameObj::reload()
{
	loadFile(loadedFrom);
}

void sAttachedDot::subLoad(std::ifstream &f_in)
{
	if(f_in.good())
	{
		std::string tmp;
		std::getline(f_in,tmp,':');
		f_in>>delayPerDot;
		std::getline(f_in,tmp,':');
		f_in>>popScaleSpeed;
	
	}
}

void sPlayer::subLoad(std::ifstream &f_in)
{
	if(f_in.good())
	{
		std::string tmp;
		std::getline(f_in,tmp,':');
		f_in>>speed;
		std::getline(f_in,tmp,':');
		f_in>>deAcc;
		std::getline(f_in,tmp,':');
		f_in>>accel;

		std::getline(f_in,tmp,':');
		f_in>>shotSpeedDelayPerShot;
		
		
	}
	else
	{
		speed = 0.0f;
		deAcc = 0.0f;
		accel = 0.0f;
	}

	origSize = radi;
	origColliSize = colRadi;
	pos.set(300,300);

}

void sEnemy::subLoad(std::ifstream &f_in)
{
	if(f_in.good())
	{
		std::string tmp;
		std::getline(f_in,tmp,':');
		std::getline(f_in,selectedTex,':');
		std::getline(f_in,tmp,':');
		f_in>>speed;

		std::getline(f_in,tmp,':');
		f_in>>howOftenSpawn;
		std::getline(f_in,tmp,':');
		f_in>>randomQ;
		std::getline(f_in,tmp,':');
		f_in>>manySpawn;
		std::getline(f_in,tmp,':');
		f_in>>randomManyQ;

		bulletSpawnTimer = howOftenSpawn + rand()%randomQ;

		std::getline(f_in,tmp,':');
		std::getline(f_in,textureRed,':');
		std::getline(f_in,tmp,':');
		std::getline(f_in,textureGreen,':');
		std::getline(f_in,tmp,':');
		std::getline(f_in,textureBlue,':');

		std::getline(f_in,tmp,':');
		f_in>>selNumberSize;
	}
}

void sDangerSpawn::subLoad(std::ifstream &f_in)
{
	if(f_in.good())
	{
		std::string tmp;
		std::getline(f_in,tmp,':');
		std::getline(f_in,textureRed,':');
		std::getline(f_in,tmp,':');
		std::getline(f_in,textureGreen,':');
		std::getline(f_in,tmp,':');
		std::getline(f_in,textureBlue,':');

		std::getline(f_in,tmp,':');
		f_in>>howOftenSpawn;
		std::getline(f_in,tmp,':');
		f_in>>randomQ;
		std::getline(f_in,tmp,':');
		f_in>>manySpawn;
		std::getline(f_in,tmp,':');
		f_in>>randomManyQ;
		std::getline(f_in,tmp,':');
		f_in>>rotaSpeed;
		std::getline(f_in,tmp,':');
		f_in>>radius;

		timeToSpawn = howOftenSpawn + rand()%randomQ;
		
	}
}

void sPlayerProjectiles::subLoad(std::ifstream &f_in)
{
	if(f_in.good())
	{
		std::string tmp;
		std::getline(f_in,tmp,':');
		f_in>>shotSpeedStart;
		std::getline(f_in,tmp,':');
		f_in>>shotSpeedEnd;
		std::getline(f_in,tmp,':');
		f_in>>shotSpeedAcc;

		
	}
}

void sDangerDot::subLoad(std::ifstream &f_in)
{
	if(f_in.good())
	{
		std::string tmp;
		std::getline(f_in,tmp,':');
		f_in>>shotSpeed;

		std::getline(f_in,tmp,':');
		std::getline(f_in,textureRed,':');
		std::getline(f_in,tmp,':');
		std::getline(f_in,textureGreen,':');
		std::getline(f_in,tmp,':');
		std::getline(f_in,textureBlue,':');
		
	}
}



void sGame::initGame(const std::string &filename)
{
	inSplash = true;
	soundStack = 1;
	gameIsDone = false;
	std::ifstream f_in;
	f_in.open(filename.c_str());
	std::string tmp;
	int numLevels = 0;
	std::getline(f_in,tmp,':');
	f_in>>numLevels;
	for(unsigned int i=0; i < numLevels; i++)
	{
		std::getline(f_in,tmp,':');
		std::getline(f_in,tmp,':');
		levelPaths.push_back(tmp);
		std::getline(f_in,tmp,':');
		int need = 0;
		f_in>>need;
		levelNeeds.push_back(need);
	}

	levelPath = levelPaths.front();
	

	playa.loadFile("playa.rolf");
	playaAim.loadFile("playaim.rolf");

	enemies.resize(40);
	sEnemy enemy;
	enemy.loadFile("enemy.rolf");
	for(unsigned int i=0; i < enemies.size(); i++)
	{
		enemies[i] = enemy;
		enemies[i].alive = false;
		enemies[i].pos.set(rand()%1000,rand()%600);
	}
	lastDeadEnemy =0;// enemies.size();

	sPlayerProjectiles playProj;
	playProj.loadFile("playaProj.rolf");
	playerProjects.resize(50);
	for(unsigned int i=0; i < playerProjects.size(); i++)
	{
		playerProjects[i] = playProj;
		playerProjects[i].pos.set(rand()%1000,rand()%600);
	}
	lastDeadPlayerProj = 0;

	sDangerSpawn dHole;
	dHole.loadFile("spawn.rolf");
	dangerHoles.resize(3);
	for(unsigned int i=0; i < dangerHoles.size(); i++)
	{
		dangerHoles[i] = dHole;
		dangerHoles[i].pos.set(rand()%1000,rand()%600);
		dangerHoles[i].faction = static_cast<eFaction>(i+1);
		dangerHoles[i].updateTexture();
	}

	sDangerDot danger;
	danger.loadFile("enProj.rolf");
	dangerDots.resize(1000);
	for(unsigned int i=0; i < dangerDots.size(); i++)
	{
		dangerDots[i] = danger;
		dangerDots[i].pos.set(rand()%1024,rand()%768);
	}
	lastDeadDot = 0;

	sAttachedDot atDot;
	atDot.loadFile("atDot.rolf");
	attachedDots.resize(3000);
	for(unsigned int i=0; i < attachedDots.size(); i++)
	{
		attachedDots[i] = atDot;
		attachedDots[i].pos.set(rand()%1024,rand()%768);
	}
	lastDeadAttach =0;

	

	currLevel = 0;
	currScore = 0;
	topScore = 0;
	lastScore = 0;
	inACaliBlow = false;
	caliBlow = 0.0f;
}

void sGame::killAll()
{
	for(unsigned int i=0; i < enemies.size(); i++)
	{
		enemies[i].alive = false;
	}
	lastDeadEnemy =0;

	for(unsigned int i=0; i < dangerDots.size(); i++)
	{
		dangerDots[i].alive = false;
	}
	lastDeadDot = 0;
}

void sGame::reload()
{
	playa.reload();
	playaAim.reload();
	for(unsigned int i=0; i < enemies.size(); i++)
	{
		enemies[i].reload();
		enemies[i].alive = false;
	}
	lastDeadEnemy =0;

	for(unsigned int i=0; i < playerProjects.size(); i++)
	{
		playerProjects[i].reload();
		playerProjects[i].alive =false;
	}
	lastDeadPlayerProj = 0;

	for(unsigned int i=0; i < dangerDots.size(); i++)
	{
		dangerDots[i].reload();
		dangerDots[i].alive = false;
	}
	lastDeadDot = 0;

	for(unsigned int i=0; i < attachedDots.size(); i++)
	{
		attachedDots[i].reload();
		attachedDots[i].alive = false;
	}
	lastDeadAttach =0;

	for(unsigned int i=0; i < dangerHoles.size(); i++)
	{
		dangerHoles[i].reload();
	}
}

void sGame::doInput()
{

	if(buttonDown('w') )
	{
		cVec2f influ(0.0f,1.0f);
		playa.velocity+=influ*playa.accel*dTimes;
		if(playa.velocity.y>=playa.speed)
			playa.velocity.y = playa.speed;
		//playa.currSpeed.y = playa.speed;
	}
	 if(buttonDown('a'))
	{
		cVec2f influ(-1.0f,0.0f);
		playa.velocity+=influ*playa.accel*dTimes;
		if(playa.velocity.x<=-playa.speed)
			playa.velocity.x = -playa.speed;
		
	}
	 if(buttonDown('s'))
	{
		cVec2f influ(0.0f,-1.0f);
		playa.velocity+=influ*playa.accel*dTimes;
		if(playa.velocity.y<=-playa.speed)
			playa.velocity.y = -playa.speed;
	}
	 if(buttonDown('d'))
	{
		cVec2f influ(1.0f,0.0f);
		playa.velocity+=influ*playa.accel*dTimes;
		if(playa.velocity.x>=playa.speed)
			playa.velocity.x = playa.speed;
	}
	else if(buttonPress('r'))
	{
		levelPath = levelPaths[currLevel];
		reload();
	}
	 else if(buttonPress(' '))
	{
		/*killAll();
		inACaliBlow = true;
		caliBlow = 1.0f;

		//SOMEONE SET US UP TAH BOMBS
		for(unsigned int i=0; i < lastDeadAttach; i++)
		{
			
			int inCircle = i%10;
			float inCircleT = i/static_cast<float>(lastDeadAttach);

			//how many bullets make a circle?
			float circleLayer = i/40;
			attachedDots[i].velocity.set(cos(M_PI*inCircleT*2.0f),sin(M_PI*inCircleT*2.0f));
			attachedDots[i].pos = playa.pos;
		}
		*/

	}

	 

	 
}
	
void sGame::doMouse()
{
	//let us place the aim recticle.
	playaAim.pos.set(getMouseX()*1024.0f,getMouseY()*768.0f);
}

void sGame::playerProjDeathSwap(int index)
{
	sPlayerProjectiles &proj = playerProjects[index];
	sPlayerProjectiles temp = proj;
	int lastNotDeaded = lastDeadPlayerProj -1;
	if(lastNotDeaded >= 0 &&  lastNotDeaded <playerProjects.size())
	{

		if(playerProjects[lastNotDeaded].enemyTarget!=-1)
		{
			//we are swapping a shot.
			//we thus need to update the enemy with where this homing projectile.
			if(playerProjects[lastNotDeaded].enemyTarget < enemies.size())
			{
				enemies[playerProjects[lastNotDeaded].enemyTarget].homedByShot = index;
			}
			else
			{
				std::cout<<"swapping of homing missile failed index test"<<std::endl;
			}
		}

		proj = playerProjects[lastNotDeaded];
		playerProjects[lastNotDeaded] = temp;
		lastDeadPlayerProj--;
	}
}



void sGame::enemyDeathSwap(int index)
{
	sEnemy &proj = enemies[index];
	sEnemy temp = proj;
	int lastNotDeaded = lastDeadEnemy -1;
	if(lastNotDeaded >= 0 &&  lastNotDeaded <enemies.size())
	{
		if(enemies[lastNotDeaded].homedByShot!=-1)
		{
			//we are swapping a targeted enemy shot.
			//we thus need to update the homing projectile so it homes to this position.
			if(enemies[lastNotDeaded].homedByShot < playerProjects.size())
			{
				playerProjects[enemies[lastNotDeaded].homedByShot].enemyTarget = index;
			}
			else
			{
				std::cout<<"swapping of homing missile failed index test"<<std::endl;
			}
		}
		proj = enemies[lastNotDeaded];
		enemies[lastNotDeaded] = temp;
		lastDeadEnemy--;
	}
}

void sGame::dangerDotDeathSwap(int index)
{
	sDangerDot &dot = dangerDots[index];
	sDangerDot temp = dot;
	int lastNotDeaded = lastDeadDot -1;
	if(lastNotDeaded >= 0 &&  lastNotDeaded <dangerDots.size())
	{
		dot = dangerDots[lastNotDeaded];
		dangerDots[lastNotDeaded] = temp;
		lastDeadDot--;
	}
	else
	{
		std::cout<<"lol. We ran out of bullets!"<<std::endl;
	}
}

void sGame::attachDotDeathSwap(int index)
{
	sAttachedDot &dot = attachedDots[index];
	sAttachedDot temp = dot;
	int lastNotDeaded = lastDeadAttach -1;
	if(lastNotDeaded >= 0 &&  lastNotDeaded <attachedDots.size())
	{
		dot = attachedDots[lastNotDeaded];
		attachedDots[lastNotDeaded] = temp;
		lastDeadAttach--;
	}
	else
	{
		std::cout<<"lol. We ran out of bullets!"<<std::endl;
	}
}

void sGame::doGame()
{
	glDisable(GL_DEPTH_TEST);
	dTimes = dTime*0.001f;


	if(inSplash)
	{
		getTexture("splash.png").bindTexture();
		glColor4f(1.0f,1.0f,1.0f,1.0f);
		drawSprite(cVec2f(512,384),cVec2f(1024,768));
		if(getMousePress())
		{
			inSplash = false;
			newSplash( "Text TutorialWASD.png", 3500.0,500.0 );
			newSplash( "Text TutorialDrag.png" ,3500.0,500.0);
			newSplash( "Text TutorialBullets.png" ,3500.0,500.0);
		}
		return;
	}


	doInput();
	doMouse();
	
glColor4f( 1.0f, 1.0f, 1.0f, 1.0f );
	glPushMatrix();
	/*if(demoTime>=300000)
	{
		newSplash("Text end.png" );
	}
	if(demoTime>=310000)
	{
		exitGame = true;
	}*/

	static bool doneEndTextStart = false;
	if(demoTime>=300000)
	{
		if(!doneEndTextStart)
		{
			doneEndTextStart = true;
			newSplash("Text end.png" );
		}
	}
	if(demoTime>=306000)
	{
		exitGame = true;
	}

	if(currLevel >= levelNeeds.size())
		return;

	if( currScore >= levelNeeds[currLevel])
	{
		currLevel++;
		if(currLevel >= levelNeeds.size())
		{
			gameIsDone = true;
			newSplash( "Text Level5.png", (300000 -demoTime) + 15000.0,0.0 );
			return;
		}
		
		switch( currLevel )
		{
			case 1:
				newSplash( "Text Level1.png" );
				break;
			case 2:
				newSplash( "Text Level2.png" );
				break;
			case 3:
				newSplash( "Text Level3.png" );
				break;
			case 4:
				newSplash( "Text Level4.png" );
				break;
		}
		
			levelPath = levelPaths[currLevel];


			killAll();
			inACaliBlow = true;
			caliBlow = 1.0f;
			currScore = 0;

			//SOMEONE SET US UP TAH BOMBS
			for(unsigned int i=0; i < lastDeadAttach; i++)
			{

				int inCircle = i%10;
				float inCircleT = i/static_cast<float>(lastDeadAttach);

				//how many bullets make a circle?
				float circleLayer = i/40;
				attachedDots[i].velocity.set(cos(M_PI*inCircleT*2.0f),sin(M_PI*inCircleT*2.0f));
				attachedDots[i].pos = playa.pos;
			}

		
		//

		//we should here reset game and load data files for aprop level.
	}
	

	if(inACaliBlow)
	{

		for(unsigned int i=0; i < lastDeadAttach; i++)
		{
			attachedDots[i].pos+=attachedDots[i].velocity*dTimes*440.0f;	
			
			if(posOutOfGrid(attachedDots[i].pos,attachedDots[i].radi))
			{
				attachedDots[i].alive = false;
				attachDotDeathSwap(i);
			}
		}
		if(lastDeadAttach<=2)
		{
			inACaliBlow = false;
			timeWithoutRespawn = 6000;
			
		}

		caliBlow-=dTimes*0.6f;
		if(caliBlow<=0.0f)
		{
			timeWithoutRespawn = 6000;
			reload();
			inACaliBlow = false;
		}
		else
		{
			float blowah = caliBlow*18.0;
			blowah*=blowah;
			cVec2f cockUpShake(sin(demoTime*0.03f + caliBlow*2.1f)*blowah,
				cos(demoTime*0.0765f + caliBlow*2.1543f)*blowah);
			glTranslatef(cockUpShake.x,cockUpShake.y,0.0f);
		}	
	}
	
	//DEACC THIS BABY
	if(playa.velocity.x<0.0f)
	{
		float newVel = playa.velocity.x + playa.deAcc*dTimes;
		if(newVel>0.0f)
			playa.velocity.x=0.0f;
		else
			playa.velocity.x=newVel;
	}
	else if(playa.velocity.x>0.0f)
	{
		float newVel = playa.velocity.x - playa.deAcc*dTimes;
		if(newVel<0.0f)
			playa.velocity.x=0.0f;
		else
			playa.velocity.x=newVel;
	}
	if(playa.velocity.y<0.0f)
	{
		float newVel = playa.velocity.y + playa.deAcc*dTimes;
		if(newVel>0.0f)
			playa.velocity.y=0.0f;
		else
			playa.velocity.y=newVel;
	}
	else if(playa.velocity.y>0.0f)
	{
		float newVel = playa.velocity.y - playa.deAcc*dTimes;
		if(newVel<0.0f)
			playa.velocity.y=0.0f;
		else
			playa.velocity.y=newVel;
	}
	//currspeed should go down to zero.
	/*playa.velocity.x-=dTimes*playa.deAcc;
	playa.velocity.y-=dTimes*playa.deAcc;
	if(playa.velocity.x<=0.0f)
	{
		playa.velocity.x = 0.0f;
	}
	if(playa.velocity.y<=0.0f)
	{
		playa.velocity.y = 0.0f;
	}*/

	playa.pos.x+=playa.velocity.x*dTimes;
	playa.pos.y+=playa.velocity.y*dTimes;
	playa.doBounding();

	

	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA,GL_ONE);
	//glColor4f(1.0f,1.0f,1.0f,0.5f);

	timeWithoutRespawn-=dTime;
	bool respawnAllowed = false;
	if(timeWithoutRespawn<=0)
	{
		respawnAllowed = true;
		timeWithoutRespawn = 0;
	}

	
	for(unsigned int i=0; i < dangerHoles.size(); i++)
	{
		sDangerSpawn &dHole = dangerHoles[i];

		float rotty = demoTime*0.0001f*dHole.rotaSpeed;
		dHole.pos.set(sin(rotty + i*2.1f)*dHole.radius + 512,cos(rotty + i*2.1f)*dHole.radius + 384);

		if(dHole.collision(playa))
		{
			playa.faction = dHole.faction;
		}

		if(respawnAllowed)
		{
			dHole.timeToSpawn-=dTime;
			if(dHole.timeToSpawn<=0)
			{

				dHole.timeToSpawn = dHole.howOftenSpawn + rand()%dHole.randomQ;
				int numbers = dHole.manySpawn + rand()%dHole.randomManyQ;	
				//let's spawn :)
				for(unsigned int j=0; j < numbers; j++)
				{
					if(lastDeadEnemy < enemies.size())
					{
						enemies[lastDeadEnemy].faction = dHole.faction;
						enemies[lastDeadEnemy].updateTexture();
						enemies[lastDeadEnemy].homedByShot = -1;
						enemies[lastDeadEnemy].alive = true;
						enemies[lastDeadEnemy].pos = dHole.pos;
						enemies[lastDeadEnemy].velocity.set((rand()%100 - 50)/100.0f,(rand()%100 - 50)/100.0f);
						enemies[lastDeadEnemy].notInShot = true;					
						lastDeadEnemy++;
						//dHole.pos.set(rand()%1024,rand()%768);
						//dHole.faction = static_cast<eFaction>(rand()%3 +1);
						dHole.updateTexture();
					}
					else
					{
						std::cout<<"ran out of enemies :("<<std::endl;
					}
				}
			}
		}
		
		dHole.draw();
		
	}

	bool hasPlayedRocket = false;
	
	for(unsigned int i=0; i < enemies.size(); i++)
	{
		sEnemy &en = enemies[i];
		if(en.alive)
		{
			//spawn some bullets!!
			en.bulletSpawnTimer-=dTime;
			if(en.bulletSpawnTimer<=0)
			{
				en.bulletSpawnTimer = rand()%en.randomQ + en.howOftenSpawn;
				//spawn like 20 bullets, ye know ;)

				int bullets = en.manySpawn + rand()%en.randomManyQ;
				for(unsigned int j=0; j < bullets; j++)
				{
					if(lastDeadDot < dangerDots.size())
					{
						float t = j/static_cast<float>(bullets);
						dangerDots[lastDeadDot].faction = en.faction;
						dangerDots[lastDeadDot].updateTexture();
						dangerDots[lastDeadDot].pos = enemies[i].pos;
						dangerDots[lastDeadDot].alive = true;
						cVec2f velos;
						velos.x = cos(M_PI*t*2.0f);
						velos.y = sin(M_PI*t*2.0f);
						dangerDots[lastDeadDot].velocity = velos;
						lastDeadDot++;
					}
					else
					{
						std::cout<<"ran out of bullets :("<<std::endl;
					}
				}
			}


		en.pos += en.velocity*en.speed*dTimes;
		if(en.pos.x< 0.0f)
		{
			en.pos.x = en.radi;
			en.velocity.x = -en.velocity.x;
			en.velocity.y+= (rand()%100 - 50)/100.0f;
		}
		if(en.pos.x > 1024.0f)
		{
			en.pos.x = 1024.0f - en.radi;
			en.velocity.x = -en.velocity.x;
			en.velocity.y+= (rand()%100 - 50)/100.0f;
		}
		if(en.pos.y > 768.0f)
		{
			en.pos.y = 768.0f - en.radi;
			en.velocity.y = -en.velocity.y;
			en.velocity.x+= (rand()%100 - 50)/100.0f;
		}
		if(en.pos.y < 0.0f)
		{
			en.pos.y =  en.radi;
			en.velocity.y = -en.velocity.y;
			en.velocity.x+= (rand()%100 - 50)/100.0f;
		}
		
		if(getMouseDown()==false)
		{
			if(en.selectNr!=0 && en.notInShot)
			{
				std::cout<<"enemy nr:"<<i<<" in select chain "<<en.selectNr<<" is shot"<<std::endl;
			

			//let us find a free player projectile and target it to this enemy..
			if(lastDeadPlayerProj < playerProjects.size())
			{
				playerProjects[lastDeadPlayerProj].shotSpeedDelay = en.selectNr*playa.shotSpeedDelayPerShot;
				playerProjects[lastDeadPlayerProj].alive = true;
				playerProjects[lastDeadPlayerProj].enemyTarget = i;
				playerProjects[lastDeadPlayerProj].pos = playa.pos;
				playerProjects[lastDeadPlayerProj].shotSpeed = playerProjects[lastDeadPlayerProj].shotSpeedStart;
		
				playerProjects[lastDeadPlayerProj].chainValue = chainValue;
				//playerProjects[lastDeadPlayerProj]
				enemies[i].homedByShot = lastDeadPlayerProj;
				en.notInShot = false;
				lastDeadPlayerProj++;

				//if( !hasPlayedRocket )
				{				
					playRocket( );
					hasPlayedRocket = true;
				}
			}
			else
			{
				std::cout<<"ran out of player projectiles :("<<std::endl;
			}
			}

			enemies[i].selectNr = 0;
			playaAim.currSelChain = 0;
			if(chainValue>=2)
				chainStack.push(chainValue);
			chainFaction = facGray;
		}
		if(playaAim.collision(en) && en.selectNr==0 && getMouseDown()==true   && en.notInShot)
		{
		
			playaAim.currSelChain++;
			en.selectNr = playaAim.currSelChain;
			if(chainFaction==facGray)
			{
				//gray means a new chain could be starting.
				chainValue = 1;
				
				chainFaction = en.faction;
				
				soundStack = 1;
				

				playSelect( soundStack-1 );
			}
			else if(chainFaction == en.faction)
			{
				chainValue++;
				soundStack++;
				playSelect( soundStack-1 );
			}
			else
			{
				//push the chain back into the chainstack.
				if(chainValue>=2)
					chainStack.push(chainValue);
				chainValue = 1; //start new chain
				chainFaction = en.faction;

				soundStack-= 1;
		
				
				if(soundStack<1)
					soundStack=1;
				
				playSelect( soundStack-1 );
				
			}

			//it is selected!
			std::cout<<"collision"<<std::endl;
		}
		else if(en.selectNr==0)
		{
			en.draw();
		}
		else if(en.selectNr!=0)
		{
			float modCol = en.selectNr*0.1f;
			en.draw();
			getTexture(en.selectedTex).bindTexture();
			drawSprite(en.pos,cVec2f(en.radi,en.radi));

			glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
			drawNumber(en.selectNr,en.pos + cVec2f(en.radi*0.8,-en.radi*0.5),
					   en.selNumberSize);
			glBlendFunc(GL_SRC_ALPHA,GL_ONE);
		}
		}
	}
	


	glColor4f(1.0f,1.0,1.0f,1.0f);
	playa.draw();	
	playaAim.draw();

	for(unsigned int i=0; i < playerProjects.size(); i++)
	{
		sPlayerProjectiles &proj = playerProjects[i];
		if(proj.alive)
		{
			if(proj.enemyTarget!=-1 && proj.enemyTarget < enemies.size())
			{
				sEnemy &en = enemies[proj.enemyTarget];
				//if(en.homedByShot == i)
				{

					//move towards target:
					cVec2f diff = en.pos - proj.pos;

					proj.shotSpeedDelay-=dTime;
					if(proj.shotSpeedDelay<=0)
					{
						proj.shotSpeedDelay = 0;
						proj.shotSpeed+=proj.shotSpeedAcc*dTimes;
						if(proj.shotSpeed>=proj.shotSpeedEnd)
						{
							proj.shotSpeed = proj.shotSpeedEnd;
						}
					}
					else
					{
						proj.pos = playa.pos;
						proj.shotSpeed =0;
					}


					proj.pos = proj.pos + diff.getNormalized()*dTimes*proj.shotSpeed;

					if(en.collision(proj))
					{//enemy is colliding with projectile we sent out :)
						std::cout<<"enemy colliding with outsent projectile"<<std::endl;
						proj.alive=false;
						en.alive = false;
						en.notInShot = true;
						//currScore+=50*proj.chainValue;

						playDeath( );

						int numberToSpawn = 1;
						if(!chainStack.empty())
						{
							
								numberToSpawn += chainStack.top()*4;
							chainStack.pop();
						}
						if(proj.chainValue>=3)
							numberToSpawn+=8;

						//
						{
							currScore+=numberToSpawn;
							for(unsigned int j=0; j< numberToSpawn; j++)
							{
								if(lastDeadAttach < attachedDots.size())
								{

									sAttachedDot & atDot = attachedDots[lastDeadAttach];

									atDot.currScale = 0.0f;
									atDot.delayUntilPopScale = atDot.delayPerDot*j;


									atDot.faction = playa.faction;
									atDot.alive = true;

									//where in circle?
									int inCircle = lastDeadAttach%40;
									float inCircleT = inCircle/40.0f;

									//how many bullets make a circle?
									float circleLayer = lastDeadAttach/40;
									float outSpace = (playa.radi + atDot.radi*circleLayer)*0.5f;

									cVec2f add(cos(M_PI*inCircleT*2.0f),sin(M_PI*inCircleT*2.0f));
									atDot.pos=add*outSpace;
									lastDeadAttach++;

								}
								else
								{
									//std::cout<<"Ran out of attach dots :("<<std::endl;
								}

							}
						}

						en.selectNr=0;
						en.homedByShot = -1;


						//this is deaded, so find last not deaded and do a swap.

						enemyDeathSwap(proj.enemyTarget);
						playerProjDeathSwap(i);
					}

				}
				proj.draw();
			}
		}
	}



	

	for(unsigned int i=0; i < attachedDots.size(); i++)
	{
		sAttachedDot &atDot = attachedDots[i];
		if(atDot.alive)
		{
			cVec2f temp = atDot.pos;
			float radiTemp = atDot.radi;
			if(!inACaliBlow)
			{
				atDot.pos+=playa.pos;
				if( currLevel == 1 )
				{
					float disSqr = temp.squareLength()*0.0004f;
					atDot.pos.x+=sin(demoTime*0.0023f + i*0.311f)*disSqr;
					atDot.pos.y+=cos(demoTime*0.00230314f + i*0.421f + 0.453f)*disSqr;
				}
				if( currLevel == 2 )
				{
					float disSqr = temp.squareLength()*0.0017f;
					atDot.pos.x+=sin(demoTime*0.0023f + i*0.311f + playa.pos.y*0.01f)*disSqr;
					atDot.pos.y+=cos(demoTime*0.00230314f + i*0.421f + 0.453f - playa.pos.x*0.0134f)*disSqr;
				}
				if( currLevel == 3 )
				{
					float disSqr = temp.squareLength()*0.0017f;
					atDot.pos.x+=sin(demoTime*0.0023f + i*0.311f + playa.pos.y*0.01f)*disSqr;
					atDot.pos.y+=cos(demoTime*0.00230314f + i*0.421f + 0.453f)*disSqr*1.4f;
					atDot.radi = (sin(demoTime*0.00230314f + i*0.421f)*2.5 + 2.8)*disSqr*0.05f + 5.0f; 
					glColor4f(1.0,1.0,1.0,0.3f);
				}
				if( currLevel == 4 )
				{
					//some PI MAGIC. 
					float tMagic = i/static_cast<float>(lastDeadAttach);
					float disSqr = temp.squareLength()*0.0004f;
					atDot.pos.x+=sin(demoTime*0.0023f + tMagic*M_PI*2.0f + playa.velocity.x*0.004f)*temp.x*0.5f;
					atDot.pos.y+=cos(demoTime*0.0023f + tMagic*M_PI*2.0f - playa.velocity.y*0.004f)*temp.y*0.5f;
				}
			}
			
			
			//first delay on this ting.
			atDot.delayUntilPopScale-=dTime;
			if(atDot.delayUntilPopScale<=0)
			{
				atDot.delayUntilPopScale = 0;
				atDot.currScale+=atDot.popScaleSpeed;
				if(atDot.currScale>=1.0f)
				{
					atDot.currScale=1.0f;
				}
			}

			
			float tempRadi = atDot.radi;
			atDot.radi *= atDot.currScale;
			atDot.draw();
			glColor4f(1.0,1.0,1.0,1.0f);
			atDot.radi = tempRadi;
			atDot.radi = radiTemp;
			atDot.pos = temp;
		}

	}

	bool collide=false;
	/*playa.radi-=20.1f*dTimes;
	if(playa.radi<=15.0f)
	playa.radi=15.0f;*/
	//playa.colRadi = playa.radi*0.5f;
	for(unsigned int i=0; i < dangerDots.size(); i++)
	{
		sDangerDot &danger = dangerDots[i];
		if(danger.alive)
		{
			danger.pos+=danger.velocity*danger.shotSpeed*dTimes;
			if(posOutOfGrid(danger.pos,danger.radi))
			{
				danger.alive=false;
				dangerDotDeathSwap(i);
			}
			else if(danger.collision(playa))
			{
				danger.alive=false;
				dangerDotDeathSwap(i);
				collide = true;
				break;

			}
			danger.draw();
		}
	}

	if(collide)
	{

		if(lastDeadAttach>0)
		{
			//remove 20 flowers.
			currScore-=335;
			for(int j=0; j < 335; j++)
			{
				if(lastDeadAttach!=0)
				{
					attachedDots[lastDeadAttach-1].alive = false;
					attachDotDeathSwap(lastDeadAttach-1);
				}
			}
		}
			
		else
		{
			reload();

			if(currScore > topScore)
			{
				topScore = currScore;
			}
			lastScore = currScore;

			currScore = 0;
		}
	}

	

//glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
	drawNumber(currLevel +1,
			   cVec2f(64.0f,660.0f),
			   cVec2f(32,64));

	int percy = (currScore*100) / levelNeeds[currLevel];

	drawNumber(percy,
			   cVec2f(64.0f,560.0f),
			   cVec2f(32,64));

	getTexture("0-9/Percent.png").bindTexture();
	drawSprite(cVec2f(124.0f,560.0f),
			   cVec2f(32,64));

	
	glColor4f(1.0f,1.0f,1.0f,0.3f);
	drawNumber(300000 - demoTime,
			   cVec2f(464.0f,460.0f),
			   cVec2f(32,64));
	glColor4f(1.0f,1.0f,1.0f,1.0f);

	glPopMatrix();
}


void initRogg()
{
	rb.initGame("whois.rolf");
}

void doRogg()
{
	rb.doGame();
}