#include <iostream>
#include <fusa.h>
#ifdef WIN32
#include <SDL.h>
#include <fmod.hpp>
#include <fmod_errors.h>
#endif
#ifdef linux
#endif
#include "gamecore.h"

#include "gamecore.h"

using namespace fusa;
void reshape(int w,int h);
void render();
fusa::cDirectFrameBuffer framebuff(800,
				   600,
				   GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);

cMatrix4<float> projection;

long dTime=0;
long demoTime=0;

std::vector<Uint8> keyRec;
std::vector<Uint8> lastFramekeyRec;

int  winW = 1024;
int  winH = 768;
bool exitGame=false;

std::vector<float> spectrum;
bool buttonDown(Uint8 button)
{
  return keyRec[button];
}

bool buttonUp(Uint8 button)
{
  return !keyRec[button];
}

bool buttonPress(Uint8 button)
{
  if(keyRec[button]==true && lastFramekeyRec[button]!=true)
    return true;
  return false;
}


float mouseX = 0.0f;
float mouseY = 0.0f;

float getMouseX()
{
	return mouseX;
}
float getMouseY()
{
return mouseY;
}

bool lastFrameMousePress = false;
bool thisFrameMousePress = false;
bool getMouseDown()
{
	return thisFrameMousePress;
}
bool getMousePress()
{
	return thisFrameMousePress && !lastFrameMousePress;
}

SpawnParticleSystem part_test;

#undef main
int main(int narg,const char **Args)
{
  std::cout<<"hello world!"<<std::endl;

  std::cout<<"hahah HAI"<<std::endl;
  fusa::logger<<"ait:"<<10<<std::endl;

  int vidFlags;
  SDL_Event event;
  const SDL_VideoInfo *vidInfo;
  if(SDL_Init(SDL_INIT_VIDEO|SDL_INIT_AUDIO|SDL_INIT_JOYSTICK) < 0)
    {
      //opps do error things here.
      std::cout<<"EROREROC OCK"<<std::endl;
    }

	initSound( );

	playMusak( );

	// TESTSAK
	

  //  atexit(SDL_Quit);
  vidInfo = SDL_GetVideoInfo();
  if(!vidInfo)
    {
      //oops do error things here.
      std::cout<<"EROREROC OCK 55"<<std::endl;
    }

  //set video flags.
  vidFlags = SDL_OPENGL;
  vidFlags |= SDL_GL_DOUBLEBUFFER;
  vidFlags |= SDL_HWPALETTE;
  vidFlags |= SDL_RESIZABLE;
  bool fullscreen = false;


  std::ifstream f_in;
  f_in.open("resolution.rolf");
  std::string tmp;
  std::getline(f_in,tmp,':');
  std::getline(f_in,tmp,':');
  if(tmp=="true" || tmp=="TRUE")
  {
	  fullscreen = true;
  }
   std::getline(f_in,tmp,':');
   f_in>>winW;
   std::getline(f_in,tmp,':');
   f_in>>winH;
   f_in.close();

  if(fullscreen)
    vidFlags|=SDL_FULLSCREEN;

  if(vidInfo->hw_available)
    {
      vidFlags|=SDL_HWSURFACE;
    }
  else
    {
      vidFlags|=SDL_SWSURFACE;
    }

  if(vidInfo->blit_hw)
    {
      vidFlags|=SDL_HWACCEL;
    }

  SDL_GL_SetAttribute(SDL_GL_DOUBLEBUFFER,1);
  /*  SDL_GL_SetAttribute(SDL_GL_MULTISAMPLEBUFFERS, 1);
    SDL_GL_SetAttribute(SDL_GL_MULTISAMPLESAMPLES, 4);
  glEnable(GL_MULTISAMPLE_ARB);*/
  SDL_Surface *sdlSurface;
  

  sdlSurface = SDL_SetVideoMode(winW,winH,32,vidFlags);


  

  reshape(winW,winH);

  glewInit();


  //INIT SOME HERE:
	initRogg();
    spectrum.resize(512);
    demoTime = 0;
     SDL_ShowCursor(SDL_DISABLE);
  
  do
    {
			  #ifdef VERYLOG
		fusa::logger<<"entering the message pump of sdl:"<<std::endl;
#endif 
      while(SDL_PollEvent(&event))
        {

			  
	  switch(event.type)
            {
	    case SDL_VIDEORESIZE:
	    //  SDL_SetVideoMode(event.resize.w,event.resize.h,32,vidFlags);
	      reshape(event.resize.w,event.resize.h);
	      break;
	    case SDL_QUIT:

	      exitGame=true;
            }
        }
      SDL_PumpEvents();
	  	  #ifdef VERYLOG
	  fusa::logger<<"exiting the message pump of sdl:"<<std::endl;
#endif
      Uint8* arr=0;
      int size=0;
      arr = SDL_GetKeyState(&size);
      lastFramekeyRec.resize(keyRec.size());

      for(unsigned int i=0; i < lastFramekeyRec.size(); i++)
	{
	  lastFramekeyRec[i] = keyRec[i];
	}
      keyRec.resize(size);
      for(unsigned int i=0; i < keyRec.size(); i++)
	{
	  keyRec[i] = arr[i];
	  //if(keyRec[i])
		//  std::cout<<"A HITSS"<<std::endl;
	}

	    int mX,mY;
		Uint8 mp =  SDL_GetMouseState(&mX,&mY);
		mouseX = mX/static_cast<float>(winW);
		mouseY =1.0- mY/static_cast<float>(winH);
		lastFrameMousePress = thisFrameMousePress;
		thisFrameMousePress = mp != 0;

 

	  #ifdef VERYLOG
       fusa::logger<<"rendering:"<<std::endl;
#endif
	   if(buttonDown(27))
		   exitGame=true;
      render();
	  #ifdef VERYLOG
	  fusa::logger<<"finished rendering swapping buffers:"<<std::endl;
#endif
      SDL_GL_SwapBuffers();
	  #ifdef VERYLOG
	  fusa::logger<<"swapped buffers, your screen should be filled with colors."<<std::endl;
#endif
    }while(!exitGame);



}

void reshape(int w,int h)
{
	winW = w;
	winH = h;
  setPerspective(projection,90.0f,1.0f,0.01,20000.0f);
  framebuff.setSize(cVec2f(w,h));
  glMatrixMode(GL_MODELVIEW);
}


float mix = 0;

void render()
{
	//mixMusak( getMouseY( ) );
	
	float tmp_mix = (float)rb.lastDeadAttach/1000;

	if( mix < tmp_mix ) mix += 0.001;
	if( mix > tmp_mix ) mix -= 0.001;

	if( mix > 1.0f ) mix = 1.0f;
	if( mix < 0.0f ) mix = 0.0f;
	mixMusak( mix );

	//std::cout << mix << "\n";
	
	//mixMusak( 0 );

	updateSelect( );
	updateRocket( );
	updateDeath( );

	//channel->getSpectrum(&spectrum[0],spectrum.size(),0,FMOD_DSP_FFT_WINDOW_RECT);

  framebuff.setClearColor(cVec4f(0,0,0,0));
  framebuff.start();
  //glEnable(GL_DEPTH_TEST);
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  glOrtho(0,1024,0,768,0.0,1.0);
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();

  
  static long int pastTime=SDL_GetTicks();
  long int nowTime = SDL_GetTicks();
  dTime = nowTime - pastTime;
  pastTime = nowTime;
  static long counter=0;
  counter+=dTime;
  demoTime+=dTime;
  if(counter>500)
    {
      //std::cout<<"fps:"<<1000.0f/dTime<<std::endl;
      counter=0;
    }
  //RENDER SOME HERE!!


	
	//fusa::getTexture( "test.png" ).bindTexture( 0 );
	//drawSprite( fusa::cVec2f( 0, 0 ), fusa::cVec2f( 1, 1 ) );

  fusa::getTexture( "Backdrop.png" ).bindTexture( 0 );
  glColor4f( 1.0f, 1.0f, 1.0f, 1.0f );
  drawSprite( fusa::cVec2f( 512, 512-50 ), fusa::cVec2f( 1024, 1024 ) );

  part_test.pos = ( fusa::cVec2f( getMouseX( )*winW, getMouseY( )*winH ) );

  for( std::vector<sDangerSpawn>::iterator idh = rb.dangerHoles.begin( ); idh != rb.dangerHoles.end( ); ++idh )
  {
	  part_test.pos = (*idh).pos;
	  part_test.render( );
  }

  doRogg();
	//part_test.setPos( fusa::cVec2f( getMouseX( )*winW, getMouseY( )*winH ) );

	//part_test.render( );
  
	drawSplash( );

  framebuff.finish();

}


