#include "picture.c"

//////////////////////////////////////////////////////////////////

void vidmode(int);
#pragma aux vidmode =\
    "int 10h"\
    parm [ax] modify [ax];

//////////////////////////////////////////////////////////////////

void setpal(int c, int r, int g, int b)
{
    outp(0x3c8,c&255);
    outp(0x3c9,r&63);
    outp(0x3c9,g&63);
    outp(0x3c9,b&63);
} //setpal

//////////////////////////////////////////////////////////////////

void main(void)
{
    int i;

    // get into video mode 13 (320x200x256)
    vidmode(0x13);

    // set the palette to a greyscale palette
    // fading from 0,0,0 (black) to 63,63,63 (white)
    for (i=0; i<256; i++)
        setpal(i, i/4, i/4, i/4);

    // copy the object (in this case, an image) to
    // the vga memory (0xa0000)
    memcpy (0xa0000, picture_raw, 64000);

    // wait for a key
    getch();

    // switch back to txtmode
    vidmode(0x03);

} //main
