; ADATOK:
; -------
; A sugr (flegyenes)
;                          _
;       - kiindul pontja: P = (Px,Py,Pz)
;                 _
;       - irnya: D = (Dx,Dy,Dz)      <--  egysgnyi vektor
; 
; Az Y tengelyirny sk
;                         _
;       - norml vektora: N = (0,1,0)
;                     _
;       - egy pontja: Po = (0,Yo,0)
; 
;
; SZMOLS:
; ---------
; A tvolsg (t)
; 
;           Yo - Py
;       t = ------- , ha Dy <> 0
;             Dy
; vagy
; 
;       V = Yo - Py
;
;           V
;       t = -- , ha Dy <> 0
;           Dy
; 
;                _
; A metszspont (M)
;       _   _       _
;       M = P + t * D, ha t > 0
; 
;       azaz
;       _
;       M = (Px + t * Dx, Py + t * Dy, Pz + t * Dz), ha t > 0
; ___________________________________________________________________________

Ground_YType    STRUC
                Object<>
GBase           DQ      ?
GNdotP          DQ      ?
ENDS

Ground_Y        MACRO   _Yo,_Texture:REQ,_Next

                ObjectInit Ground_Y,_Texture,_Next

                DQ      _Yo
                DQ      ?
ENDM

Ground_YInitO:
                NextInitO

Ground_YInitF:
                FLD     [SI.GBase]
                FSUB    [BX.EyePos.Y]
                FSTP    [SI.GNdotP]
                NextInitF

Ground_YFirst:
                FLD     [Direction.Y]
                FABS
                FCOMP   Epsilon
                FNSTSW  AX
                SAHF
                JBE     @@0
                FLD     [SI.GNdotP]
                FDIV    [Direction.Y]
                FCOM    Distance
                FNSTSW  AX
                SAHF
                JAE     @@1
                FCOM    Epsilon
                FNSTSW  AX
                SAHF
                JBE     @@1
                MOV     BX,SI
                MOV     SI,[SI.NextO]
                FSTP    Distance
                CMP     SI,FirstO
                JE      LastFirst
                JMP     O [SI.First]
@@1:
                NextFirst 1
@@0:
                NextFirst

Ground_YShade:
COMMENT ~
                FLD     [Shadow.Y]
                FABS
                FCOMP   Epsilon
                FNSTSW  AX
                SAHF
                JBE     @@0
                FLD     [SI.GBase]
                FSUB    [Position.Y]
                FDIV    [Shadow.Y]
                FCOM    Epsilon
                FNSTSW  AX
                SAHF
                JBE     @@1
                FCOMP   Distance
                FNSTSW  AX
                SAHF
                JAE     @@0
                CALL    O [SI.Texture]
                FLD     [DI.Transmit]   ; T
                FTST
                FNSTSW  AX
                SAHF
                JNZ     @@2
                MOV     [BX.Cache],SI
                RETN
@@2:
                MOV     SI,[SI.NextO]
                FMUL    Trans           ; P*T
                FSTP    Trans
                CMP     SI,FirstO
                JE      LastShade
                JMP     O [SI.Shade]
@@1:
                NextShade 1
@@0:
~
                NextShade

Ground_YIsect:
                FLD     [Direction.Y]
                FABS
                FCOMP   Epsilon
                FNSTSW  AX
                SAHF
                JBE     @@0
                FLD     [SI.GBase]
                FSUB    [Position.Y]
                FDIV    [Direction.Y]
                FCOM    Distance
                FNSTSW  AX
                SAHF
                JAE     @@1
                FCOM    Epsilon
                FNSTSW  AX
                SAHF
                JBE     @@1
                MOV     BX,SI
                MOV     SI,[SI.NextO]
                FSTP    Distance
                CMP     SI,FirstO
                JE      LastIsect
                JMP     O [SI.Isect]
@@1:
                NextIsect 1
@@0:
                NextIsect

Ground_YNorml:
                FLD     Zero
                FLD     Plus1
                FLD     ST(1)
                RETN
