;----------------------------------------------------------------------------\
;  32-bit string operations - macro library by TomCat/Abaddon - version 1.01  >
;----------------------------------------------------------------------------/
;
; Comment: Compiling with the /DOPTI option, you got the quicker code but 
;          the larger code size.
;
; Definied macros: _LODSB,_STOSB,_MOVSB,_SCASB,_CMPSB
;                  _LODSW,_STOSW,_MOVSW,_SCASW,_CMPSW
;                  _LODSD,_STOSD,_MOVSD,_SCASD,_CMPSD
;                  _REPSTOSB,_REPMOVSB,_REPNESCASB,_REPECMPSB
;                  _REPSTOSW,_REPMOVSW,_REPNESCASW,_REPECMPSW
;                  _REPSTOSD,_REPMOVSD,_REPNESCASD,_REPECMPSD
;                  _LOOP _Label

_LODSB          MACRO

        IFNDEF Opti
                LODS B [ESI]
        ELSE
                MOV     AL,[ESI]
                INC     ESI
        ENDIF
ENDM

_STOSB          MACRO

        IFNDEF Opti
                STOS B [EDI]
        ELSE
                MOV     ES:[EDI],AL
                INC     EDI
        ENDIF
ENDM

_MOVSB          MACRO

        IFNDEF Opti
                MOVS B [EDI],[ESI]
        ELSE
                MOV     AL,[ESI]
                INC     ESI
                MOV     ES:[EDI],AL
                INC     EDI
        ENDIF
ENDM

_SCASB          MACRO

                SCAS B [EDI]
ENDM

_CMPSB          MACRO

                CMPS B [ESI],[EDI]
ENDM

_LODSW          MACRO

        IFNDEF Opti
                LODS W [ESI]
        ELSE
                MOV     AL,[ESI]
                ADD     ESI,2
        ENDIF
ENDM

_STOSW          MACRO

        IFNDEF Opti
                STOS W [EDI]
        ELSE
                MOV     ES:[EDI],AX
                ADD     EDI,2
        ENDIF
ENDM

_MOVSW          MACRO

        IFNDEF Opti
                MOVS W [EDI],[ESI]
        ELSE
                MOV     AX,[ESI]
                ADD     ESI,2
                MOV     ES:[EDI],AX
                ADD     EDI,2
        ENDIF
ENDM

_SCASW          MACRO

                SCAS W [EDI]
ENDM

_CMPSW          MACRO

                CMPS W [ESI],[EDI]
ENDM

_LODSD          MACRO

        IFNDEF Opti
                LODS D [ESI]
        ELSE
                MOV     EAX,[ESI]
                ADD     ESI,4
        ENDIF
ENDM

_STOSD          MACRO

        IFNDEF Opti
                STOS D [EDI]
        ELSE
                MOV     ES:[EDI],EAX
                ADD     EDI,4
        ENDIF
ENDM

_MOVSD          MACRO

        IFNDEF Opti
                MOVS D [EDI],[ESI]
        ELSE
                MOV     EAX,[ESI]
                ADD     ESI,4
                MOV     ES:[EDI],EAX
                ADD     EDI,4
        ENDIF
ENDM

_SCASD          MACRO

                SCAS D [EDI]
ENDM

_CMPSD          MACRO

                CMPS D [ESI],[EDI]
ENDM

_REPSTOSB       MACRO
        LOCAL   _1

        IFNDEF Opti
                REP     STOS B [EDI]
        ELSE
_1:
                MOV     ES:[EDI],AL
                INC     EDI
                DEC     ECX
                JNZ     _1
        ENDIF
ENDM

_REPMOVSB       MACRO
        LOCAL   _1

        IFNDEF Opti
                REP     MOVS B [EDI],[ESI]
        ELSE
_1:
                MOV     AL,[ESI]
                INC     ESI
                MOV     ES:[EDI],AL
                INC     EDI
                DEC     ECX
                JNZ     _1
        ENDIF
ENDM

_REPNESCASB     MACRO

                REPNE   SCAS B [EDI]
ENDM

_REPECMPSB      MACRO

                REPE    CMPS B [ESI],[EDI]
ENDM

_REPSTOSW       MACRO
        LOCAL   _1

                REP     STOS W [EDI]
        ELSE
_1:
                MOV     ES:[EDI],AX
                ADD     EDI,2
                DEC     ECX
                JNZ     _1
        ENDIF
ENDM

_REPMOVSW       MACRO
        LOCAL   _1

        IFNDEF Opti
                REP     MOVS W [EDI],[ESI]
        ELSE
_1:
                MOV     AX,[ESI]
                ADD     ESI,2
                MOV     ES:[EDI],AX
                ADD     EDI,2
                DEC     ECX
                JNZ     _1
        ENDIF
ENDM

_REPNESCASW     MACRO

                REPNE   SCAS W [EDI]
ENDM

_REPECMPSW      MACRO

                REPE    CMPS W [ESI],[EDI]
ENDM

_REPSTOSD       MACRO
        LOCAL   _1

        IFNDEF Opti
                REP     STOS D [EDI]
        ELSE
_1:
                MOV     ES:[EDI],EAX
                ADD     EDI,4
                DEC     ECX
                JNZ     _1
        ENDIF
ENDM

_REPMOVSD       MACRO
        LOCAL   _1

        IFNDEF Opti
                REP     MOVS D [EDI],[ESI]
        ELSE
_1:
                MOV     EAX,[ESI]
                ADD     ESI,4
                MOV     ES:[EDI],EAX
                ADD     EDI,4
                DEC     ECX
                JNZ     _1
        ENDIF
ENDM

_REPNESCASD     MACRO

                REPNE   SCAS D [EDI]
ENDM

_REPECMPSD      MACRO

                REPE    CMPS D [ESI],[EDI]
ENDM

_LOOP   MACRO   _Label

        IFNDEF Opti
         IF @WordSize EQ 2
                DB      67H
                LOOP    _Label
         ELSE
                LOOP    _Label
         ENDIF
        ELSE
                DEC     ECX
                JNZ     _Label
        ENDIF
ENDM

                                                  ;-) tomcat@szif.hu 