include promise.inc
locals
jumps
csiga   segment public  use16
assume  cs:csiga,ds:csiga,es:protseg

SZELES=214
MAGAS=128
DARAB=168

PlusMem=SZELES*MAGAS*4/16
;Teszt: MODU=2048

NoP5:

BORDERS=0

Scalar  EQU     DD      ?

Vector          STRUC
X               Scalar
Y               Scalar
Z               Scalar
ENDS

Sphere          STRUC
Center          Vector<>
Radius2         Scalar
Radius          Scalar
ENDS

Surface         STRUC
Diffuse         Vector<>
Specular        Scalar
Shine           Scalar
Luminous        Vector<>
ENDS

Light           STRUC
Position        Vector<>
ENDS

INCLUDE VECTMATH.LIB                    ; Lineris algebra makri
include macrodef.lib
;..............................................................................
public  shell
shell:
                sti
                mov     ax,protseg
                mov     es,ax
                mov     eax,PlusMem*16
                call    getrealmemsegf
                push    cs cs
                pop     ds es
                mov     ZBuffer,ax

                CALL    SetTrueColor
                STI
                JNZ     Vege1
                MOV     DX,3D4H
                MOV     AX,209H
                OUT     DX,AX
                FNINIT                  ; koprocesszor init
;..............................................................................
COMMENT ~
                PUSH    0A000H
                POP     ES
                XOR     DI,DI
                MOV     AH,192/2
                MOV     BX,256*20+92/2
                MOV     CX,160
@@1:
                MOV     DX,640
@@2:
                MOV     AL,AH
                STOSB
                TEST    DI,DI
                JNZ     @@21
                PUSH    AX BX DX
                CALL    NextBank
                POP     DX BX AX
@@21:
                MOV     AL,BL
                STOSB
                TEST    DI,DI
                JNZ     @@22
                PUSH    AX BX DX
                CALL    NextBank
                POP     DX BX AX
@@22:
                MOV     AL,BH
                STOSB
                ADD     DI,Reserv
                TEST    DI,DI
                JNZ     @@23
                PUSH    AX BX DX
                CALL    NextBank
                POP     DX BX AX
@@23:
                DEC     DX
                JNZ     @@2
                MOV     DX,Modulo
                SUB     DX,640*3
                CMP     Reserv,0
                JZ      @@3
                SUB     DX,640
@@3:
                ADD     DI,DX
                JNC     @@4
                PUSH    AX BX
                CALL    NextBank
                POP     BX AX
@@4:
                LOOP    @@1
~
;..............................................................................
Path0:
                MOV     SI,O Expon
                MOV     DI,O Path
                MOV     CX,DARAB
                FLDPI
                FMUL    Step
                FST     Step
                FMUL    Index           ; Angle
@@1:
                FLD     ST              ; Angle  Angle
                FSINCOS                 ; COS(Angle)  SIN(Angle)  Angle
                FMUL    D [SI]          ; Radius*COS(Angle)  SIN(Angle)  Angle
                FSTP    [DI.Center.Y]   ; SIN(Angle)  Angle
                FMUL    D [SI]          ; Radius*SIN(Angle)  Angle
                FSTP    [DI.Center.X]   ; Angle
                FLD     Minus2          ; -2  Angle
                FMUL    D [SI]          ; -2*Radius  Angle
                FSTP    [DI.Center.Z]   ; Angle
                FLD     D [SI]          ; Radius  Angle
                FST     [DI.Radius]     ; Radius  Angle
                FMUL    D [SI]          ; Radius2  Angle
                FSTP    [DI.Radius2]    ; Angle
                FSUB    Step            ; NextAngle
                ADD     SI,4
                ADD     DI,SIZE Sphere
                LOOP    @@1
                FSTP    Step
;..............................................................................
ZInit1:
                MOV     FS,ZBuffer
                XOR     BP,BP
                MOV     CX,SZELES*MAGAS/2
                FLD     Infinite
@@1:
                FST     D FS:[BP]
                ADD     BP,4
                LOOP    @@1
                MOV     AX,FS
                ADD     AX,SZELES*MAGAS/2*4/16
                XOR     BP,BP
                MOV     FS,AX
                MOV     CX,SZELES*MAGAS/2-1
@@2:
                FST     D FS:[BP]
                ADD     BP,4
                LOOP    @@2
                FSTP    D FS:[BP]
;..............................................................................
Pic1:
                PUSH    0A000H
                MOV     BX,O Path
                MOV     SI,O YLoopEnd
                POP     ES
MAIN:
                PUSH    SI BX
                XOR     DX,DX
                CALL    GoBank
                MOV     DI,Modulo
                POP     BX
                SHL     DI,4
                MOV     CX,[SI]
                ADD     DI,106*3
                CMP     Reserv,0
                JZ      @@2
                ADD     DI,106
@@2:
                MOV     FS,ZBuffer
                XOR     BP,BP
                FLD     MTop
YCIK3:
                FSTP    LoopY
                FLD     MLeft
                CMP     BP,SZELES*MAGAS/2*4
                JNE     @@0
                MOV     AX,FS
                ADD     AX,SZELES*MAGAS/2*4/16
                XOR     BP,BP
                MOV     FS,AX
@@0:
                PUSH    CX
                MOV     CX,SZELES
XCIK3:
                PUSH    BX CX
                FST     LoopX
                VNMULF  At
                VNADD   Gaze
                VMULF   Up,LoopY
                VNADD
                VNORM
                VLD     From
                VSTP    PointV
                CALL    Trace
                FLD     LoopX           ; LoopX
                FADD    ResX            ; LoopX
                ADD     BP,4
                POP     CX BX
                LOOP    XCIK3
                FSTP    LoopX
                FLD     LoopY           ; LoopY
                FADD    ResY            ; LoopY
                MOV     AX,Modulo
                SUB     AX,SZELES*2*3
                CMP     Reserv,0
                JZ      @@8
                SUB     AX,SZELES*2
@@8:
                ADD     DI,AX
                JNC     @@9
                PUSH    BX
                CALL    NextBank
                POP     BX
@@9:
                POP     CX
                LOOP    YCIK3
                FSTP    LoopY
                POP     SI
                ADD     BX,SIZE Sphere
                ADD     SI,2
                CMP     BX,O Path+DARAB*SIZE Sphere
                JC      MAIN
                MOV     CX,150
PIHI:
                WaitRetrace
                LOOP    PIHI
;..............................................................................
Cls1:
                PUSH    0A000H
                MOV     AX,160-1
                POP     ES
                MUL     Modulo
                XCHG    DI,AX
                XCHG    DX,AX
                CALL    SetBank
                XOR     BP,BP
                MOV     CX,160
                XOR     SI,SI
@@1:
                PUSH    CX
                MOV     DX,3DAH
@@2:
                IN      AL,DX
                TEST    AL,8
                JZ      @@2
                CALL    Vonal
                MOV     AX,Modulo
                ADD     AX,AX
                ADD     AX,Modulo
                SUB     DI,AX
                JNC     @@4
                CALL    PrevBank
@@4:
                MOV     DX,Bank
                XCHG    DI,SI
                XCHG    DX,BP
                CALL    GoBank
                CALL    Vonal
                ADD     DI,Modulo
                JNC     @@3
                CALL    NextBank
@@3:
                MOV     DX,Bank
                XCHG    DI,SI
                XCHG    DX,BP
                CALL    GoBank
                POP     CX
                LOOP    @@1
;..............................................................................
Vege1:
                mov     ax,protseg
                mov     es,ax
                sub     prolomemstart,PlusMem*16
                retf


;..............................................................................
Vonal:
                XOR     EAX,EAX
                MOV     DX,Modulo
                SHR     DX,7
@@1:
                MOV     CX,128/4
                REP     STOSD
                TEST    DI,DI
                JNZ     @@2
                PUSH    AX DX
                CALL    NextBank
                POP     DX AX
@@2:
                DEC     DX
                JNZ     @@1
                RETN
;..............................................................................
SetBank:
                MUL     CS:Gran
                XCHG    DX,AX
GoBank:
                XOR     BX,BX
                MOV     CS:Bank,DX
                CALL    CS:Routin
                RETN
NextBank:
                MOV     DX,CS:Bank
                ADD     DX,CS:Gran
                JMP     GoBank
PrevBank:
                MOV     DX,CS:Bank
                SUB     DX,CS:Gran
                JMP     GoBank

SetTrueColor:
                MOV     BX,112H
                MOV     DI,O ZeroData
                MOV     CX,BX
                MOV     AX,4F01H
                INT     10H
                CMP     AX,004FH
                JE      @@1
                MOV     AX,10F0H
                MOV     BX,2EFFH
                INT     10H
                CMP     AX,0010H
                MOV     W Routin[2],CS
                RETN
@@1:
                MOV     AX,64
                DIV     B [DI+4]
                MOV     DX,[DI+10H]
                MOV     Gran,AX
                MOV     Modulo,DX
                MOV     AL,[DI+19H]
                MOV     EDX,[DI+0CH]
                SHR     AX,5
                MOV     Routin,EDX
                MOV     Reserv,AX
                MOV     AX,4F02H
                INT     10H
                XOR     BX,BX
                MOV     AX,4F07H
                MOV     CX,BX
                MOV     DX,BX
                INT     10H
                TEST    AL,0
                RETN

Tseng:
                XCHG    DX,AX
                MOV     DX,3CDH
                AND     AL,7
                DEC     BX
                JNZ     @@1
                SHL     AL,4
@@1:
                OUT     DX,AL
                RETF

Gran            DW      1
Modulo          DW      1920
Routin          LABEL   DWORD
                DW      O Tseng,?
Reserv          DW      0
Bank            DW      0
;..............................................................................
Trace:
;A legkzelebbi metszspont megkeresse
                VSTP    Incident
                XOR     SI,SI
                CALL    Isect
                TEST    SI,SI
                JZ      TE10
                MOV     BX,SI
                MOV     SI,O Anyag
;Metszspont
                FLD     [Incident.Z]  ;; AZ
                FMUL    D FS:[BP]     ;; AZ*S
                FLD     [Incident.Y]  ;; AY  AZ*S
                FMUL    D FS:[BP]     ;; AY*S  AZ*S
                FLD     [Incident.X]  ;; AX  AY*S  AZ*S
                FMUL    D FS:[BP]     ;; AX*S  AY*S  AZ*S
                VADD    PointV
                VSTP    PointV
;Hatrfny
                VNMULF  SI.Diffuse,Ambient
;nvilgts
                VADD    SI.Luminous
                VSTP    Collect
;Normlvektor
                VNSUB   PointV,BX.Center ; IX-CX  IY-CY  IZ-CZ
                VDIVFR  BX.Radius        ; NX  NY  NZ
                VST     Normal
                VNEG    Incident
                VDOT
                FTST
                FNSTSW  AX
                SAHF
                JNB     TE1
                FCHS
                VNEG    Normal
                VSTP    Normal
TE1:
                FSTP    Dot
;Szrtfny
                FLDZ
                VNSUB   PointV,PointL
                VST     Shadow
                VDOT    Normal
                FCOMPP
                FNSTSW  AX
                SAHF
                JAE     TE5
                VNORM   Shadow
                VST     Shadow
                VDOT    Normal
                FCHS
                VNMULF  SI.Diffuse
                VADD    Collect
                VSTP    Collect
;A Phong csillans
                FLD     Dot             ; Dot
                FADD    Dot             ; 2*Dot
                VNMULF  Normal          ; 2*Dot*NX  2*Dot*NY  2*Dot*NZ
                VNADD   Incident        ; 2*Dot*NX+VX  2*Dot*NY+VY  2*Dot*NZ+VZ
                VDOT    Shadow
                FCHS
                FCOM    Epsilon
                FNSTSW  AX
                SAHF
                JBE     TE4
                FLD     [SI.Shine]
                FXCH
                FYL2X
                FCOM    Minus2
                FNSTSW  AX
                SAHF
                JB      TE4
                FADD    Plus1
                F2XM1
                FADD    Plus1
                FMUL    Half
                FMUL    [SI.Specular]
                VADDF   Collect
                JMP     TE6
TE4:
                FSTP    Dummy
TE5:
TE9:
                VNLD    Collect
TE6:
                VMULFR  ColMaxVal
                FISTP   TBlue
                FISTP   TGreen
                FISTP   TRed
                MOV     AX,TBlue
                CMP     AX,255
                JC      @@1
                MOV     AL,255
@@1:
                STOSB
                TEST    DI,DI
                JNZ     @@11
                CALL    NextBank
@@11:
                MOV     AX,TGreen
                CMP     AX,255
                JC      @@2
                MOV     AL,255
@@2:
                STOSB
                TEST    DI,DI
                JNZ     @@22
                CALL    NextBank
@@22:
                MOV     AX,TRed
                CMP     AX,255
                JC      @@3
                MOV     AL,255
@@3:
                STOSB
                ADD     DI,Reserv
                TEST    DI,DI
                JNZ     @@4
                CALL    NextBank
@@4:
Masik:
                MOV     AX,TBlue
                CMP     AX,255
                JC      @@1
                MOV     AL,255
@@1:
                STOSB
                TEST    DI,DI
                JNZ     @@11
                CALL    NextBank
@@11:
                MOV     AX,TGreen
                CMP     AX,255
                JC      @@2
                MOV     AL,255
@@2:
                STOSB
                TEST    DI,DI
                JNZ     @@22
                CALL    NextBank
@@22:
                MOV     AX,TRed
                CMP     AX,255
                JC      @@3
                MOV     AL,255
@@3:
                STOSB
                ADD     DI,Reserv
                TEST    DI,DI
                JNZ     @@4
                CALL    NextBank
@@4:
                RETN
TE10:
                MOV     AX,6
                CMP     Reserv,0
                JZ      @@1
                ADD     AX,2
@@1:
                ADD     DI,AX
                JNC     @@2
                CALL    NextBank
@@2:
                RETN
;..............................................................................
Isect:
@@0:
                FLD     [BX.Center.X]   ; CX
                FSUB    [PointV.X]      ; CX-PX
                FLD     [BX.Center.Y]   ; CY  CX-PX
                FSUB    [PointV.Y]      ; CY-PY  CX-PX
                FLD     [BX.Center.Z]   ; CZ  CY-PY  CX-PX
                FSUB    [PointV.Z]      ; CZ-PZ  CY-PY  CX-PX
                FLD     [Incident.X]    ; DX  VZ  VY  VX
                FMUL    ST,ST(3)        ; DX*VX  VZ  VY  VX
                FLD     [Incident.Y]    ; DY  DX*VX  VZ  VY  VX
                FMUL    ST,ST(3)        ; DY*VY  DX*VX  VZ  VY  VX
                FLD     [Incident.Z]    ; DZ  DY*VY  DX*VX  VZ  VY  VX
                FMUL    ST,ST(3)        ; DZ*VZ  DY*VY  DX*VX  VZ  VY  VX
                FXCH    ST(2)           ; DX*VX  DY*VY  DZ*VZ  VZ  VY  VX
                FADDP                   ; DX*VX+DY*VY  DZ*VZ  VZ  VY  VX
                FLD     ST(2)           ; VZ  DX*VX+DY*VY  DZ*VZ  VZ  VY  VX
                FMULP   ST(3)           ; DX*VX+DY*VY  DZ*VZ  VZ*VZ  VY  VX
                FADDP                   ; DX*VX+DY*VY+DZ*VZ  VZ*VZ  VY  VX
                FLD     ST(2)           ; VY  DX*VX+DY*VY+DZ*VZ  VZ*VZ  VY  VX
                FMULP   ST(3)           ; DX*VX+DY*VY+DZ*VZ  VZ*VZ  VY*VY  VX
                FST     Dummy           ; b  VZ*VZ  VY*VY  VX
                FMUL    ST,ST           ; b*b  VZ*VZ  VY*VY  VX
                FXCH    ST(3)           ; VX  VZ*VZ  VY*VY  b*b
                FMUL    ST,ST           ; VX*VX  VZ*VZ  VY*VY  b*b
                FSUBP   ST(3)           ; VZ*VZ  VY*VY  b*b-VX*VX
                FSUBP   ST(2)           ; VY*VY  b*b-VX*VX-VZ*VZ
                FSUBP   ST(1)           ; b*b-VX*VX-VY*VY-VZ*VZ
                FADD    [BX.Radius2]    ; b*b-VX*VX-VY*VY-VZ*VZ+r*r
                FTST
                FNSTSW  AX
                SAHF
                JBE     @@3
                FSQRT                   ; d
                FLD     Dummy           ; b  d
                FSUB    ST,ST(1)        ; b-d  d
                FXCH                    ; d  b-d
                FADD    Dummy           ; b+d  b-d
                FCOM    Epsilon
                FXCH                    ; b-d  b+d
                FNSTSW  AX
                SAHF
                JBE     @@2
                FCOM    Epsilon
                FNSTSW  AX
                SAHF
                JBE     @@1
                FXCH                    ; b+d  b-d
@@1:
                FSTP    Dummy           ; t
                FCOM    D FS:[BP]
                FNSTSW  AX
                SAHF
                JNB     @@3
                FST     D FS:[BP]
                MOV     SI,BX
                FSTP    Dummy
                RETN
@@2:
                FSTP    Dummy
@@3:
                FSTP    Dummy
                RETN
;..............................................................................
        ALIGN   16
SizeX           DW      320
SizeY           DW      240
Angle           DD      45.0
ConvAngle       DD      0.008726646     ; Szg/2 -> Radian
Ospect          DD      0.888888889     ; A kparny (szgarny) default: 4/3

ColMaxVal       DD      255.0
Epsilon         DD      0.001
Infinite        DD      07F800000H      ; Konstans: 
Half            DD      0.5
Plus1           DD      1.0
Minus2          DD      -2.0

Ambient         DD      0.1

From            Vector<-6.0,-60.0,35.0>
At              Vector<1108060084,3225757950,0>
Up              Vector<3221426308,3250171066,3254680524>
Gaze            Vector<1086324736,1116209152,3259498496>
ResX            DD      1003277517
ResY            DD      1007192201

MLeft           DD      -0.7625
MTop            DD      -0.225

PointL          Vector<-100.0,-100.0,100.0>

Anyag           DD      0.32,0.64,0.8,0.2,45.277602,0.04,0.08,0.1

Index           DD      120.0
Step            DD      0.05

Expon:
                DD      16.902024
                DD      16.508435
                DD      16.124011
                DD      15.748538
                DD      15.381809
                DD      15.023621
                DD      14.673773
                DD      14.332071
                DD      13.998327
                DD      13.672355
                DD      13.353973
                DD      13.043005
                DD      12.739279
                DD      12.442625
                DD      12.152880
                DD      11.869881
                DD      11.593473
                DD      11.323501
                DD      11.059816
                DD      10.802271
                DD      10.550724
                DD      10.305034
                DD      10.065066
                DD      9.830685
                DD      9.601763
                DD      9.378171
                DD      9.159786
                DD      8.946486
                DD      8.738154
                DD      8.534673
                DD      8.335930
                DD      8.141815
                DD      7.952220
                DD      7.767041
                DD      7.586173
                DD      7.409517
                DD      7.236976
                DD      7.068451
                DD      6.903852
                DD      6.743085
                DD      6.586062
                DD      6.432695
                DD      6.282900
                DD      6.136593
                DD      5.993693
                DD      5.854121
                DD      5.717799
                DD      5.584651
                DD      5.454604
                DD      5.327585
                DD      5.203524
                DD      5.082352
                DD      4.964002
                DD      4.848408
                DD      4.735505
                DD      4.625231
                DD      4.517526
                DD      4.412328
                DD      4.309581
                DD      4.209225
                DD      4.111207
                DD      4.015471
                DD      3.921965
                DD      3.830636
                DD      3.741434
                DD      3.654309
                DD      3.569213
                DD      3.486098
                DD      3.404919
                DD      3.325630
                DD      3.248188
                DD      3.172549
                DD      3.098671
                DD      3.026514
                DD      2.956037
                DD      2.887201
                DD      2.819968
                DD      2.754301
                DD      2.690163
                DD      2.627518
                DD      2.566332
                DD      2.506571
                DD      2.448202
                DD      2.391192
                DD      2.335509
                DD      2.281123
                DD      2.228004
                DD      2.176122
                DD      2.125447
                DD      2.075953
                DD      2.027611
                DD      1.980395
                DD      1.934279
                DD      1.889236
                DD      1.845242
                DD      1.802273
                DD      1.760304
                DD      1.719313
                DD      1.679276
                DD      1.640172
                DD      1.601978
                DD      1.564673
                DD      1.528237
                DD      1.492650
                DD      1.457891
                DD      1.423942
                DD      1.390783
                DD      1.358397
                DD      1.326765
                DD      1.295869
                DD      1.265693
                DD      1.236219
                DD      1.207432
                DD      1.179315
                DD      1.151853
                DD      1.125030
                DD      1.098832
                DD      1.073244
                DD      1.048252
                DD      1.023842
                DD      1.000000
                DD      0.976713
                DD      0.953969
                DD      0.931755
                DD      0.910057
                DD      0.888865
                DD      0.868167
                DD      0.847950
                DD      0.828204
                DD      0.808918
                DD      0.790081
                DD      0.771683
                DD      0.753713
                DD      0.736162
                DD      0.719019
                DD      0.702276
                DD      0.685922
                DD      0.669949
                DD      0.654349
                DD      0.639111
                DD      0.624228
                DD      0.609692
                DD      0.595495
                DD      0.581628
                DD      0.568084
                DD      0.554855
                DD      0.541934
                DD      0.529314
                DD      0.516989
                DD      0.504950
                DD      0.493191
                DD      0.481706
                DD      0.470489
                DD      0.459533
                DD      0.448832
                DD      0.438380
                DD      0.428172
                DD      0.418201
                DD      0.408463
                DD      0.398951
                DD      0.389661
                DD      0.380587
                DD      0.371725
                DD      0.363069
                DD      0.354614
                DD      0.346356
                DD      0.338291
                DD      0.330413
                DD      0.322719
                DD      0.315204
                DD      0.307864
                DD      0.300695
                DD      0.293693
                DD      0.286854
                DD      0.280174
                DD      0.273650
                DD      0.267277
                DD      0.261053
                DD      0.254974
                DD      0.249037
                DD      0.243238
                DD      0.237573
                DD      0.232041
                DD      0.226638
                DD      0.221360
                DD      0.216205
                DD      0.211171
                DD      0.206253
                DD      0.201450
                DD      0.196759
                DD      0.192177
                DD      0.187702
                DD      0.183331
                DD      0.179062
                DD      0.174892
                DD      0.170820
                DD      0.166842
                DD      0.162957
                DD      0.159162
                DD      0.155456
                DD      0.151836
                DD      0.148300
                DD      0.144847
                DD      0.141474
                DD      0.138179
                DD      0.134962
                DD      0.131819
                DD      0.128749
                DD      0.125751
                DD      0.122823
                DD      0.119963
                DD      0.117169
                DD      0.114441
                DD      0.111776
                DD      0.109173
                DD      0.106631
                DD      0.104148
                DD      0.101722
                DD      0.099354
                DD      0.097040
                DD      0.094780
                DD      0.092573
                DD      0.090417
                DD      0.088312
                DD      0.086255
                DD      0.084247
                DD      0.082285
                DD      0.080369
                DD      0.078497
                DD      0.076669
                DD      0.074884
                DD      0.073140
                DD      0.071437
                DD      0.069774
                DD      0.068149
                DD      0.066562
                DD      0.065012
                DD      0.063498
                DD      0.062019
                DD      0.060575
                DD      0.059165
                DD      0.057787
                DD      0.056441
                DD      0.055127
                DD      0.053843
                DD      0.052589
                DD      0.051365
                DD      0.050169
                DD      0.049000
                DD      0.047859
                DD      0.046745
                DD      0.045656
                DD      0.044593
                DD      0.043555
                DD      0.042540
                DD      0.041550
                DD      0.040582
                DD      0.039637
                DD      0.038714
                DD      0.037813
                DD      0.036932
                DD      0.036072
                DD      0.035232
                DD      0.034412
                DD      0.033610
                DD      0.032828
                DD      0.032063
                DD      0.031317
                DD      0.030587
                DD      0.029875
                DD      0.029179
                DD      0.028500
                DD      0.027836
                DD      0.027188
                DD      0.026555
                DD      0.025937
                DD      0.025333
                DD      0.024743
                DD      0.024167
                DD      0.023604
                DD      0.023054
                DD      0.022517
                DD      0.021993
                DD      0.021481
                DD      0.020981
                DD      0.020492
                DD      0.020015
                DD      0.019549
                DD      0.019094
                DD      0.018649
                DD      0.018215
                DD      0.017790
                DD      0.017376
                DD      0.016972
                DD      0.016576
                DD      0.016190
                DD      0.015813
                DD      0.015445
                DD      0.015085
                DD      0.014734
                DD      0.014391
                DD      0.014056
                DD      0.013729
                DD      0.013409
                DD      0.013097
                DD      0.012792
                DD      0.012494
                DD      0.012203
                DD      0.011919
                DD      0.011641
                DD      0.011370
                DD      0.011105
                DD      0.010847
                DD      0.010594
                DD      0.010347
                DD      0.010106
                DD      0.009871
                DD      0.009641
                DD      0.009417
                DD      0.009197
                DD      0.008983
                DD      0.008774
                DD      0.008570
                DD      0.008370
                DD      0.008175
                DD      0.007985
                DD      0.007799
                DD      0.007617
                DD      0.007440
                DD      0.007267
                DD      0.007098
                DD      0.006932
                DD      0.006771
                DD      0.006613
                DD      0.006459
                DD      0.006309
                DD      0.006162
                DD      0.006018
                DD      0.005878
                DD      0.005741
                DD      0.005608
                DD      0.005477
                DD      0.005350
                DD      0.005225
                DD      0.005103
                DD      0.004984
                DD      0.004868
                DD      0.004755
                DD      0.004644
                DD      0.004536
                DD      0.004430
                DD      0.004327
                DD      0.004227
                DD      0.004128
                DD      0.004032
                DD      0.003938
                DD      0.003846
                DD      0.003757
                DD      0.003669
                DD      0.003584
                DD      0.003500
YLoopEnd:
 DB 96,0,95,0,96,0,96,0,98,0,100,0,103,0,106,0,109,0,113,0,116,0,120,0,123,0
 DB 125,0,127,0,128,0,128,0,128,0,128,0,125,0,120,0,114,0,107,0,98,0,91,0,79
 DB 0,69,0,59,0,50,0,45,0,45,0,45,0,46,0,46,0,46,0,46,0,46,0,47,0,47,0,46,0,46
 DB 0,45,0,45,0,45,0,46,0,46,0,47,0,47,0,47,0,48,0,48,0,49,0,50,0,50,0,51,0,51
 DB 0,51,0,51,0,50,0,49,0,47,0,45,0,43,0,40,0,36,0,32,0,28,0,24,0,21,0,18,0,18
 DB 0,18,0,19,0,19,0,19,0,19,0,19,0,19,0,19,0,19,0,19,0,19,0,19,0,19,0,19,0,19
 DB 0,19,0,19,0,19,0,19,0,19,0,20,0,20,0,20,0,20,0,20,0,20,0,20,0,20,0,19,0,18
 DB 0,17,0,16,0,16,0,14,0,13,0,11,0,10,0,9,0,7,0,6,0,7,0,7,0,7,0,7,0,7,0,8,0
 DB 8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8
 DB 0,8,0,8,0,8,0,7,0,7,0,7,0,6,0,6,0,5,0,5,0,4,0,3,0,3,0,3,0,2,0,3,0,3,0,3,0
 DB 3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0
;..............................................................................
        ALIGN   16
ZeroData:
Path:
                DB      DARAB*SIZE Sphere DUP(?)

LoopX           Scalar
LoopY           Scalar

PointV          Vector<>                ; Nzpont
Dummy           Scalar                  ; Statiszta
Incident        Vector<>                ; Nzvektor
Normal          Vector<>                ; Fellet normlvektora
Dot             Scalar                  ; N*I skalrszorzat
Collect         Vector<>                ; A megtallt szin
Shadow          Vector<>                ; Az rnykvektor

TBlue           DW      ?
TGreen          DW      ?
TRed            DW      ?

ZBuffer         dw      ?

csiga   ends
end
