import QtQuick 2.3
import AdaptDemoSystem 1.0

Group {
    // surface textures
    property variant texList0: [
        "aalto.png",                 //0
        "meteor.png",                //1
        "bokeh_housus.png",          //2
        "kivitex1s.png",             //3
        "apobg.png",                 //4
        "bg_metsb.png",              //5
        "apo69.png",                 //6
        "glassy.png",                //7
        "loadnessiers.png",          //8
		"meteorblur.png",            //9
    ]

    // palette textures
    property variant texList1: [
        "palette_shot8.png",         //1000
        "palette_shot1.png",         //1001
        "palette_shot9_pliisu.png",  //1002
        "palette_shot5.png",         //1003
        "palette_shotgray.png",      //1004
        "palette_shotr.png",         //1005
        "palette_shotg.png",         //1006
        "palette_shotcyan.png",      //1007
    ]

    // fracture textures
    property variant texList2: [
        "colornoi1.png",             //2000
    ]

    // 8x8 partikle textures
    property variant texList3: [
        "particles_64_2048.png",     //3000
        "partik.png",                //3001
    ]

    // overlay textures
    property variant texList4: [
        "adapt.png",                 //4000
        "G16grid2.png",              //4001
        "the_overlay2.png",          //4002
        "go_deepr.png",              //4003
        "go_deepr_inv.png",          //4004
        "loader.png",                //4005
        "grad1.png",                 //4006
        "grad2.png",                 //4007
        "grad3.png",                 //4008
		"sungrad1.png",	             //4009
		"sungrad1a.png",             //4010
		"sungrad1b.png",             //4011
		"sungrad2.png",              //4012
		"sungrad2b.png",             //4013
        "ovl_nav.png",               //4014
        "ovl_10.png",                //4015
    ]






    id: texSel
    name: "texSel"

    property alias textureUnit: tex0.textureUnit
    property alias file: tex0.file

    property int texCount0: texList0.length
    property int texCount1: texList1.length
    property int texCount2: texList2.length
    property int texCount3: texList3.length
    property int texCount4: texList4.length
    property string texPrefix: "../../images/"

    property alias textureWrap: tex0.textureWrap

    TextureImage {
        id: tex0
        textureUnit: 0
        property int texInd: name!=="texSel" ? sync(texSel.name+".texInd"+textureUnit) : 0
        file: texPrefix+getTexFile(texInd)
    }

    function getTexFile(i) {
        if (i<1000) {
            return i < texList0.length ? texList0[i] : texList0[0];
        } else if (i<2000) {
            i-=1000;
            return i < texList1.length ? texList1[i] : texList1[0];
        } else if (i<3000) {
            i-=2000;
            return i < texList2.length ? texList2[i] : texList2[0];
        } else if (i<4000) {
            i-=3000;
            return i < texList3.length ? texList3[i] : texList3[0];
        } else if (i<5000) {
            i-=4000;
            return i < texList4.length ? texList4[i] : texList4[0];
        }
        return "bokeh_housus.png";
    }


}

