import QtQuick 2.3
import "../" // to import RocketScene
import "../_SharedQML"
import AdaptDemoSystem 1.0

RocketScene { 
  VariClock { id: zoomClock; clockSpeed: 0.3*sync("zoomPercent")}
  FlyCamera { }
  //setup default textures
  TextureImage {
    textureUnit: 0; file: "../../images/meteor.png";
    //file: "../../images/meteor_b.png"
    //file: "../../images/aalto.png"
    //file: "../../images/kivitex1s.png"
    //file: "../../images/PinkMedusa_black.png"
    //file: "../../images/siniku4.png"
    //file: "../../images/meteor.png"
    //file: "../../images/gas1.png"
  }
  TextureImage { textureUnit: 1; file: "../../images/_SK57414_normal.png"}
  TextureImage { textureUnit: 2; file: "../../images/area_lights.jpg"}
  Texture { textureUnit: 3; textureRT: "prev" }
  Texture { textureUnit: 4; textureRT: "prevBlur" }
  Texture { textureUnit: 5; textureRT: "prevNormal" }
  Group {
    // big mirror plane
    Shader { file: "smInfi" }
    DrawMesh {
      file: "mesh/box1m.lwo"; enabled: true; smoothNormals: true; normalSmoothAngle: 20; blendMode: "off"; depthTest: true; depthWrite: true; cull: true; cullBack: true; Pos { x: 0.0; y: -0.950; z: 0.0}
      Rot { d: 0; ax: 1.0; ay: 0.0; az: 0.0 }
      Sca { s: 10.0; x: 100.0; y: 1.0; z: 100.0 }
      ShaderParam { paramName: "g_uvScale"; paramValue: 0.50}
      ShaderParam { paramName: "g_texBrightness"; paramValue: 0.5}
      ShaderParam { paramName: "g_texAmbient"; paramValue: 0.001}
      ShaderParam { paramName: "g_bump"; paramValue: 0.250}
      ShaderParam { paramName: "g_prevAmount"; paramValue: 0.0 }
      ShaderParam { paramName: "g_prevBlurAmount"; paramValue: sync("prevBlurAmount")}
      ShaderParam { paramName: "g_color"; paramValueVec4: "1.0, 1.0, 1.10, 1.0"}
      ShaderParam { paramName: "g_bright"; paramValue: 1.0}
      ShaderParam { paramName: "g_zoomTime"; paramValue: zoomClock.time }
    }
  }
  // emitter ball shape, the actual emitter is in the end of the skene
  Shader { file: "smPlastic" }
  TextureImage { textureUnit: 0; file: "../../images/meteor.png"}
  DrawMesh {
    enabled: false; Pos { x: 2.0; y: 6.0; z: 0.50}
    Sca { s: 6.0}
    file: "mesh/ball5000.x"; depthWrite: true; blendMode: "off"; ShaderParam { paramName: "g_uvScale"; paramValue: 0.30}
    ShaderParam { paramName: "g_bump"; paramValue: 0.50}
    ShaderParam { paramName: "g_texBrightness"; paramValue: 0.02 }
    ShaderParam { paramName: "g_texAmbient"; paramValue: 0.0020 }
    ShaderParam { paramName: "g_prevAmount"; paramValue: 0.0 }
    ShaderParam { paramName: "g_prevBlurAmount"; paramValue: sync("prevBlurAmount") }
    ShaderParam { paramName: "g_color"; paramValueVec4: "2.0, 1.50, 1.0, 1.0"}
    ShaderParam { paramName: "g_bright"; paramValue: 1.0}
  }
  // mirror ball
  DrawMesh {
    file: "mesh/ball5000.x";
    // "mesh/puppet_jump.dae","mesh/Cave.dae","mesh/aivob.x","mesh/400x400.obj"
    enabled: true; smoothNormals: true; normalSmoothAngle: 20; blendMode: "off"; depthTest: true; depthWrite: true;
    //  cull: true; cullBack: true
    Sca { s: 10.0; x: 1.0; y: 1.0; z: 1.0 }
    Pos { x: 0.0; y: -0.005; z: 0.0}
    Rot { d: -90; ax: 1.0; ay: 0.0; az: 0.0 }
    ShaderParam { paramName: "g_uvScale"; paramValue: 1.5}
    ShaderParam { paramName: "g_bump"; paramValue: 0.650}
    ShaderParam { paramName: "g_texBrightness"; paramValue: 0.01 }
    ShaderParam { paramName: "g_texAmbient"; paramValue: 0.00 }
    ShaderParam { paramName: "g_prevAmount"; paramValue: 0.0 }
    ShaderParam { paramName: "g_prevBlurAmount"; paramValue: sync("prevBlurAmount") }
    ShaderParam { paramName: "g_color"; paramValueVec4: "1.0, 1.0, 1.0, 1.0"}
    ShaderParam { paramName: "g_bright"; paramValue: 1.0}
  }



  //grower emit, advance & draw

  Group {
      id: boxGrower
      name: "boxGrower"
      enabled: sync(boxGrower.name+".ON")

      // diffuse texture
      TextureImage { textureUnit: 0; file: "../../images/meteor.png"}

      // age-swipe texture
      TextureImage { textureUnit: 1; file: "../../images/palette_shot8.png"}
    //  TextureImage { textureUnit: 1; file: "../../images/DrWhite.png"}


      VariClock {
          id: boxGrowerSwipeTime
          clockSpeed: sync(boxGrower.name+".swipe.speed")
          reset: sync(boxGrower.name+".swipeSpeed.reset")
          triggerReset: sync(boxGrower.name+".swipeFade.trigger")
          resetTime: sync(boxGrower.name+".swipeSpeed.resetTime")
      }


      VariClock {
          id: boxGrowerSwipeFadeTime
          clockSpeed: sync(boxGrower.name+".swipe.fadeSpeed")
          reset: sync(boxGrower.name+".swipeSpeed.reset")
          triggerReset: sync(boxGrower.name+".swipeFade.trigger")
          resetTime: sync(boxGrower.name+".swipeSpeed.resetTime")
      }

      Trigger {
          id: boxSwipeFadeTrigger
          reset: sync(boxGrower.name+".swipeFade.trigger")
      }


      DrawTrans2 {
        id: drawTrans; name: "trans"; emitIntervalMS: sync(boxGrower.name+".emitNewInterval");
        file: "mesh/boxcut.lwo";
       // file: "mesh/dode.lwo";
        shaderVaryings: "vec3 posG; vec3 normalG; vec2 uvG; vec3 tangentG; float brightG; vec3 origCenterG; vec4 branchInfoG;";
        zoomPercent: 1.0*sync("zoomPercent");

        drawBlendMode: "normal"

        // transShader contains both emit & advance code
        transShader: "branchTrans";
        transParams: ParamGroup {
            ShaderParam { paramName: "g_discardEdgeLen"; paramValue: sync(boxGrower.name+".grow.discardEdgeLen") }
            ShaderParam { paramName: "g_maxDist"; paramValue: sync(boxGrower.name+".grow.maxDist") }
            ShaderParam { paramName: "g_branchEveryN"; paramValue: sync(boxGrower.name+".grow.branchEveryN") }
            ShaderParam { paramName: "g_branchMax"; paramValue: sync(boxGrower.name+".grow.maxBranch") }
            ShaderParam { paramName: "g_maxLevel"; paramValue: sync(boxGrower.name+".grow.maxLevel") }
            ShaderParam { paramName: "g_maxAge"; paramValue: sync(boxGrower.name+".grow.maxAge") }
            ShaderParam { paramName: "g_branchMoveFreq"; paramValue: sync(boxGrower.name+".grow.moveFreq") }
            ShaderParam { paramName: "g_branchMoveFreqVar"; paramValue: sync(boxGrower.name+".grow.moveFreqVar") }
            ShaderParam { paramName: "g_branchGrowScale"; paramValue: sync(boxGrower.name+".grow.sca") }
            ShaderParam { paramName: "g_branchGrowScaleVar"; paramValue: sync(boxGrower.name+".grow.scaVar") }
            ShaderParam { paramName: "g_branchGrowScaleVarFreq"; paramValue: sync(boxGrower.name+".grow.scaVarFreq") }
            ShaderParam { paramName: "g_branchGrowScaleVarPhase"; paramValue: sync(boxGrower.name+".grow.scaVarPhase") }
            ShaderParam { paramName: "g_branchMove"; paramValue: sync(boxGrower.name+".grow.move")*0.10 }
            ShaderParam { paramName: "g_branchMovePerLevel"; paramValue: sync(boxGrower.name+".grow.movePerLevel")*0.10 }
            ShaderParam { paramName: "g_branchMoveOfs"; paramValue: sync(boxGrower.name+".grow.moveOfs")*0.10 }
            ShaderParam { paramName: "g_branchMoveOfsPerLevel"; paramValue: sync(boxGrower.name+".grow.moveOfsPerLevel")*0.10 }
            ShaderParam { paramName: "g_branchScalePerLevel"; paramValue: sync(boxGrower.name+".grow.scalePerLevel") }
        }

        drawShader: "branchDraw";
        drawParams: ParamGroup {
            Pos { x: 0.0; y: 0.0; z: 0.0 }
            Rot { d: 0; ax: 1.0; ay: 0.0; az: 0.0 }
            Sca { s: 1.0; x: 1.0; y: 1.0; z: 1.0 }
            ShaderParam { paramName: "g_bump"; paramValue: 0.50}
            ShaderParam { paramName: "g_texBrightness"; paramValue: 0.0010 }
            ShaderParam { paramName: "g_texAmbient"; paramValue: 0.0 }
            ShaderParam { paramName: "g_uvScale"; paramValue: 0.1 }
            ShaderParam { paramName: "g_color"; paramValueVec4: "1.0, 1.0, 1.0, 1.0" }
            ShaderParam { paramName: "g_prevBlurAmount"; paramValue: 0.1*sync("prevBlurAmount") }
            ShaderParam { paramName: "g_bright"; paramValue: 1.0}
            ShaderParam { paramName: "g_palSwipeFreq"; paramValue: sync(boxGrower.name+".swipe.freq") }
            ShaderParam { paramName: "g_palSwipeOfs"; paramValue: sync(boxGrower.name+".swipe.ofs")+boxGrowerSwipeTime.time }
            ShaderParam { paramName: "g_palSwipeZero"; paramValue: sync(boxGrower.name+".swipe.zeroColor")}
            ShaderParam { paramName: "g_palSwipeIntensity"; paramValue: sync(boxGrower.name+".swipe.colIntensity")}
            ShaderParam { paramName: "g_palSwipeColorPow"; paramValue: sync(boxGrower.name+".swipe.colPow")}
            ShaderParam { paramName: "g_palSwipeFadeFreq"; paramValue: sync(boxGrower.name+".swipe.fadeFreq")}
            ShaderParam { paramName: "g_palSwipeFadeOfs"; paramValue: sync(boxGrower.name+".swipe.fadeOfs")+boxGrowerSwipeFadeTime.time}
            ShaderParam { paramName: "g_palSwipeFadePerc"; paramValue: sync(boxGrower.name+".swipe.fadeCutoff")}
            ShaderParam { paramName: "g_palSwipeTimeOfs"; paramValue: boxSwipeFadeTrigger.time }
        }

        TextureImage {
          textureUnit: 0;
          file: "../../images/aalto.png"
        }
        drawMesh: DrawMesh {
            // draw one bigger mesh
            file: drawTrans.file; Pos { x: drawTrans.er*Math.sin(drawTrans.ki)+drawTrans.pr*Math.cos(drawTrans.kii*2.3); y: Math.abs(0.0*(Math.sin(drawTrans.ki*0.9+Math.cos(drawTrans.kii*1.5)))); z: drawTrans.er*Math.cos(drawTrans.ki)+drawTrans.pr*Math.sin(drawTrans.kii*3.43)}
            Rot { d: demoTime()*0.0; ax: 1.0; ay: 1.0; az: 0.0 }
            Sca { s: 0.25; x: 1.0; y: 1.0; z: 1.0 }
            //Pos { y: 0.50 }
            ShaderParam { paramName: "g_emit"; paramValue: 1.0}
            ShaderParam { paramName: "g_bright"; paramValue: drawTrans.drawIndex%2 < 1 ? 1.01 : 1.0 }
            ShaderParam { paramName: "g_uvScale"; paramValue: 2.0}
            blendMode: "off"; depthTest: true; depthWrite: true; triggeredRender: true
          }
      }
  }
  Blit { textureRT: "depth"; blitRT: 1}
  PrevBlur { }
  // postprocs
  Tonemap { }
  Reflect { }
  WaterPartikles {
    id: wp; name: "waterPart"; drawEnabled: enabled; enabled: sync(wp.name+".ON"); emitShader: "smEmitter";
    emitMesh: DrawMesh {
        file: "mesh/kolkkus.x"; depthTest: true; depthWrite: true; blendMode: "off";
        // Shader params for particle emitting
        ShaderParam { paramName: "g_emitPercent"; paramValue: sync("waterPart.g_emitPercent")}
        // Shader params for mesh surface
        ShaderParam { paramName: "g_uvScale"; paramValue: 0.20 }
        ShaderParam { paramName: "g_texBrightness"; paramValue: 0.0 }
        ShaderParam { paramName: "g_prevAmount"; paramValue: 0.0 }
        ShaderParam { paramName: "g_prevBlurAmount"; paramValue: 0.0 }
        Pos { x: 2.0; y: 6.0; z: 0.50}
        Rot { d: 0.0; ax: 1.0; ay: 0.0; az: 0.0 }
        Sca { s: sync("waterPart.g_emitterSize"); x: 1.0; y: 1.0; z: 1.0 }
      }
  }
  Glow { }
  Blit { textureRT: "prev" }
  Vignette { }
  Coords { }
}
