import QtQuick 2.3
import "../" // to import RocketScene
import "../_SharedQML"
import AdaptDemoSystem 1.0


RocketScene { 
  //SKENE ginkku
  VariClock { id: zoomClock; clockSpeed: 0.333*sync("zoomPercent")}
  FlyCamera { }
  //setup default textures
  TextureImage { 
    textureUnit: 0; file: "../../images/scratch1.png"; 
    //file: "../../images/meteor_b.png"
    //file: "../../images/aalto.png"
    //file: "../../images/kivitex1s.png"
    //file: "../../images/PinkMedusa_black.png"
    //file: "../../images/siniku4.png"
    //file: "../../images/meteor.png"
    //file: "../../images/gas1.png"
  }
  TextureImage { textureUnit: 1; file: "../../images/_SK57414_normal.png"}
  TextureImage { textureUnit: 2; file: "../../images/area_lights.jpg"}
  Texture { textureUnit: 3; textureRT: "prev" }
  Texture { textureUnit: 4; textureRT: "prevBlur" }
  Texture { textureUnit: 5; textureRT: "prevNormal" }
  Group { 
    // big mirror plane
    Shader { file: "smInfi" }
    DrawMesh { 
      file: "mesh/box1m.lwo"; enabled: true; smoothNormals: true; normalSmoothAngle: 20; blendMode: "off"; depthTest: true; depthWrite: true; cull: true; cullBack: true; Pos { x: 0.0; y: -0.950; z: 0.0}
      Rot { d: 0; ax: 1.0; ay: 0.0; az: 0.0 }
      Sca { s: 10.0; x: 100.0; y: 1.0; z: 100.0 }
      ShaderParam { paramName: "g_uvScale"; paramValue: 1.0}
      ShaderParam { paramName: "g_texBrightness"; paramValue: 0.03 }
      ShaderParam { paramName: "g_texAmbient"; paramValue: 0.005 }
      ShaderParam { paramName: "g_bump"; paramValue: 0.150}
      ShaderParam { paramName: "g_prevAmount"; paramValue: 0.0 }
      ShaderParam { paramName: "g_prevBlurAmount"; paramValue: sync("prevBlurAmount") }
      ShaderParam { paramName: "g_color"; paramValueVec4: "1.0, 1.0, 1.10, 1.0" }
      ShaderParam { paramName: "g_bright"; paramValue: 1.0}
      ShaderParam { paramName: "g_zoomTime"; paramValue: zoomClock.time }
    }
  }
  // mirror ball
  Shader { file: "smPlastic" }
  DrawMesh { 
    file: "mesh/ball5000.x"; 
    // "mesh/puppet_jump.dae","mesh/Cave.dae","mesh/aivob.x","mesh/400x400.obj"
    enabled: false; smoothNormals: true; normalSmoothAngle: 20; blendMode: "off"; depthTest: true; depthWrite: true; 
    //  cull: true; cullBack: true
    Pos { x: 0.0; y: 0.0; z: 0.0}
    Rot { d: -90; ax: 1.0; ay: 0.0; az: 0.0 }
    Sca { s: 7.0; x: 1.0; y: 1.0; z: 1.0 }
    ShaderParam { paramName: "g_uvScale"; paramValue: 0.0}
    ShaderParam { paramName: "g_bump"; paramValue: 0.0}
    ShaderParam { paramName: "g_texBrightness"; paramValue: 0.5 }
    ShaderParam { paramName: "g_texAmbient"; paramValue: 0.00 }
    ShaderParam { paramName: "g_prevAmount"; paramValue: 0.0 }
    ShaderParam { paramName: "g_prevBlurAmount"; paramValue: sync("prevBlurAmount") }
    ShaderParam { paramName: "g_color"; paramValueVec4: "1.0, 1.0, 1.0, 1.0" }
    ShaderParam { paramName: "g_bright"; paramValue: 1.0}
  }
  //zoomer emit, advance & draw
  DrawTrans { 
    id: drawTrans; name: "trans"; 
    // transShader contains both emit & advance code
    transShader: "zoomTrans"; drawShader: "zoomDraw"; zoomPercent: sync("zoomPercent"); 
    drawMesh: DrawMesh { 
        // draw one bigger mesh
        file: (drawTrans.drawIndex%10 < 9) ? "mesh/box1m.lwo" : "mesh/ball5000.x"; 
        //file: (drawIndex%10 < 9) ? "mesh/ball5000.x" : "mesh/ball5000.x"
        //file: (drawIndex%10 < 9) ? "mesh/dode.lwo" : "mesh/dode.lwo"
        //file: "mesh/dode.lwo"
        //file: "mesh/toroid.lwo"
        //file: "mesh/rinkula.obj"
        //file: "mesh/ball5000.x"
        Pos { x: drawTrans.er*Math.sin(drawTrans.ki)+drawTrans.pr*Math.cos(drawTrans.kii*2.3); y: Math.abs(0.0*(Math.sin(drawTrans.ki*0.9+Math.cos(drawTrans.kii*1.5)))); z: drawTrans.er*Math.cos(drawTrans.ki)+drawTrans.pr*Math.sin(drawTrans.kii*3.43)}
        Rot { d: time()*0.0; ax: 1.0; ay: 1.0; az: 0.0 }
        Sca { s: drawTrans.drawIndex%20 < 19 ? 0.06 : 0.10; x: 1.0; y: 1.0; z: 1.0 }
        Pos { y: 0.50 }
        ShaderParam { paramName: "g_emit"; paramValue: 1.0}
        // high bright is teh light!
        ShaderParam { paramName: "g_bright"; paramValue: drawTrans.drawIndex%20 < 19 ? 1.01 : 500.0 }
        ShaderParam { paramName: "g_uvScale"; paramValue: 2.0}
        blendMode: "off"; depthTest: true; depthWrite: true; triggeredRender: true; 
        onRendered: {  
                childMeshi.triggerRenderOnce();
            }
        // draw one smaller mesh also
        DrawMesh { 
          id: childMeshi; file: (drawTrans.drawIndex%10 < 9) ? "mesh/box1m.lwo" : "mesh/ball5000.x"; 
          // file: "mesh/dode.lwo"
          // file: "mesh/toroid.lwo"
          // file: "mesh/rinkula.obj"
          Pos { x: drawTrans.er*Math.sin(drawTrans.ki)+drawTrans.pr*Math.cos(drawTrans.kii*2.3); y: 0.05+Math.abs(0.0*(Math.sin(drawTrans.ki*0.9+Math.cos(drawTrans.ki*1.5)))); z: drawTrans.er*Math.cos(drawTrans.ki)+drawTrans.pr*Math.sin(drawTrans.kii*3.43)}
          Rot { d: time()*0.0; ax: 1.0; ay: 1.0; az: 0.0 }
          Sca { s: 0.020; x: 1.0; y: 1.0; z: 1.0 }
          Pos { y: 1.0 }
          ShaderParam { paramName: "g_emit"; paramValue: 1.0}
          ShaderParam { paramName: "g_uvScale"; paramValue: 2.0}
          ShaderParam { paramName: "g_bright"; paramValue: 2.0}
          blendMode: "off"; depthTest: true; depthWrite: true; triggeredRender: true
        }
      }
  }
  PrevBlur { }
  // postprocs
  Tonemap { }
  Reflect { }
  Glow { }
  Blit { textureRT: "prev" }
  Vignette { }
  Coords { }
}
