import QtQuick 2.3
import "../" // to import RocketScene
import "../_SharedQML"
import AdaptDemoSystem 1.0

RocketScene { 
    FlyCamera { }

    Group {
        //setup default textures
        TextureImage { textureUnit: 1; file: "../../images/_SK57414_normal.png"}
        TextureImage { textureUnit: 2; file: "../../images/area_lights.jpg"}
        Texture { textureUnit: 3; textureRT: "prev" }
        Texture { textureUnit: 4; textureRT: "prevBlur" }
        Texture { textureUnit: 5; textureRT: "prevNormal" }
    }
    Group {
        // big mirror plane
        Shader { file: "smInfi" }
        TextureImage { textureUnit: 0; file: "../../images/_SK57414.png"}
        DrawMesh {
            file: "mesh/box1m.lwo"; enabled: false; smoothNormals: true; normalSmoothAngle: 20; blendMode: "off"; depthTest: true; depthWrite: true; cull: false; cullBack: false;
            Pos { x: 0.0; y: -0.950; z: 0.0}
            Rot { d: 0; ax: 1.0; ay: 0.0; az: 0.0 }
            Sca { s: 10.0; x: 100.0; y: 1.0; z: 100.0 }
            ShaderParam { paramName: "g_uvScale"; paramValue: 1.0}
            ShaderParam { paramName: "g_texBrightness"; paramValue: 1.0}
            ShaderParam { paramName: "g_texAmbient"; paramValue: 0.0}
            ShaderParam { paramName: "g_bump"; paramValue: 0.20}
            ShaderParam { paramName: "g_prevAmount"; paramValue: 0.0 }
            ShaderParam { paramName: "g_prevBlurAmount"; paramValue: sync("prevBlurAmount")}
            ShaderParam { paramName: "g_color"; paramValueVec4: "1.0, 1.0, 1.10, 1.0"}
            ShaderParam { paramName: "g_bright"; paramValue: 1.0}
            ShaderParam { paramName: "g_zoomTime"; paramValue: 0.0 }
        }
    }

    Group {
        id: surferNets
        enabled: true
        // Surfer nets v0 (surface nets variation with deepr touch)

        // The dimension of the 3D surface grid as square root of the actual, all three dimension are the same.
        property int surfGridDim3DSqrt: 10
        // Do not change this value directly, should be power of two of the selected dimension square root,
        property int surfGridDim3D: surfGridDim3DSqrt*surfGridDim3DSqrt
        // The final size of the rectangular surface grid 2D texture is (surfGridDim3DSqrt*surfGridDim3D) x (surfGridDim3DSqrt*surfGridDim3D)
        property int surfGridRes2D: surfGridDim3DSqrt*surfGridDim3D

        // 1. Generate the potential field to 3D grid points, now a simple plasma or a set of couple of blobby balls
        RenderTarget {
            RenderTargetLayer {
                textureRT: "surfPotentials"
                // "RGBA32F"
                format: "RGBA32F"
                width: surferNets.surfGridRes2D
                height: surferNets.surfGridRes2D
                Clear {
                    cR: 0.0; cG: 0.0; cB: 0.0; cA: 1.0;
                }
            }
            Texture {
                textureUnit: 0
                textureRT: "mainDepth"
            }
            Shader {
                file: sceneDir+"surfPot"
            }
            DrawVB {
                type: "quad"; depthTest: false; depthWrite: false; blendMode: "off"
                ShaderParam { paramName: "flip"; paramValue: 1.0 }
                ShaderParam { paramName: "surfGridRes2D"; paramValue: surferNets.surfGridRes2D }
                ShaderParam { paramName: "surfGridDim3D"; paramValue: surferNets.surfGridDim3D }
            }
        }

        // 2a. Calculate the grid point normals from the potential field
        RenderTarget {
            RenderTargetLayer {
                textureRT: "surfNormals"
                // "RGBA32F"
                format: "RGBA32F"
                width: surferNets.surfGridRes2D
                height: surferNets.surfGridRes2D
                Clear {
                    cR: 0.0; cG: 0.0; cB: 0.0; cA: 1.0;
                }
            }
            Texture {
                textureUnit: 0
                textureRT: "surfPotentials"
            }
            Shader {
                file: sceneDir+"surfNormals"
            }
            DrawVB {
                type: "quad"; depthTest: false; depthWrite: false; blendMode: "off"
                ShaderParam { paramName: "flip"; paramValue: 1.0 }
                ShaderParam { paramName: "surfGridRes2D"; paramValue: surferNets.surfGridRes2D }
                ShaderParam { paramName: "surfGridDim3D"; paramValue: surferNets.surfGridDim3D }
            }
        }

        // 2. Calculate the cube corner (8 corner) values multiplied and store the result to the center of each grid cube-cell.
        //    Calculate also the x, y & z edge center positions for three top-back corner edges of each grid cube-cell.
        //    These center positions are initialized to -1.0 and marked as values between 0.0 and 1.0 when the sign of the potential
        //    function changes on the edge.
        RenderTarget {
            RenderTargetLayer {
                textureRT: "surfEdges"
                // "RGBA32F"
                format: "RGBA32F"
                width: surferNets.surfGridRes2D
                height: surferNets.surfGridRes2D
                Clear {
                    cR: 0.0; cG: 0.0; cB: 0.0; cA: 1.0;
                }
            }
            Texture {
                textureUnit: 0
                textureRT: "surfPotentials"
            }
            Shader {
                file: sceneDir+"surfEdges"
            }
            DrawVB {
                type: "quad"; depthTest: false; depthWrite: false; blendMode: "off"
                ShaderParam { paramName: "flip"; paramValue: 1.0 }
                ShaderParam { paramName: "surfGridRes2D"; paramValue: surferNets.surfGridRes2D }
                ShaderParam { paramName: "surfGridDim3D"; paramValue: surferNets.surfGridDim3D }
            }
        }

        // 3. Calculate the center average positions of all the intersecting edges in each grid cube
        RenderTarget {
            RenderTargetLayer {
                textureRT: "surfCenters"
                // "RGBA32F"
                format: "RGBA32F"
                width: surferNets.surfGridRes2D
                height: surferNets.surfGridRes2D
                Clear {
                    cR: 0.0; cG: 0.0; cB: 0.0; cA: 1.0;
                }
            }
            Texture {
                textureUnit: 0
                textureRT: "surfEdges"
            }
            Texture {
                textureUnit: 1
                textureRT: "surfPotentials"
            }
            Texture {
                textureUnit: 2
                textureRT: "surfNormals"
            }
            Shader {
                file: sceneDir+"surfCenters"
            }
            DrawVB {
                type: "quad"; depthTest: false; depthWrite: false; blendMode: "off"
                ShaderParam { paramName: "flip"; paramValue: 1.0 }
                ShaderParam { paramName: "surfGridRes2D"; paramValue: surferNets.surfGridRes2D }
                ShaderParam { paramName: "surfGridDim3D"; paramValue: surferNets.surfGridDim3D }
            }
        }


        // 4. Draw the surface by using the informations generated in step 2, source is a VBO with single point primitive for each
        //    grid cell and these points are converted to max 3*2 triangles in geometry shader.
        //    The primitives are generated only to grid cells having negative multiplied corner potentials value.

        Shader {
            file: sceneDir+"surfGeom"
        }
        Texture { textureUnit: 0; textureRT: "surfCenters" }
        Texture { textureUnit: 1; textureRT: "surfPotentials" }
        Texture { textureUnit: 2; textureRT: "surfNormals" }
        DrawVB {
            type: "pointGridDraw"
            name: "surfGeom"
            vboId: sceneName+name
            depthTest: true
            depthWrite: true

            blendMode: "normal"
           // blendMode: drawBlendMode
           // blendMode: "off"

            gridWidth: surferNets.surfGridRes2D
            gridHeight: surferNets.surfGridRes2D
            drawNumPoints: gridWidth*gridHeight

            ShaderParam { paramName: "surfGridRes2D"; paramValue: surferNets.surfGridRes2D }
            ShaderParam { paramName: "surfGridDim3D"; paramValue: surferNets.surfGridDim3D }

            drawBuffers: 2
        }
    }



    Group {
        // mirror ball
        enabled: false
        Shader { file: "smPlastic" }
        TextureImage { textureUnit: 0; file: "../../images/meteor.png"}
        DrawMesh {
            file: "mesh/ball5000.x"; enabled: true; smoothNormals: true; normalSmoothAngle: 20; blendMode: "off"; depthTest: true; depthWrite: true;
            Pos { x: 0.0; y: 4.0; z: 0.0}
            Rot { d: -90; ax: 1.0; ay: 0.0; az: 0.0 }
            Sca { s: 32.0; x: 1.0; y: 1.0; z: 1.0 }
            ShaderParam { paramName: "g_uvScale"; paramValue: 4.0}
            ShaderParam { paramName: "g_bump"; paramValue: 0.50}
            ShaderParam { paramName: "g_texBrightness"; paramValue: 0.1 }
            ShaderParam { paramName: "g_texAmbient"; paramValue: 0.00 }
            ShaderParam { paramName: "g_prevAmount"; paramValue: 0.0 }
            ShaderParam { paramName: "g_prevBlurAmount"; paramValue: sync("prevBlurAmount") }
            ShaderParam { paramName: "g_color"; paramValueVec4: "1.0, 1.0, 1.0, 1.0"}
            ShaderParam { paramName: "g_bright"; paramValue: 1.0}
        }
    }
    Blit { textureRT: "depth"; blitRT: 1}
    PrevBlur { }
    // postprocs
    Tonemap { }
    Reflect { }
    Glow { }
    GodRay { }
    Blit { textureRT: "prev" }
    Vignette { }
    Coords { }
}
