;------------------------------------------------------------------------------;
;----------------------- REMNANTS by gopher/alcatraz --------------------------;
;------------------- a 256 byte intro for Revision 2024 -----------------------;
;------------------------------------------------------------------------------;
; Thanks to Xor (@XorDev) for the great fractal formulation this is based on.  ;
; See: https://www.shadertoy.com/view/cd3GWf                                   ;
;------------------------------------------------------------------------------;
; with the help of Rrrola and Hellmood, this results in another 7 bytes saved. ;
; making room for some very rudimentary PC Speaker "sound" in 256 bytes.       ;
;------------------------------------------------------------------------------;

%define FREEDOS				; comment out for DOSBOX compatible version
;%define PCSPEAKER			; comment in for some "sound"
%define BLUR				; comment out if you want to see the intro without "postprocessing"
%define STEPS 42			; marcher iterations
%define FITER 7				; fractal iterations
org 100h
S:	push    0a000h - 10		; modified to center to 160,100
	pop     es              ; ES -> ScreenPointer
	mov     al,13h
	int     10h          	; mode 13h
	salc
palette: 					; 42 shades of gray
	mov 	dx,0x3c9
	;xchg	ax,bx			; 64 shades of gray with this, 42 without, but changes bx (will be 0xff01 after)
	xchg	ax,cx
	out 	dx,al
	loop	palette
	mov		bx,_Data
pixel:
	mov 	ax,0xCCCD		;Rrrola's trick ...
	mul		di				;... to approximate centered coords from DI in range [0..65535]
	jc		framedone
		inc		cx			; increase framecounter
		test	cl,0x3f		; on each camera switch:
		jnz		framedone
		add 	byte[_anim+bx-_Data],5	; increase fractal rotation
		add		byte[_iy+bx-_Data],45	; increase (wrap) camera y
framedone:
%ifdef PCSPEAKER
	out 61h,al
	mov ax,cx
	xlat
	out 42h,al
%endif			
	sub 	dh,76			;align vertically but look down as much as possible for speed
	pusha
	lea		bp,[bx+si]		;[bx+si]=pos [bp+si]=dir
	mov		di,-4			;vec storage offset (+pre-popa storage of color)
; raydir bp+(104 108 10C) ; raypos bx+(104 108 10C)
; dy
	fild 	word [di-4]			;dy
	fmul	dword[bx+di]	;_RayNorm
; py
	fild	word [_iy+bx-_Data]	;py		dy
	imul	ax,cx,4			;Rrrola's optimization
	sahf					;Rrrola's optimization
	jnp		noyofs			;Rrrola's optimization
	fiadd	word [si+5]		; dive down into the fractal (ceiling)
noyofs:
; dz
	fldln2						;dz		py		dy
	fst		st3				;Rrrola's optimization
	fild	word [di-2]			;t		dz		py		dy		*dt
	jnc		noyofs2			;Rrrola's optimization
	fadd	st2,st0				;t		dz		py'		dy		*dt
noyofs2:	
; pz	
	fadd	st0,st0				;2t		dz		py		dy		*dt
	fiadd	word [_iz+bx-_Data]	;pz		dz		py		dy		*dt
; dx
	fild 	word [di-5]			;dx		pz		dz		py		dy		*dt
	fmul	dword[bx+di]	;_RayNorm	
 	jnc		nodchange
	fxch	st2
	fchs					; look right
nodchange:
; px	
	fild	word [_ix+bx-_Data];px		dx		pz		dz		py		dy		*dt
; store pos and dir
	push	si
storeray:					;si=100
	sub 	si,di			;si=104 108 10C
	fstp	dword[bx+si]	;pos
	fstp	dword[bp+si]	;dir
	jpo 	storeray
	pop		si				;si=100	
; marcher iterations
	mov		cx,STEPS-1
marcher_loop:					;*dt
;// v=p+=d*dt;
	pusha
np:							;si=100
	sub 	si,di			;si=104 108 10C
	fld		dword[bp+si]		;dx		*dt	;dy		*dt	;dz		*dt
	fmul	st1					;dx*dt	*dt	;dy*dt	*dt	;dz*dt	*dt
	fadd	dword[bx+si]		;x' 	*dt	;y'		*dt	;z'		*dt
	fst		dword[bx+si+12]		;x' 	*dt	;y'		*dt	;z'		*dt
	fstp	dword[bx+si]		;*dt		;*dt		;*dt
	jpo		np
;// dt=p.y;
	fld		dword[bx+si]		;dt
	fild	word[bx+di]			;i		dt
;// for(int iter=0;iter<FITER;iter++) {
	mov		cl,FITER
	sub 	si,di			;si=110
fractal_loop:					;i		dt
; rotate xz by some small angle (approximate rotation, for small angle cos(a) ~ 1, sin(a) ~ a)
	fld		dword[bx+si+4]		;y		i		dt
	fmul	dword[_p2+bx-_Data] ;ay		i		dt
	fadd	dword[bx+si]		;1x+ay	i		dt
	fld		dword[bx+si]		;x 		1x+ay	i		dt
	fmul	dword[_p2+bx-_Data] ;ax 	1x+ay	i		dt
	fsubr	dword[bx+si+4]		;1y-ax	1x+ay	i		dt
 	fstp	dword[bx+si+4]		;1x+ay	i		dt
	fstp	dword[bx+si]		;i		dt
;// v=(i+i)*PSCALE-abs(mod(v+i,i+i));
;// dt=max(dt,min(min(v.x,v.y),v.z));
	fld		st0					;minv	i		dt
	push	si
nv:							;si=110
	fld		st1					;i		minv	i		dt
	fadd	st0					;i+i	minv	i		dt
	fld		dword[bx+si]		;vxyz	i+i		minv	i		dt
	fadd	st3					;vxyz+i	i+i		minv	i		dt
	fprem1						;mxyz	i+i		minv	i		dt
	fabs						;|mxyz|	i+i		minv	i		dt
	fld		dword[_PSCALE+bx-_Data];PS	|mxyz|	i+i		minv	i		dt
	fmulp	st2					;|mxyz|	i'		minv	i		dt
	fsubp	st1,st0				;vxyz	minv	i		dt
	fst		dword[bx+si]		;vxyz	minv	i		dt
min:
%ifndef FREEDOS
	fcom 	st1
	fnstsw 	ax
	sahf
	jbe 	_minsmaller
	fxch 	st1
_minsmaller:
	fstp 	st1					;minv	i		dt
%else
	fcomi 	st0,st1
	fcmovnbe	st0,st1
	fstp	st1					;minv	i		dt
%endif
	sub 	si,di			;si=114 118 11C
%ifdef FREEDOS	
_ix equ $
%endif
	jpe		nv					;minv	i		dt
	pop		si				;si=110
max:
%ifndef FREEDOS
	fcom 	st2
	fnstsw 	ax
	sahf
	jbe 	_maxsmaller
	fxch 	st2
_maxsmaller:
	fstp 	st0					;i		maxdt
%else
	fcomi 	st0,st2
	fcmovb	st0,st2
	fstp	st2					;i		maxdt
%endif
	fmul	dword[_FSCALE+bx-_Data];i'	dt
	loop	fractal_loop
	popa
	fstp	st0					;dt	
;// if (dt<eps) break;
	fcom	dword[_PSCALE+bx-_Data];dt
	fstp	st1					;*dt
	fnstsw 	ax
	sahf
	jbe		marcher_done
%ifndef FREEDOS
	dec		cx
	jnz		marcher_loop
%else
 	loop	marcher_loop
%endif	
marcher_done:
	mov		word [di],cx		;ax = cx = iterationcount (di=-4)
	popa
%ifdef BLUR
	add		al,[es:di-1]	; blur with previous pixel a bit left (smoothes panning movement, makes distant geo more blurry)
	shr		ax,1
%endif	
	stosb
	add		di,40
	cmp		cx,0x0180
	jne		pixel
_RayNorm:					; using ret byte for constants lower bits	
iFSTART:
	ret
;==============================================================================
; constants
;==============================================================================
			db	0x0c
_p2:		dw	0xB800			; 0xB800xxxx ~ -1.0 / 65536.0
_FSCALE:
_Data:		dw	0x3e4c			; 0x3e4cxxxx ~ 0.2  -> _p2
_PSCALE:	dw	0x3ed5			; 0x3ed5xxxx ~ 0.42 -> _FSCALE
_anim equ $-2
			dw	0x3eca			; 0x3ecaxxxx ~ 0.395-> _PSCALE
%ifndef FREEDOS			
_ix:		dw	-7814
%endif
_iz:		dw	-15863
_iy:		dw	-201