;=====================================================================
                PUBLIC  SetPalette_
                PUBLIC  SetBack_
                PUBLIC  CopyScreen_
                PUBLIC  SetMode_
                PUBLIC  WaitTOF_

                PUBLIC  EnableTimerInt_
                PUBLIC  DisableTimerInt_
                PUBLIC  GetVBLSpeed_
                PUBLIC  GetTimerAsm_

                PUBLIC  EnableKbdInt_
                PUBLIC  DisableKbdInt_
                PUBLIC  GetScanCode_

                PUBLIC  EnableMouse_
                PUBLIC  DisableMouse_
                PUBLIC  GetMouseMove_
                PUBLIC  GetMouseButton_

;                PUBLIC  Int0Server_
;                EXTERN  Int0Handler_ : BYTE
;                EXTERN  __GETDS : BYTE

;=====================================================================

KEYBUFSIZE      equ     16

_DATA           SEGMENT PARA PUBLIC USE32 "DATA"

timerint_o:     dd      ?       ; old vector
timerint_s:     dw      ?
timercount:     dd      0
timerspeed:     dd      ?       ; timerticks per vbl

KbdBuffer:      db      (KEYBUFSIZE) dup (?)    ; Ringbuffer for Keyboard.
KbdBufRead:     dd      1                       ; Writepointer in Ring.
KbdBufWrite:    dd      1                       ; Readpointer in Ring.
oldint_o:       dd      ?
oldint_s:       dw      ?

dump            db      64 dup (0)

_DATA           ENDS

;=====================================================================

_TEXT           SEGMENT PARA PUBLIC USE32 "CODE"

;=====================================================================

                ASSUME  cs:_TEXT,ds:_DATA,es:_DATA

;=====================================================================
;=====================================================================

;Int0Server_:
;                mov     word ptr 18[esp],0
;                mov     16[esp],SEG Int0Handler_
;               retd

;=====================================================================

; ebx,ecx,esi -> Color


SetPalette_:    push    eax
                push    ebx
                push    ecx
                push    edx
                mov     edx,03c8h

SetPaletteLoop: mov     al,bl
                out     dx,al
                inc     edx

                mov     al,0[esi]
                shr     al,2
                out     dx,al

                mov     al,1[esi]
                shr     al,2
                out     dx,al

                mov     al,2[esi]
                shr     al,2
                out     dx,al

                dec     edx

                inc     bl
                add     esi,4
                dec     ecx
                jnz     SetPaletteLoop

                pop     edx
                pop     ecx
                pop     ebx
                pop     eax
                ret

;=====================================================================

SetBack_:       push    eax
                push    ebx
                push    ecx
                push    edx

                mov     dx,03c8h
                mov     al,0
                out     dx,al
                inc     dx

                mov     eax,ebx
                rol     eax,16
                shr     al,2
                out     dx,al
                rol     eax,8
                shr     al,2
                out     dx,al
                rol     eax,8
                shr     al,2
                out     dx,al

                pop     edx
                pop     ecx
                pop     ebx
                pop     eax
                ret

;=====================================================================

CopyScreen_:    push    edi
                push    esi
                push    ecx

                shr     ecx,2
                rep     movsd

                pop     ecx
                pop     esi
                pop     edi
                ret

;=====================================================================

SetMode_:       pushad
                int     10h
                popad
                ret

;=====================================================================

WaitTOF_:       push    edx
                push    eax

                cli
                mov     dx,3dah
WaitTOF2:       in      al,dx
                test    al,08h
                jz      WaitTOF2
                sti

                pop     eax
                pop     edx
                ret

;=====================================================================
;=====================================================================
;=====================================================================

TimerInt_:      push    ds                      ; save registers
                push    eax
                push    ebx
                push    edi

                mov     ax,_DATA                ; set segment registers
                mov     ds,ax

;                mov     edi,0b8000h
;                add     byte ptr [edi],1

                inc     timercount

                mov     al,20h
                out     20h,al

;                pushf
;                call far FWORD PTR [timerint_o]

                pop     edi
                pop     ebx                     ; restore registers
                pop     eax
                pop     ds
                iretd

GetVBLSpeed_:   push    edx
                push    ebx
                mov     eax,timerspeed
                mov     ebx,3599594107
                mul     ebx                     ; result in microseconds
                mov     eax,edx
                pop     ebx
                pop     edx
                ret

GetTimerAsm_:   pushad
                mov     edi,eax                 ; edi = destination
                mov     al,04h                  ; al = latch timer command


                mov     ecx,timercount          ; read overflow count 1

                cli
                out     43h,al                  ; read timer value
                in      al,40h
                mov     bl,al
                in      al,40h
                sti

                mov     edx,timercount          ; read overflow count 2


                mov     bh,al                   ; store values
                shl     ebx,16
                neg     ebx
                mov     [edi],ecx
                mov     4[edi],edx
                mov     8[edi],ebx

                popad
                ret

EnableTimerInt_:
                pushad                          ; save registers
                push    ds
                push    es


                pushad                          ; multitasking
                mov     ax,1680h
                int     2fh
                popad

                cli                             ; disable interrupts

;                mov     dx,3dah                 ; wait for vbl trigger
;EnableTimer1:   in      al,dx
;                test    al,08h
;                jz      EnableTimer1
;EnableTimer2:   in      al,dx
;                test    al,08h
;                jnz     EnableTimer2

;                mov     al,34h
;                out     43h,al                  ; start timer (one shot)
;                xor     al,al
;                out     40h,al
;                out     40h,al

;EnableTimer3:   in      al,dx                   ; wait again
;                test    al,08h
;                jz      EnableTimer3
;EnableTimer4:   in      al,dx
;                test    al,08h
;                jnz     EnableTimer4

;                mov     al,04h
;                out     43h,al                  ; read timer value
;                mov     ebx,-1
;                in      al,40h
;                mov     bl,al
;                in      al,40h
;                mov     bh,al
;                neg     ebx
;                cmp     ebx,11932               ; minimum 11932 (ca 100 hz)
;                jnc     EnableTImer5
;                mov     ebx,11932
;EnableTimer5:   mov     timerspeed,ebx

;                mov     edi,0b8000h
;                mov     byte ptr[edi],0

                mov     eax,03508h              ; save old vector
                int     21h
                mov     timerint_o,ebx
                mov     timerint_s,es

                mov     eax,02508h              ; set new vector
                mov     dx,SEG TimerInt_
                mov     ds,dx
                mov     edx,OFFSET TimerInt_
                int     21h

                mov     al,34h
                out     43h,al
                mov     eax,0                   ; set new timervalue
                out     40h,al
                mov     al,ah
                out     40h,al

                sti                             ; enable interrupts

                pop     es                      ; restore registers
                pop     ds
                popad
                ret

DisableTimerInt_:
                pushad                          ; save registers
                push    ds

                mov     al,34h
                out     43h,al                  ; set old timervalue
                xor     al,al
                out     40h,al
                out     40h,al

                mov     eax,02508h              ; restore old vectore
                mov     edx,timerint_o
                mov     ds,timerint_s
                int     21h

                pop     ds                      ; restore registers
                popad
                ret

;=====================================================================
;=====================================================================
;=====================================================================

KbdInt_:        push    ds                      ; save registers
                push    eax
                push    ebx
                push    edi

                mov     ax,_DATA                ; set segment registers
                mov     ds,ax

                mov     ebx,KbdBufWrite         ; get dest adress
                mov     edi,OFFSET KbdBuffer

                sti                             ; get key
                in      al,60h
                mov     [ebx+edi],al
                in      al,61h
                or      al,82h
                out     61h,al
                and     al,7fh
                out     61h,al
                mov     al,20h
                out     20h,al

                add     ebx,1                   ; increment dest adres
                and     ebx,KEYBUFSIZE-1
                mov     KbdBufWrite,ebx         ; store dest adress

                pop     edi
                pop     ebx                     ; restore registers
                pop     eax
                pop     ds
                iretd

;=====================================================================

GetScanCode_:   push    ebx
                push    edi

                mov     ebx,KbdBufRead          ; get dest adress
                mov     eax,KbdBufWrite
                cmp     eax,ebx
                jz      GetScanCode1

                xor     eax,eax                 ; get scancode
                mov     edi,OFFSET KbdBuffer
                mov     al,[ebx+edi]

                add     ebx,1                   ; increment dest adres
                and     ebx,KEYBUFSIZE-1
                mov     KbdBufRead,ebx          ; store dest adress

                pop     edi
                pop     ebx
                ret

GetScanCode1:   xor     eax,eax
                pop     edi
                pop     ebx
                ret

;=====================================================================

EnableKbdInt_:  pushad                          ; save registers
                push    ds
                push    es

                xor     eax,eax                 ; initialise buffer
                mov     KbdBufRead,eax
                mov     KbdBufWrite,eax

                mov     eax,03509h              ; save old vector
                int     21h
                mov     oldint_o,ebx
                mov     oldint_s,es

                mov     eax,02509h              ; set new vector
                mov     dx,SEG KbdInt_
                mov     ds,dx
                mov     edx,OFFSET KbdInt_
                int     21h

                pop     es                      ; restore registers
                pop     ds
                popad
                ret

;=====================================================================

DisableKbdInt_: pushad                          ; save registers
                push    ds

                mov     eax,02509h              ; restore old vectore
                mov     edx,oldint_o
                mov     ds,oldint_s
                int     21h

                pop     ds                      ; restore registers
                popad
                ret

;=====================================================================
;=====================================================================

EnableMouse_:   mov     ax,0
                int     33h
                ret

DisableMouse_:  ret

GetMouseButton_: push    ebx
                push    ecx
                push    edx
                mov     ax,3
                int     33h
                xor     eax,eax
                mov     ax,bx
                pop     edx
                pop     ecx
                pop     ebx
                ret

GetMouseMove_:  pushad
                mov     eax,0bh
                int     33h
                mov     eax,ecx
                cwde
                mov     [edi],eax
                mov     eax,edx
                cwde
                mov     [esi],eax
                popad
                ret

;=====================================================================
;=====================================================================

_TEXT           ends
                end

;=====================================================================
