/*

    m_main.c

*/


#include <stdio.h>
#include <stdlib.h>

#include "m_main.h"
#include "l_main.h"
#include "g_main.h"
#include "i_main.h"
#include "s_main.h"

extern int systemtime;

cbitmap *m_allocbitmap (int x, int y, int bpp)
{
  cbitmap *b=(cbitmap *)m_alloc (sizeof(cbitmap));

  b->x=x;
  b->y=y;
  b->bpp=bpp;
  b->pal=0;

  if (bpp==18)
    b->data=m_alloc (x*y*4);
    else
    {
      b->data=m_alloc (x*y);
      b->pal=    (long *)m_alloc (1024);
      b->origpal=(long *)m_alloc (1024);
    }

  return b;
}

void    m_freebitmap (cbitmap *b)
{
 if (b->bpp!=18) {
  if (b->pal) m_free ((char *)b->pal);
  if (b->origpal) m_free ((char *)b->origpal);
      }
  if (b->data) m_free (b->data);
}

void    m_init(void) {

    }

void    m_shutdown(void) {

    }

char*   m_alloc(int size) {
char*   mem;

    if (!(mem=(char*)malloc(size))) m_fatalerror("Memory allocation error");

    return mem;


    }

void    m_free(char *mem) {
    free(mem);
    }


void    m_fatalerror(char *text) {

    s_shutdown();
    i_shutdown();
    g_shutdown();
    l_shutdown();
    m_shutdown();
    printf("Fatal Error: %s at :%f\n",text,((float)systemtime)/1000000);
    exit(0);
    }

void    m_print(char *text) {

    printf("%s",text);

    }
cFile *m_loadfile(char *nam) {
char *err="File not found:01234567.012                  ";
FILE *datei;
int len;
char *mem;
cFile *myfile;

    datei=fopen(nam,"rb");

    if (!datei) {
      sprintf(err,"File not found:%s", nam);        // HIER FHLA
      m_fatalerror (err);
      }

    fseek(datei,0,SEEK_END);
    myfile=(cFile*)m_alloc(sizeof(cFile));

    len=ftell(datei);
    fseek(datei,0,SEEK_SET);

    mem=(char*)m_alloc(len);

    fread(mem,1,len,datei);

    myfile->data=mem;
    myfile->len=len;

    fclose(datei);

    return myfile;
    }

void    m_freefile(cFile *in) {

    m_free(in->data);
    m_free((char*)in);

    }



cbitmap  *m_loadbitmap (char *n)
{
  unsigned char a,b;
  unsigned short xmax;
  unsigned short ymax;
  int pcx_size;
  char *pic;
  int zaehler;

  char *err="File not found:01234567.012                     ";

  cbitmap *e=(cbitmap *)m_alloc (sizeof(cbitmap));

  FILE *pcxbild;

  if (!(pcxbild = fopen(n, "rb")))
    {
      sprintf(err,"File not found:%s", n);        // HIER FHLA
      m_fatalerror (err);

    }

  fseek(pcxbild, 8, SEEK_SET);

  fread(&(a),1,sizeof(a),pcxbild);
  fread(&(b),1,sizeof(b),pcxbild);

  xmax=(b<<8)+a;

  fread(&(a),1,sizeof(a),pcxbild);
  fread(&(b),1,sizeof(b),pcxbild);

  ymax=(b<<8)+a;

  e->x=(xmax+1);
  e->y=(ymax+1);

  pcx_size = (xmax + 1)*(ymax + 1);

  pic=m_alloc (pcx_size);

  e->data=pic;

  fseek(pcxbild, 128, SEEK_SET);
  zaehler=0;

  while (zaehler < pcx_size)
    {
      char w1 = getc(pcxbild);
      if ((w1 & 0xc0) == 0xc0)
        {
          char w2 = getc(pcxbild);
          int i;
          w1 &= 0x3f;
          for (i = 0; i < w1; i++)
            pic [zaehler + i] = w2;
          zaehler += w1;
        }
      else
        {
          pic [zaehler++] = w1;
        }
    }

    getc(pcxbild);

    e->pal=    (long *) m_alloc (1024);
    e->origpal=(long *) m_alloc (1024);
    for (zaehler=0;zaehler<256;zaehler++)
    {
      ((unsigned char *)e->pal)[zaehler*4+0]=0;
      ((unsigned char *)e->pal)[zaehler*4+1]=(((char)getc(pcxbild))>>2)&0x3f;
      ((unsigned char *)e->pal)[zaehler*4+2]=(((char)getc(pcxbild))>>2)&0x3f;
      ((unsigned char *)e->pal)[zaehler*4+3]=(((char)getc(pcxbild))>>2)&0x3f;

      e->origpal[zaehler]=e->pal[zaehler];
    }

  fclose(pcxbild);

  e->bpp=8;

  return e;
}

