

.model large
.286
codigo segment para public 'codigo'
;org 100h
;cxfu      equ     0155
stack 100h


assume cs:codigo

stART:
;jmp _comienzo
jmp rt
;comment +

;How to use the VIBRANTS play-driver
;-----------------------------------

;These cool drivers are ... cool!  The song included here is a TINY 3.1k, but
;it sounds as good as most MODs.  And it only requires an AdLib!  And takes up
;much less time to play!  Wow.
;
;Anyway, JCH said he'd release a doc explaining how to use them.  Well, so far
;... I haven't seen anything.  So, hacking into the drivers (and looking at the
;KUKOO source code, :), I figured out how to use them.
;
;One thing you should know:  The soundblaster driver (SBL-0103.P01) seems to
;require some other initializations (probably the soundblaster port, IRQ, etc),
;and I can't figure out how to do that.  So, the D01 songs don't work!  (The
;digital intstruments are all garbled, yuck).

;Anyway, here's the code!  Assemble it with TASM (MASM shmasm!), and ... have
;fun! Heh.  Oh, don't forget to use forward references!  (/m)
;
;If you want to get the whole Play-Driver package, call The Revelation Station
;at 604-477-5337.  Please note!  That these drivers and songs are 100%
;copyrighted by the authors, VIBRANTS.  DON'T USE THEM IN YOUR PROGRAMS WITHOUT
;PERMISSION!  As this is not a 'program', but rather a 'tutorial', I hope they
;won't get mad.  :)
;
;comment end! +

; *****************************************************************************

;.model  large, c

; *****************************************************************************

PDATA segment para public 'PDATA'

        ; Player and music segment

        include driver.inc                      ; driver include file
        MusicOffset = $-PDATA                   ; Offset for the music
        include song.inc                        ; the music!

PDATA ends

gfx_ segment para public 'gfx_'

include gfx.inc
gfx_ ends




; *****************************************************************************
; Entry point!
; *****************************************************************************

;.code
rt:

		
        push    cs
        pop     ds

        jmp     start1

; *****************************************************************************

MusicDriver     proc

        ; General-purpose Music Driver call

MusicPatch      label
        nop

        call    dword ptr cs:[Player]
        ret

Player  DW      0,0

MusicDriver     endp

; *****************************************************************************

newint1c        proc

        ; New interrupt 1c!
		push    ds
		push    es
		push    di
        push    ax
        push    si
		push    bx
		push    cx
		pushf
        mov     ah, 3                   ; Update music
        call    MusicDriver

        call    cs:dword ptr [oldint1c]
		pop     cx
		pop     bx
		pop     si
		pop     ax
		pop     di
		pop     es
		pop     ds
        iret

        oldint1c        dd      0

newint1c        endp

; *****************************************************************************
; Main code!
; *****************************************************************************

start1:
        mov     ax, PDATA
        mov     Player[2], ax

        mov     ah, 6
        call    MusicDriver

        jnc     InitializedOk           ; card was there, it's ok

        ; Card not there, so patch code to use a RET instead of NOP
        ; This way, no extra coding involved to cancel calls to
        ; the player.  This test program doesn't do anything BUT
        ; play music, so ... :)
        mov     byte ptr cs:[MusicPatch], 0C3h

InitializedOk:
        ; Initialize the music now
        mov     ah, 0                           ; funciton 0, init music
        mov     bx, PDATA                       ; segment of MUSIC
        mov     cx, MusicOffset                 ; offset of MUSIC
        call    MusicDriver

        mov     ah, 2                           ; Not sure what this one does, but it's required
        mov     bx, 0
        call    MusicDriver

        ; Music all initialized ...
        ; Note that si is destroyed in calls to MusicDriver, so if you're using it, you'd
        ; better save and restore it!

        ; *****************************************************************************
        ; Set the CPS of the song ...
        ; *****************************************************************************

        push    ds
        mov     ax, PDATA
        mov     ds, ax

        ; Which version of music file are we using?  If it's version > 01.14, then the
        ; CPS of the song is stored in the 9th byte.  < 01.14, and it's the second byte.
        mov     bx, MusicOffset
        cmp     word ptr [bx], 0434ah   ; "JC"
        jne     _old_vers

        mov     bx, MusicOffset+8
        jmp     _init_loc1

_old_vers:
        mov     bx, MusicOffset+1

_init_loc1:
        ; Get CPS
        mov     al, byte ptr [bx]
        xor     ah, ah
        pop     ds

        ; Set the calls to the timer to our CPS.
        mov     bx, ax                  ; Figure out 1193180/cycles to get
        mov     ax, 34DCh               ; proper divisor for timer
        mov     dx, 12h
	div	bx

        mov     al, 00110110b           ; Set timer interrupt 0 to the
        out     43h, al                 ; divisor
        out     40h, al
        mov     al, ah
        out     40h, al

        ; *****************************************************************************

        ; Save old interrupt
        mov     ax, 351ch
        int     21h
        mov     word ptr [oldint1c], bx
        mov     word ptr [oldint1c+2], es

        ; Put in new interrupt
        push    ds
        mov     ax, seg newint1c
        mov     ds, ax
        mov     dx, offset newint1c
        mov     ax, 251ch
        int     21h
        pop     ds


        ; Put in old interrupt
;        push    ds
;        mov     ax, word ptr [oldint1c+2]
;        mov     ds, ax
;        mov     dx, word ptr [oldint1c]
;        mov     ax, 251ch
;        int     21h
;        pop     ds
;
;        ; Shut down music
;        mov     ah, 2
;        mov     bx, 0
;        call    MusicDriver

        ; Reset timer to standard ...
;        mov     al, 00110110b
;        out     43h, al
;        mov     ax, 65535
;        out     40h, al
;        mov     al, ah
;        out     40h, al

        ; Outta here!
;        mov     ax, 4c00h
;        int     21h


_comienzo:
		  push cs
		  pop  ds
		  


;--------------------------------------------------------------------------
;COMIENSO
;--------------------------------------------------------------------------
;                  ; mov al,ff
                   ; out 21,al
                   ; cli
                    mov ax,0a000h	   ;
                    mov es,ax		   ;
                    mov ax,0013h       ;
                    int 10h			   ;
			     	mov si,offset apal ;
 				    mov cx,0300h	   ;
                    sub al,al		   ;
                    mov dx,03c8h	   ;
		     		out dx,al		   ;
			    	inc dx			   ;
	    			rep				   ;
		    		outsb			   ;
									   ;
                    mov ax,0a000h
                    mov es,ax    

				    push  seg gfx_
				    pop   ds
				  





				  mov cx,0fa00h
				  xor si,si
				  xor di,di
;rrr:			  mov al,ds:[di]
;				  mov es:[di],al
;   		      	  inc di
;	    		  loop rrr

			;	  mov ax,0800h
			;	  int 21h






;---------------------------------------------------------------------------
;
;                                                                  
;                                                                      
;                                                                    
;          ATACK   LOGO ;RUTINA MAEsTRA lado izquierdo                 
;                                                                         
;
;---------------------------------------------------------------------------
;^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;primera fase
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

;jmp fundamental3





FUNDAMENTAL:
			 mov cs:word ptr [cxfud],164			 



             MOV      CX,29000
ETI_5:       PUSH     CX
			; cli
             CALL     SACO		    	;saca los valores de la tabla
             CALL     MOVER_IZQ	        ;mueve gfx
  			 CALL     SCROLL_IZQ		    ;scroll
			 CALL     PONGO			    ;poner los valores denuevo
			 CALL     SACOD
			 CALL     MOVER_DER
			 CALL     SCROLL_DER 
			 CALL     PONGOD
			; CALL     RASTER
			 
			 mov cx,01000
jjjjj:		 nop
			 loop  jjjjj   
			 
			 
			 
			 
			 
			 
			 
			 
			 cmp      cs:word ptr [contadorx],0068;70;70
			 jz	      a
			 add      cs:word ptr [contadorx],0002
		     jmp      b       
a:			 mov      cs:word ptr [contadorx],0000
b:							
             cmp      cs:word ptr [contadorxd],0068
			 jz       ad
			 add      cs:word ptr [contadorxd],0002
			 jmp      bd
ad:			 mov      cs:word ptr [contadorxd],0000
bd:  		 POP      CX
			 LOOP     ETI_5

			 ;jmp _continuar

;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; Segunda parva de puntos ;segunda fase
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
             mov cs:word ptr [contadorxd],0070
             mov cs:word ptr [cxfud],0129		  ;




;---------------------------------------------------------------------------
			 mov cs:word ptr [contadorx],0070;comiensa en 70 
			 mov cs:word ptr [cxfu],0120       ;
;---------------------------------------------------------------------------


              MOV      CX,34000                                      
ETI_5a:       PUSH     CX                                               
                                                                       
             call _llamadas			
             
             ;CALL     RASTER                                          
             mov cx,01000                                               
jjjjja:       nop                                                       
             loop  jjjjja                                               




;------------------------------------------------------------------------                                                                       
			 cmp cs:word ptr [cxfud],163
			 jnz no_esd
			 mov cs:word ptr [cxfud],129
			 jmp _aad
no_esd:      Inc cs:word ptr [cxfud]


_aad:         cmp cs:word ptr [cxfu],155                                                          
             jnz no_esa                                                         
             mov cs:word ptr [cxfu],120                                                          
			 jmp aa

no_esa:      inc  cs:word ptr [cxfu]                                                                
                                                                       
                                                                       
                                                                       
              cmp      cs:word ptr [contadorx],0138;40;6                     
              jz       aa                                                
              add      cs:word ptr [contadorx],0002                     
              jmp      ba                                                
aa:           mov      cs:word ptr [contadorx],0070                     
ba:                                                                     
             cmp      cs:word ptr [contadorxd],00138;96;076;072;4                    
             jz       _ad                                               
             Add      cs:word ptr [contadorxd],0002                    
             jmp      bda                                               
_ad:         mov      cs:word ptr [contadorxd],0070                    
bda:          POP      CX                                               
              LOOP     ETI_5a                                            
              
              
;===========================================================================              
;tercera fase              
;===========================================================================              
;===========================================================================
FUNDAMENTAL3:                                                                
             mov cs:word ptr [cxfud],127;209                                    
             mov cs:word ptr [contadorxd],0142





             mov cs:word ptr  [contadorx],0140;2;2;40
			 mov cs:word ptr [cxfu],119;8;130;02;85
;[]_______________________________________________________________________   
             MOV      CX,32500                                             
ETI_53:      PUSH     CX                                                    
             CALL     SACO              ;saca los valores de la tabla       
             CALL     MOVER_IZQ         ;mueve gfx                          
             CALL     SCROLL_IZQ            ;scroll                         
             CALL     PONGO             ;poner los valores denuevo          
             CALL     SACOD                                                 
             CALL     MOVER_DER                                             
             CALL     SCROLL_DER                                            
             CALL     PONGOD                                                
            ; CALL     RASTER                                               
                                                                            
           mov cx,01000                                                    
jjjjj3:    nop                                                            
           loop  jjjjj3                                                    
                                                                            
                                                                            
                                                                            
                                                                            
                                                                            
                                                                            
                                                                            
                                                                            
             cmp      cs:word ptr [contadorx],0204;186;140;70;70                    
             jz       a3                                                     
             add      cs:word ptr [contadorx],0002                          
             jmp      b3                                                     
a3:          mov      cs:word ptr [contadorx],0140                          
b3:                                                                          
            cmp      cs:word ptr [contadorxd],0210                         
            jz       ad3                                                    
            add      cs:word ptr [contadorxd],0002                         
            jmp      bd3                                                    
ad3:        mov      cs:word ptr [contadorxd],0142                         
bd3:          POP      CX                                                    
             LOOP     ETI_53                                                 
                                                                            
             jmp _continuar                                                



















































              
              
              jmp      _continuar                                       
;----------------------------------------------------------------------------
_llamadas:
             CALL     SACO              ;saca los valores de la tabla 
             CALL     MOVER_IZQ         ;mueve gfx                    
             CALL     SCROLL_IZQ            ;scroll                   
             CALL     PONGO             ;poner los valores denuevo    
             CALL     SACOD                                           
             CALL     MOVER_DER                                       
             CALL     SCROLL_DER                                      
             CALL     PONGOD                                          
			 ret















































;
;                         MOVER UN PUNTO GFX                               
;
MOVER_IZQ:
			CMP       CS:WORD     PTR [ACCION],0000    ;VERIFICA SI HAY QUE  
			JZ        ACCIONAR				           ;EMPESAR CON EL PROC SCROLL
			DEC       CS:WORD     PTR [ACCION]         ;
			RET								           ;
ACCIONAR:   CMP       CS:WORD     PTR [VERIFICADOR],00 ;VERIFICA SI MOVIO LOS 4
		    JZ        FIN1							   ;PUNTOS
		    cmp       cs:word     ptr [retardon],0000  ;VERIFICA SI HAY QUE 
		    jnz       fin1							   ;HACER TIEMPO
 		    DEC 	  CS:WORD     PTR [VERIFICADOR]	;
            MOV       DI,CS:WORD  PTR [POSICION_FIJA]	;
     	    MOV       SI,CS:WORD  PTR [D_GFX]			;
      	    MOV       AL,DS:[SI]						;
		    MOV       ES:[DI],AL						;MUEVE PUNTO A VRAM
		    DEC       CS:WORD     PTR [D_GFX]			;SELECCIONA NUEVO
fin1:		   											
            RET										
;----------------------------------------------------------------------------
;
;                  SCROLL HACIA LA IZQUIERDA                              
;
SCROLL_IZQ:
          
           CMP      CS:WORD     PTR [ACCION],00  ;VERIFICA SI HAY QUE       
           JZ       COMENSO                      ;EMPESAR CON EL PROC SCROLL
           RET
COMENSO:  
           CMP      CS:WORD     PTR [CONTROL_FIN_S],00      ;CONTROL DE FIN DE DEL SCROLL
		   JZ       NO_SCROLL							    ;
           CMP      CS:WORD     PTR [RETARDON],0000   
           JNZ      no_scroll1                            
           call     retardoH                            
	   	   MOV      CX,cs:word ptr [cxfu];cxfu;155                                 ;Largo de puntos que va a tener el scroll.[si no hay lo suficiente 	];es lo mas comun en errores
												    		;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX			  [en cx el scroll no se va	]
													    	;\____________________________/			  [a completar				]
													        ;			   |						  [							]
													        ;			 Largo						  [							]
		   MOV      SI,CS:WORD PTR [PO_SI]				;
		   MOV      DI,SI						    	;
		   INC      DI									;
		   push     ds
		   push     es
		   pop      ds
		   std
ETI_1:	  ; MOV      AL,ES:[SI]							;PUNTO
		  ; MOV      ES:[DI],AL							;MUEVE PUNTO
		  ; DEC      SI									;
		  ; DEC      DI									;
		  ; LOOP     ETI_1								;
		   repz 
		   movsb
		   cld
		   pop     ds


		   
		   dec      cs:word ptr [control_fin_S]		    ;CONTROLA EL DECREMENTO DE 
														;DEL SCROLL
NO_SCROLL:
	  	   ret
no_scroll1:
	       DEC      CS:WORD PTR [RETARDON]													;[CONTROL_FIN_S]=CONTROLAR EL FINAL
           RET
;
;                                SACO                                     
;
SACO:
		mov Bx,cs:word ptr [contadorx]
		
		MOV AX,CS:WORD PTR [VERIFICADOR_1+Bx]
		MOV CS:WORD PTR [VERIFICADOR],AX
		
		MOV AX,CS:WORD PTR [CONTROL_FIN_S_1+Bx]
		MOV CS:WORD PTR [CONTROL_FIN_S],AX

	    MOV AX,CS:WORD PTR [PO_SI_1+Bx]
		MOV CS:WORD PTR [PO_SI],AX

		MOV AX,CS:WORD PTR [D_GFX_1+BX]
		MOV CS:WORD PTR [D_GFX],AX

		MOV AX,CS:WORD PTR [POSICION_FIJA_1+Bx]
		MOV CS:WORD PTR [POSICION_FIJA],AX

		MOV AX,CS:WORD PTR [ACCION_1+bx]
		MOV CS:WORD PTR [ACCION],AX

		MOV AX,CS:WORD PTR [RETARDON_1+BX]
		MOV CS:WORD PTR [RETARDON],AX

        MOV AX,CS:WORD PTR [RESERVA_1+BX]     
        MOV CS:WORD PTR [RESERVA],AX



RET

;
;                                PONGO                                    
;
PONGO:
   mov bx,cs:word ptr [contadorx]
   
   MOV AX,CS:WORD PTR [VERIFICADOR] 
   MOV CS:WORD PTR [VERIFICADOR_1+bx],AX            
                                                
   MOV AX,CS:WORD PTR [CONTROL_FIN_S]         
   MOV CS:WORD PTR [CONTROL_FIN_S_1+bx],AX           
                                                
   MOV AX,CS:WORD PTR [PO_SI]                 
   MOV CS:WORD PTR [PO_SI_1+bx],AX                      
                                                
   MOV AX,CS:WORD PTR [D_GFX]                 
   MOV CS:WORD PTR [D_GFX_1+bx],AX                      
                                                
   MOV AX,CS:WORD PTR [POSICION_FIJA]         
   MOV CS:WORD PTR [POSICION_FIJA_1+bx],AX              
                                                
   MOV AX,CS:WORD PTR [ACCION]                
   MOV CS:WORD PTR [ACCION_1+bx],AX                  

   MOV AX,CS:WORD PTR [RETARDON]   
   MOV CS:WORD PTR [RETARDON_1+BX],AX        

   MOV AX,CS:WORD PTR [RESERVA]
   MOV CS:WORD PTR [RESERVA_1+BX],AX

RET

;
;                              Retado                                     
;

RETARDOH:
	    	cmp     cs: word ptr [retardo],0000	   ;cuando faltan 14
    		jz      ACA;menor                      ;empieza el conteo 
ACA:        CMP     CS:WORD PTR [CONTROL_FIN_S],15 ;
	        JL      MENOR						   ;
no_t:    	RET 								   ;
MENOR:											   ;
	        MOV     AX,CS:WORD PTR [RESERVA]	   ;
		    INC     AX							   ;
		    MOV     CS:WORD PTR [RETARDON],AX	   ;
		    mov     CS:WORD PTR [RESERVA],AX	   ;
    		RET
;---------------------------------------------------------------------------
;
;                                Datos                                         
;

cxfu            dw 0155




VERIFICADOR     DW 00000	;VA A VERIFICAR LOS PUNTOS QUE SE MOVIERON
CONTROL_FIN_S   DW 00000	;CONTROLA SI TERMINO EL SCROLL
PO_SI           DW 00000	;EL EL PUNTO QUE SE USA DE REFERENCIA PARA HACER EL SCROLL
							;XXXXXXXXXXXXXXXXXXPX
							;				   |^---------------------\
							;				   DE ACA MUEVE EL PUNTO -|
							;

D_GFX           DW 00000	;DE ACA SE TOMA EL GFX
							;RESTAR UNO PORQUE EN ASM SE UNSA 0 TAMBIEN
							;
POSICION_FIJA   DW 00000	;ACA SE PONE EL GFX
ACCION          DW 00000	;TIEMPO EN ACTIVAR TODO
RETARDO         DW 00000 	;
RETARDON		DW 00000
RESERVA         DW 00000
;
;-------------------------------------
CONTADORX       DW 0000     ;CONTADOR 																																																 |-----------------------------																																													   |--------------------------																																														 |
;-------------------------------------; 					  X1	X2																																								 |																																																				   |																																																				 |
;					1  	  2		3	  4		5	  6		7	  8		9	  10	11	  12	13	  14	15	  16	17	  18	19	  20	21	  22	23	  24	25	  26	27	  28	29	  30	31	  32	33	  34	35	 |36    37	  38	39	  40	41	  42	43	  44	45	  46	47	  48	49	  50	51	  52	53	  54	55	  56	57	  58	59	  60	61	  62	63	  64	65	  66	67	  68	69	  70   | 71	  72	73	  74	75	  76	77	  78	79	  80	81	  82	83	  84	85	  86	87	  88	89	  90	91	  92	93	  94	95	  96	97	  98	99	  100	101	  102	103	  104	105	 |
VERIFICADOR_1   DW  00035,00034,00033,00032,00031,00030,00029,00028,00027,00026,00025,00024,00023,00022,00021,00020,00019,00018,00017,00016,00015,00014,00013,00012,00011,00010,00009,00008,00007,00006,00005,00004,00003,00002,00001,00001,00002,00003,00004,00005,00006,00007,00008,00009,00010,00011,00012,00013,00014,00015,00016,00017,00018,00019,00020,00021,00022,00023,00024,00025,00026,00027,00028,00029,00030,00031,00032,00033,00034,00035,00070,00070,00070,00070,00070,00070,00070,00070,00070,00070,00070,00070,00070,00070,00070,00070,00070,00070,00070,00070,00070,00070,00070,00070,00070,00070,00070,00070,00070,00070,00070,00070,00070,00070,00070;,00070,00070,00070,00070,00070,00070,00070,00040,00040,00040,00040,00040,00040,00040,00040,00040,00040,00040,00040,00040,00040,00040,00040,00040,00040,00040,00040,00040;,00040,00,000 ;CANTIDAD DE PUNTOS QUE VAMOS A MOVER
CONTROL_FIN_S_1 DW  00155,00155,00155,00155,00155,00155,00155,00155,00155,00155,00155,00155,00155,00155,00155,00155,00155,00155,00155,00155,00155,00155,00155,00155,00155,00155,00155,00155,00155,00155,00155,00155,00155,00155,00155,00120,00121,00122,00123,00124,00125,00126,00127,00128,00129,00130,00131,00132,00133,00134,00135,00136,00137,00138,00139,00140,00141,00142,00143,00144,00145,00146,00147,00148,00149,00150,00151,00152,00153,00154,00119,00119,00119,00119,00119,00119,00119,00119,00119,00119,00119,00119,00119,00119,00119,00119,00119,00119,00119,00119,00119,00119,00119,00119,00119,00119,00119,00119,00119,00119,00119,00119,00119,00119,00119;,00119,00119,00119,00119,001100100118;,00118;,;	                   ;controla el largo del scroll																																   ;
PO_SI_1         DW  27994,28314,28634,28954,29274,29594,29914,30234,30554,30874,31194,31514,31834,32154,32474,32794,33114,33434,33754,34074,34394,34714,35034,35354,35674,35994,36314,36634,36954,37274,37594,37914,38234,38554,38874,27959,28280,28601,28922,29243,29564,29885,30206,30527,30848,31169,31490,31811,32132,32453,32774,33095,33416,33737,34058,34379,34700,35021,35342,35663,35984,36305,36626,36947,37268,37589,37910,38231,38552,38873,27958,28278,28598,28918,29238,29558,29878,30198,30518,30838,31158,31478,31798,32118,32438,32758,33078,33398,33718,34038,34358,34678,34998,35318,35638,35958,36278,36598,36918,37238,37558,37878,38198,38518,38838;,27958;,39513,39834,40155,40476                    ;,28634,28954,29274,29594,29914,30234,30554,30874,31194,31514,31834,32154,32474,32794,33114,33434,33754,34074,34394,34714,35034,35354,35674,35994,36314,36634,36954,37274,37594,37914,38234,38554,38874		                        ;pubnto final en donde terminara el scroll
D_GFX_1         DW  01377,01697,02017,02337,02657,02977,03297,03617,03937,04257,04577,04897,05217,05537,05857,06177,06497,06817,07137,07457,07777,08097,08417,08737,09057,09377,09697,10017,10337,10657,10977,11297,11617,11937,12257,01342,01663,01984,02305,02626,02947,03268,03589,03910,04231,04552,04873,05194,05515,05836,06157,06478,06799,07120,07441,07762,08083,08404,08725,09046,09367,09688,10009,10330,10651,10972,11293,11614,11935,12256,01341,01661,01981,02301,02621,02941,03261,03581,03901,04221,04541,04861,05181,05501,05821,06141,06461,06781,07101,07421,07741,08061,08381,08701,09021,09341,09661,09981,10301,10621,10941,11261,11581,11901,12251;,12571,12891,13211,13531,                                                           ;despues harmamos la tabla con esto!
POSICION_FIJA_1 DW  27841,28161,28481,28801,29121,29441,29761,30081,30401,30721,31041,31361,31681,32001,32321,32641,32961,33281,33601,33921,34241,34561,34881,35201,35521,35841,36161,36481,36801,37121,37441,37761,38081,38401,38721,27841,28161,28481,28801,29121,29441,29761,30081,30401,30721,31041,31361,31681,32001,32321,32641,32961,33281,33601,33921,34241,34561,34881,35201,35521,35841,36161,36481,36801,37121,37441,37761,38081,38401,38721,27841,28161,28481,28801,29121,29441,29761,30081,30401,30721,31041,31361,31681,32001,32321,32641,32961,33281,33601,33921,34241,34561,34881,35201,35521,35841,36161,36481,36801,37121,37441,37761,38081,38401,38721;                     ;uno antes del vorde
ACCION_1        DW  00020,00040,00060,00080,00100,00120,00140,00160,00180,00200,00220,00240,00260,00280,00300,00320,00340,00360,00380,00400,00420,00440,00460,00480,00500,00520,00540,00560,00580,00600,00620,00640,00660,00680,00700,00020,00040,00060,00080,00100,00120,00140,00160,00180,00200,00220,00240,00260,00280,00300,00320,00340,00360,00380,00400,00420,00440,00460,00480,00500,00520,00540,00560,00580,00600,00620,00270,00340,00620,00700,00210,00130,00030,00450,00050,00560,00660,00370,00270,00080,00500,00540,00160,00100,00130,00250,00410,00580,00610,00110,00180,00320,00630,00230,00300,00670,00480,00340,00350,00280,00190,00040,00010,00430,00510;,00000,;               ;retardo que va a tomar en aparecer
RESERVA_1       DW  00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000;,00000,;,00000,00000,00000,00000                    ;
RETARDON_1      DW  00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000;,00000,;,00000,00000,00000,00000                    ;estas posiciones se usan cuando se hacercan al los 10 ultimos
;----------------------------------------------------------------------------



;la posicion control_fin_s (contlol de final del scroo) controla
;la cantidad de que se van a mover hacia la izq.
;entre la posicion_fija y po_si,la diferencia entre estos dos 
;es el resultado de control_fin_s
;porque va desde el principio de la pantalla hasta el final!
;
;
;
;
;
;
;
;
;
NOMBRE DB 'PP.PIX',00


;-----------------------------------------------------------------------
;poner_gfx_p:
;
;			cld
;           	mov      si,10348
;           	mov      di,30498
;			mov      cx,0034
;eti_a:	    cld
;            push     cx
;			push     si
;			push     di
;			mov      cx,0180
;		    repz
;		    movsb
;			pop		 di
;			pop      si
;;;			pop      cx
;			add      di,320
;			add      si,320
;			loop     eti_a 
;
;			ret
;---------------------------------------------------------------------------
;
;                                                                  
;                                                                      
;                                                                    
;          ATACK   LOGO ;FIN DE LA RUTINA MAESTRA                       
;                                                                         
;
;---------------------------------------------------------------------------
;---------------------------------------------------------------------------
;
;                                                                  
;                                                                      
;                                                                    
;          ATACK   LOGO ;RUTINA MAEsTRA lado derecha                   
;                                                                         
;
;---------------------------------------------------------------------------
;^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
MOVER_DER:
;
;                         MOVER UN PUNTO GFX A LA DERECHA                  
;
MOVER_GFX_X1D:
			CMP       CS:WORD     PTR [ACCIOND],0000    ;VERIFICA SI HAY QUE  
			JZ        ACCIONARD				           ;EMPESAR CON EL PROC SCROLL
			DEC       CS:WORD     PTR [ACCIOND]         ;
			RET								           ;
ACCIONARD:   CMP       CS:WORD     PTR [VERIFICADORD],00 ;VERIFICA SI MOVIO LOS 4
		    JZ        FIN1D							   ;PUNTOS
		    cmp       cs:word     ptr [retardonD],0000  ;VERIFICA SI HAY QUE 
		    jnz       fin1D							   ;HACER TIEMPO
 		    DEC 	  CS:WORD     PTR [VERIFICADORD]	;
            MOV       DI,CS:WORD  PTR [POSICIOND_FIJA]	;
     	    MOV       SI,CS:WORD  PTR [D_GFXD]			;
      	    MOV       AL,DS:[SI]						;
		    MOV       ES:[DI],AL						;MUEVE PUNTO A VRAM
		    INC       CS:WORD     PTR [D_GFXD]			;SELECCIONA NUEVO
fin1D:		   											;ESTE VA PARA EL OTRO LADO
            RET											;
;----------------------------------------------------------------------------
;
;                  SCROLL HACIA LA DERECHA                                
;
SCROLL_DER:
          
           CMP      CS:WORD     PTR [ACCIOND],00  ;VERIFICA SI HAY QUE       
           JZ       COMENSOD                      ;EMPESAR CON EL PROC SCROLL
           RET
COMENSOD:  
           CMP      CS:WORD     PTR [CONTROLD_FIN_S],00      ;CONTROL DE FIN DE DEL SCROLL
		   JZ       NO_SCROLLD							    ;
           CMP      CS:WORD     PTR [RETARDOND],0000   
           JNZ      no_scroll1D                            
           call     retardoHD                            
	   	   MOV      CX,cs:word ptr [cxfud];164                                 ;Largo de puntos que va a tener el scroll.[si no hay lo suficiente 	]
												    		;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX			  [en cx el scroll no se va	]
													    	;\____________________________/			  [a completar				]
													        ;			   |						  [							]
													        ;			 Largo						  [							]
		   MOV      SI,CS:WORD PTR [PO_SID]				;
		   MOV      DI,SI						    	;
		   DEC      DI									;
		   PUSH     DS
		   PUSH     ES
		   POP      DS
		   ;STD
ETI_1D:	   ;MOV      AL,ES:[SI]							;PUNTO
		   ;MOV      ES:[DI],AL							;MUEVE PUNTO
		   ;INC      SI									;
		   ;INC      DI									;
		   ;LOOP     ETI_1D								;
		   REPZ 
		   MOVSB
		   pop ds
		   
		   CLD
		   dec      cs:word ptr [controlD_fin_S]		    ;CONTROLA EL DECREMENTO DE 
														;DEL SCROLL
NO_SCROLLD:
	  	   ret
no_scroll1D:
	       DEC      CS:WORD PTR [RETARDOND]													;[CONTROL_FIN_S]=CONTROLAR EL FINAL
           RET
;
;                                SACO DERECHA                             
;
SACOD:
		mov Bx,cs:word ptr [contadorxd];contadorxd
		
		MOV AX,CS:WORD PTR [VERIFICADORD_1+Bx]
		MOV CS:WORD PTR [VERIFICADORD],AX
		
		MOV AX,CS:WORD PTR [CONTROLD_FIN_S_1+Bx]
		MOV CS:WORD PTR [CONTROLD_FIN_S],AX

	    MOV AX,CS:WORD PTR [PO_SID_1+Bx]
		MOV CS:WORD PTR [PO_SID],AX

		MOV AX,CS:WORD PTR [D_GFXD_1+BX]
		MOV CS:WORD PTR [D_GFXD],AX

		MOV AX,CS:WORD PTR [POSICIOND_FIJA_1+Bx]
		MOV CS:WORD PTR [POSICIOND_FIJA],AX

		MOV AX,CS:WORD PTR [ACCIOND_1+bx]
		MOV CS:WORD PTR [ACCIOND],AX

		MOV AX,CS:WORD PTR [RETARDOND_1+BX]
		MOV CS:WORD PTR [RETARDOND],AX

        MOV AX,CS:WORD PTR [RESERVAD_1+BX]     
        MOV CS:WORD PTR [RESERVAD],AX



RET

;
;                                PONGO DERECHA                            
;
PONGOD:
   mov bx,cs:word ptr [contadorxd];contadorxd
   
   MOV AX,CS:WORD PTR [VERIFICADORD] 
   MOV CS:WORD PTR [VERIFICADORD_1+bx],AX            
                                                
   MOV AX,CS:WORD PTR [CONTROLD_FIN_S]         
   MOV CS:WORD PTR [CONTROLD_FIN_S_1+bx],AX           
                                                
   MOV AX,CS:WORD PTR [PO_SID]                 
   MOV CS:WORD PTR [PO_SID_1+bx],AX                      
                                                
   MOV AX,CS:WORD PTR [D_GFXD]                 
   MOV CS:WORD PTR [D_GFXD_1+bx],AX                      
                                                
   MOV AX,CS:WORD PTR [POSICIOND_FIJA]         
   MOV CS:WORD PTR [POSICIOND_FIJA_1+bx],AX              
                                                
   MOV AX,CS:WORD PTR [ACCIOND]                
   MOV CS:WORD PTR [ACCIOND_1+bx],AX                  

   MOV AX,CS:WORD PTR [RETARDOND]   
   MOV CS:WORD PTR [RETARDOND_1+BX],AX        

   MOV AX,CS:WORD PTR [RESERVAD]
   MOV CS:WORD PTR [RESERVAD_1+BX],AX

RET

;
;                              Retado DERECHO                                    
;

RETARDOHD:
	    	cmp     cs: word ptr [retardoD],0000	   ;cuando faltan 14
    		jz      ACAD;menor                      ;empieza el conteo 
ACAD:       CMP     CS:WORD PTR [CONTROLD_FIN_S],15;
	        JL      MENORD						   ;
no_tD:    	RET 								   ;
MENORD:											   ;
	        MOV     AX,CS:WORD PTR [RESERVAD]	   ;
		    INC     AX							   ;
		    MOV     CS:WORD PTR [RETARDOND],AX	   ;
		    mov     CS:WORD PTR [RESERVAD],AX	   ;
    		RET
;---------------------------------------------------------------------------
;
;                                Datos DERECHA                                        
;

cxfud            dw 0000
VERIFICADORD     DW 0000		;VA A VERIFICAR LOS PUNTOS QUE SE MOVIERON
CONTROLD_FIN_S   DW 0000		;CONTROLA SI TERMINO EL SCROLL
PO_SID           DW 0000		;EL EL PUNTO QUE SE USA DE REFERENCIA PARA HACER EL SCROLL
							;XXXXXXXXXXXXXXXXXXPX
							;				   |^---------------------\
							;				   DE ACA MUEVE EL PUNTO -|
							;

D_GFXD           DW 00000	;DE ACA SE TOMA EL GFX
							;RESTAR UNO PORQUE EN ASM SE UNSA 0 TAMBIEN
							;
POSICIOND_FIJA   DW 0000		;ACA SE PONE EL GFX
ACCIOND          DW 0000		;TIEMPO EN ACTIVAR TODO
RETARDOD         DW 0000 	;
RETARDOND	     DW 0000
RESERVAD         DW 0000
;---------------------------
CONTADORXD       DW 0000		;CONTADOR
;---------------------------------------------------------------------------
;																																																									  |_______________________																																																  |____________________________
; 					  X1	X2																																																		  |																																																						  |
;					 1	   2	 3	   4	 5	   6	 7	   8	 9	   10	 11	   12	 13	   14	 15	   16	 17	   18	 19	   20	 21	   22	 23	   24	 25	   26	 27	   28	 29	   30	 31	   32	 33	   34	 35	  | 36	 37	   38	 39	   40	 41	   42	 43	   44	 45	   46	 47	   48	 49	   50	 51	   52	 53	   54	 55	   56	 57	   58	 59	   60	 61	   62	 63	  64	 65	   66	 67	   68	 69	   70	 71	  |72	 73	   74	 75	   76	 77	   78	 79	   80	 81
VERIFICADORD_1   DW  00035,00034,00033,00032,00031,00030,00029,00028,00027,00026,00025,00024,00023,00022,00021,00020,00019,00018,00017,00016,00015,00014,00013,00012,00011,00010,00009,00008,00007,00006,00005,00004,00003,00002,00001,00001,00002,00003,00004,00005,00006,00007,00008,00009,00010,00011,00012,00013,00014,00015,00016,00017,00018,00019,00020,00021,00022,00023,00024,00025,00026,00027,00028,00029,00030,00031,00032,00033,00034,00035,00001,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060;,;00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,00060,,00060;CANTIDAD DE PUNTOS QUE VAMOS A MOVER
CONTROLD_FIN_S_1 DW  00164,00164,00164,00164,00164,00164,00164,00164,00164,00164,00164,00164,00164,00164,00164,00164,00164,00164,00164,00164,00164,00164,00164,00164,00164,00164,00164,00164,00164,00164,00164,00164,00164,00164,00164,00129,00130,00131,00132,00133,00134,00135,00136,00137,00138,00139,00140,00141,00142,00143,00144,00145,00146,00147,00148,00149,00150,00151,00152,00153,00154,00155,00156,00157,00158,00159,00160,00161,00162,00163,00164,00128,00128,00128,00128,00128,00128,00128,00128,00128,00128,00128,00128,00128,00128,00128,00128,00128,00128,00128,00128,00128,00128,00128,00128,00128,00128,00128,00128,00128,00128,00128,00128,00128,00128,00128,00128;00127,00127,00127,00127,,00127,00127,00127,00127,00127,00127,00127,00127,00127,00127,00127,00127,00127,00127,00127,00127,00		;controla el largo del scroll
PO_SID_1         DW  27997,28317,28637,28957,29277,29597,29917,30237,30557,30877,31197,31517,31837,32157,32477,32797,33117,33437,33757,34077,34397,34717,35037,35357,35677,35997,36317,36637,36957,37277,37597,37917,38237,38557,38877,28032,28351,28670,28989,29308,29627,29946,30265,30584,30903,31222,31541,31860,32179,32498,32817,33136,33455,33774,34093,34412,34731,35050,35369,35688,36007,36326,36645,36964,37283,37602,37921,38240,38559,38878,39197,28033,28353,28673,28993,29313,29633,29959,30273,30593,30913,31233,31553,31873,32193,32513,32833,33153,33473,33793,34113,34433,34753,35073,35393,35713,36033,36353,36673,36993,37313,37633,37953,38273,38593,38913,39233;,;inara el scroll
D_GFXD_1         DW  01378,01698,02018,02338,02658,02978,03298,03618,03938,04258,04578,04898,05218,05538,05858,06178,06498,06818,07138,07458,07778,08098,08418,08738,09058,09378,09698,10018,10338,10658,10978,11298,11618,11938,12258,01413,01732,02051,02370,02689,03008,03327,03646,03965,04284,04603,04922,05241,05560,05879,06198,06517,06836,07155,07474,07793,08112,08431,08750,09069,09388,09707,10026,10345,10664,10983,11302,11621,11940,12259,12578,01414,01734,02054,02374,02694,03014,03334,03654,03974,04294,04614,04934,05254,05574,05894,06214,06534,06854,07174,07494,07814,08134,08454,08774,09094,09414,09734,10054,10374,10694,11014,11334,11654,11974,12294,12614;,;   	                                              ;despues harmamos la tabla con esto!
POSICIOND_FIJA_1 DW  28159,28479,28799,29119,29439,29759,30079,30399,30719,31039,31359,31679,31999,32319,32639,32959,33279,33599,33919,34239,34559,34879,35199,35519,35839,36159,36479,36799,37119,37439,37759,38079,38399,38719,39039,28159,28479,28799,29119,29439,29759,30079,30399,30719,31039,31359,31679,31999,32319,32639,32959,33279,33599,33919,34239,34559,34879,35199,35519,35839,36159,36479,36799,37119,37439,37759,38079,38399,38719,39039,39359,28159,28479,28799,29119,29439,29759,30079,30399,30719,31039,31359,31679,31999,32319,32639,32959,33279,33599,33919,34239,34559,34879,35199,35519,35839,36159,36479,36799,37119,37439,37759,38079,38399,38719,39039,39359;28159;        28159,28479,28799,29119,29439,29759,30079,30399,30719,31039,31359,31679,31999,32319,32639,329                             		;uno antes del vorde
ACCIOND_1        DW  00010,00020,00030,00040,00050,00060,00070,00080,00090,00100,00110,00120,00130,00140,00150,00160,00170,00180,00190,00200,00210,00220,00230,00240,00250,00260,00270,00280,00290,00300,00310,00320,00330,00340,00350,00010,00020,00030,00040,00050,00060,00070,00080,00090,00100,00110,00120,00130,00140,00150,00160,00170,00180,00190,00200,00210,00220,00230,00240,00250,00260,00270,00280,00290,00300,00310,00320,00330,00340,00350,00000,00210,00130,00030,00450,00050,00560,00660,00370,00270,00080,00500,00540,00160,00100,00130,00250,00430,00510,00190,00200,00310,00420,00530,00040,00150,00360,00470,00580,00090,00130,00310,00060,00130,00220,00180,00250;
RESERVAD_1       DW  00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000;
RETARDOND_1      DW  00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000,00000;
;----------------------------------------------------------------------------																																																																																												  
;la posicion control_fin_s (contlol de final del scroo) controla
;la cantidad de que se van a mover hacia la izq.
;entre la posicion_fija y po_si,la diferencia entre estos dos 
;es el resultado de control_fin_s
;porque va desde el principio de la pantalla hasta el final!
;
;
;
;
;
;
;
;
;
;NOMBRE DB 'PP.PIX',00


;-----------------------------------------------------------------------
;poner_gfx_p:
;
;			cld
;           	mov      si,10348
;           	mov      di,30498
;			mov      cx,0034
;eti_a:	    cld
;            push     cx
;			push     si
;			push     di
;			mov      cx,0180
;		    repz
;		    movsb
;			pop		 di
;			pop      si
;;;			pop      cx
;			add      di,320
;			add      si,320
;			loop     eti_a 
;
;			ret
;---------------------------------------------------------------------------
;
;                                                                  
;                                                                      
;                                                                    
;          ATACK   LOGO ;FIN DE LA RUTINA MAETRA                       
;                                                                         
;
;---------------------------------------------------------------------------

_continuar:
;		   ;--------------;
;		   xor ax,ax	  ;limpia el seg blanco (qunque ya esta limpio)
;		   mov si,0000	  ;
;		   push seg blanco;
;		   pop ds		  ;
;		   mov cx,64000	  ;
;yy:		   mov ds:[si],al ;
;		   inc si		  ;
;		   loop yy		  ;
		   ;--------------;
					mov	si,46720	   ;atack amarillo!coordenadas
					mov di,30779	   ;   
					push seg gfx_	   ;
					pop  ds			   ;
					push seg blanco	   ;
					pop  es			   ;
					call poner_chivo   ;pone atack amarillo
			                    	   ;en la parte de datos
				           			   ;
					;------------------;
				;	mov ax,0a000h	   ;mueve el gfx de es seg blanco
				;	mov es,ax		   ;a vram
				;	push seg blanco	   ;
				 ;   pop ds 			   ;
				 ;   xor si,si		   ;
				 ;   xor di,di		   ;
				;	mov cx,64000	   ;
				;	repz			   ;
				;	movsb			   ;
				;	mov ax,0800h	   ;
				;	int 21h			   ;
					;------------------;



;--------------------------------------------------------------------------					
;
;                Parte Fundamenta                                         
;
;---------------------------------------------------------------------------
															   
ree:    			  
                      push seg blanco		 ;
                      pop  ds				 ;
                      						 ;
					  ;----------------------;
                      mov ax,0000			 ;limpia una parte del seg blanco
                      mov cx,9600			 ;para poner un nuevo chivo
                      mov si,40956			 ;
eti_a12:              mov ds:[si],ax	     ;
                      inc si				 ;
                      loop eti_a12			 ;
                      ;----------------------;
                      mov cx,0501			 ;
eti_002:              push cx				 ;time out
                      mov cx,0f000h			 ;retardo
eti_001:              nop					 ;
                      loop eti_001			 ;
                      pop cx				 ;
                      loop eti_002			 ;
                      ;----------------------;
                      
                      mov    bx,cs:word ptr [contador]		           ;bx que + gxf_ds1_chivo forman la porxima direccion del nuevo chivo 
                      mov    cs:word    ptr [gfx_largo],0001	       ;es la cantidad de lineas que se va a poner
	                  mov    si,cs:word ptr [gfx_ds1_chivo+bx]         ;el 1er
	                  add    cs:word    ptr [contador],2		       ;chivo bx
	                  mov    cs:word    ptr [posicion_di],51840	       ;posiciones fijas a donde se van a poner los gfx
	               	  mov    cs:word    ptr [posicion_si],41596        ;
		              mov    cs:word    ptr [p_di],41596		       ;esta posicion es en seg blanco en donde empieza el scrool
					 
					 	                  		  ;compara si ya fuel el ultimo chivo
		              cmp    si,11111             ;						   
					  jnz    seguir	              ;						   
					  jmp    ffin	              ;						   
seguir:               										   
					  
				 	  mov di,51840
				 	  push seg blanco
				 	  pop  es
				 	  
				 	  
				 	  call   poner_chivo	  ;  			   
					  push seg blanco
					  pop  ds
					  
					  
;---------------------------------------------------------------					  
;Esta parte es referente a manejo de un solo chivo
;---------------------------------------------------------------
eti_3:    			  push    ds		 				    ;
				      pop     es		 				    ;
															;
				      mov     cx,cs:word ptr [gfx_largo]    ;cantidad de lineas	que va a poner en seg blanco
ETI_II:			      push    cx						    ;
				      mov     si,cs:word ptr [posicion_si]  ; posicion de si
				      mov     di,cS:word ptr [posicion_di]  ; posicion de di
				   											;
				   											;
				      mov    cx,0025	                    ; halto
ETI_I:			  											;
                    										;
                      push   cx		                        ;PONE UNA LINEA   ;
				      push   si		                        ;VERTICAL	       ;
				      push   di		                        ;	  |			   
				      mov    cx,0002	                    ;	  |  		   
				      repz				                    ;|---|				  
				      movsw			                        ;|				   
				      pop    di		                        ;|				   
				      pop    si		                        ;|				   
				      pop    cx		                        ;|				   
				      ADD    SI,320                         ;|         	       
				      ADD 	  DI,320	                    ;|                 
				      loop   ETI_I		                    ;/                
				   						   	   	   
				   
				   
				   add    CS:word ptr [posicion_si],4    ;suma a si para                                    
				   add    cs:word ptr [posicion_di],4    ;tomar la otra                                   				       
				   POP    CX						     ;parte del gfx
				   LOOP   ETI_II				   	     ; 
;---------------------------------------------------------------------------


				   
				   mov    cs:word ptr [posicion_si],51840 ;retaura si
				   inc    cs:word ptr [gfx_largo]		  ;incrementa el largo
				   										  ;
				   mov    ax,cs:word ptr [p_di]			  ;restaura posicion
				   sub    ax,0004						  ;de di original
				   mov    cs:word ptr [p_di],ax			  ;porque di se actualisa
				   mov    cs:word ptr [posicion_di],ax	  ;cada vez que pone el gfx
				                                            
				   
				   
				   cmp    cs:word ptr [gfx_largo],80	  ;compara si paso los 80
				   jz     epa							  ;si los paso empiesa con un nuevo chivo
				   										  ;
				   call   sombra
				   call   movve							  ;mueve todo de datos a a000
				   call   raster						  ;speed
				   										  ;
				   										  ;
				   										  ;
				   jmp    ETI_3							  ;
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
epa:               jmp ree




ffin:				
				   push     cs
				   pop      ds
				   





	  	      		MOV      CX,60
yup1: 	       		PUSH     CX
					mov      si,offset apal
	  	      		mov      cx,3
yup:  	      		
    	      		;CMP        cs:byte PTR [SI],00h
	  	           	;Jnz        NO_SON_CEROS
	  	   	  	    inc         cs:byte PTR [SI]
no_son_ceros:		inc         si			
					loop       yup




					call     poner_paleta
					call     raster
	  	           	pop      cx
	  	           	LOOP     YUP1     	     	
	  	           	jmp real_din     	     	     	     	     	

poner_paleta:	   	mov      si,offset apal 
 				    mov      cx,0300h	   
                    sub      al,al		   
                    mov      dx,03c8h	   
		     		out      dx,al		   
			    	inc      dx			   
	    			rep				   
		    		outsb			   
					ret

real_din:	   		
	      			
	       
	        
	         
	          
	           
	            
	             
	              
	               
	                
	                 
	                  
	                   
	                    
	                     
	                      
	                       
	                        
	                         
	                          
	                           
	                            
	                              push cs
		pop  ds
		mov ax,0003h
		int 10h
        mov dx,offset ans
        mov ah,09h
        int 21h
        mov ax,0800h
        int 21h
        ; Put in old interrupt
        push    ds
        mov     ax, word ptr [oldint1c+2]
        mov     ds, ax
        mov     dx, word ptr [oldint1c]
        mov     ax, 251ch
        int     21h
        pop     ds

        ; Shut down music
        mov     ah, 2
        mov     bx, 0
        call    MusicDriver

        ; Reset timer to standard ...
        mov     al, 00110110b
        out     43h, al
        mov     ax, 65535
        out     40h, al
        mov     al, ah
        out     40h, al

        ; Outta here!


;----------------------------------------------------------------------------
                    mov ax,0003h
                    int 10h
                    mov ax,4c00h
                    int 21h
;---------------------------------------------------------------------
posicion_si	   dw 51840
posicion_di    dw 41596
p_di           dw 41596
gfx_largo      dw 00001


gfx_ds1_chivo  dw 13760,21120,30080,38400,11111
contador       dw 00000

;---------------------------------------------------------------------
movve:
	           push seg blanco
	           pop  ds
	           
	           mov ax,0a000h
	           mov es,ax
	           mov si,41280
	           mov cx,4000
	           mov di,41280
	           repz
	           movsw
	           ret 
;-------------------------------------------------------------------------

raster:     mov ah,8      ;
            mov dx,3dah       ;
rast1:      in  al,dx     ;
            and al,ah         ;
            jz rast1
            ret               ;
;-----------------------------------------
sombra:									  ;
			push seg blanco
			pop  ds
			
			
			mov    di,36523;36843				  ;di de atack_gfx principal
			mov    cx,0013;15				  ;alto
e_2:		push   cx					  ;
			push   di					  ;
			mov    cx,0210;0195				  ;ancho 
e_1:		push   cx					  ;
			mov    al,ds:[di]			  ;ve que no sea 0
			cmp    al,00				  ;
			jnz    cn					  ;
			jmp    no_es1				  ;
										  ;
cn:         							  ;
            push   di					  ;salva di original
            add    di,4800				  ;
            mov    al,ds:[di]			  ;
			cmp    al,00				  ;
            jz no_es					  ;
            add    al,32				  ;cuidado aca
            mov    ds:[di],al			  ;
no_es:      pop    di					  ;saca di
no_es1:     inc    di					  ;
            pop    cx 					  ;
            loop   e_1 					  ;
			pop    di					  ;
			pop    cx					  ;
			add    di,320				  ;
			loop   e_2					  ;
										  ;
			ret							  ;
;---------------------------------------------------------------------------
poner_gfx_p:

			cld
			mov      cx,0040
eti_a:	    cld
            push     cx
			push     si
			push     di
			mov      cx,0195
		    repz
		    movsb
			pop		 di
			pop      si
			pop      cx
			add      di,320
			add      si,320
			loop     eti_a 

			ret
;--------------------------------------------------------------------------
poner_chivo:
		   	push seg gfx_
		   	pop ds
		   
		   
			cld
			mov      cx,0045;25
eti_a1:	    cld
            push     cx
			push     si
			push     di
			mov      cx,0320
		    repz
		    movsb
			pop		 di
			pop      si
			pop      cx
			add      di,320
			add      si,320
			loop     eti_a1 

			ret
;--------------------------------------------------------------------------
kill_w:



;apal:
;	 
;
;
; 		db	0
;		db	 00h, 00h, 3Fh, 3Fh
;		db	25 dup (0)
;		db	0
;		db	8 dup (0)
;		db	0
;		db	23 dup (0)
;		db	0
;		db	35 dup (0)
;		db	 01h, 01h, 04h, 01h, 01h, 08h
;		db	 02h, 02h, 0Dh, 03h, 02h, 11h
;		db	 03h, 03h, 15h, 04h, 03h, 19h
;		db	 05h, 04h, 1Dh, 05h, 04h, 22h
;		db	 06h, 05h, 26h, 07h, 05h, 2Ah
;		db	 07h, 06h, 2Eh, 08h, 06h, 32h
;		db	 09h, 07h, 37h, 09h, 07h, 3Bh
;		db	 0Ah, 08h, 3Fh, 0Dh, 0Bh, 3Fh
;		db	 0Fh, 0Eh, 3Fh, 12h, 11h, 3Fh
;		db	 14h, 14h, 3Fh, 17h, 16h, 3Fh
;		db	 19h, 19h, 3Fh, 1Ch, 1Ch, 3Fh
;		db	 1Eh, 1Fh
;		db	'?!"?#%?&(?(+?+-?-0?03?26?'
;		db	 00h, 00h, 00h, 01h, 00h, 02h
;		db	 01h, 01h, 05h, 02h, 01h, 07h
;		db	 02h, 01h, 0Ah, 03h, 01h, 0Ch
;		db	 03h, 02h, 0Fh, 04h, 02h, 11h
;		db	 04h, 02h, 14h, 05h, 02h, 16h
;		db	 05h, 03h, 19h, 06h, 03h, 1Bh
;		db	 06h, 03h, 1Eh, 07h, 03h, 20h
;		db	 07h, 04h, 23h, 08h, 04h, 25h
;		db	 08h, 04h, 25h, 0Ah, 06h, 26h
;		db	 0Ch, 09h, 26h, 0Eh, 0Bh, 27h
;		db	 10h, 0Dh, 27h, 12h, 0Fh, 28h
;		db	 14h, 12h, 28h, 16h, 14h, 29h
;		db	 17h, 16h, 29h, 19h, 18h, 2Ah
;		db	 1Bh, 1Bh, 2Ah, 1Dh, 1Dh, 2Bh
 ;   	db	 1Fh, 1Fh
  ;  	db	'+!!,#$'
   ; 	db	',%&-', 1Bh
;		db	 10h, 01h, 1Dh, 13h, 04h, 20h
;		db	 16h, 06h, 22h, 19h, 09h, 24h
;		db	 1Ch, 0Bh, 26h, 1Fh, 0Eh, 29h
;		db	 22h, 10h, 2Bh, 25h, 13h, 2Dh
;		db	 27h, 15h, 2Fh, 2Ah, 18h, 32h
;		db	 2Dh, 1Ah, 34h, 30h, 1Dh, 36h
;		db	 33h, 1Fh
;		db	'86";9$'
;		db	';:', 27h, '?'
;		db	 00h, 00h, 3Bh, 00h, 00h, 37h
;		db	 00h, 00h, 32h, 00h, 00h, 2Eh
;		db	 00h, 00h, 2Ah, 00h, 00h, 26h
;		db	 00h, 00h, 22h, 00h, 00h, 1Dh
;		db	 00h, 00h, 19h, 00h, 00h, 15h
;		db	 00h, 00h, 11h, 00h, 00h, 0Dh
;		db	 00h, 00h, 08h, 00h, 00h, 04h
;		db	 00h, 00h, 00h, 00h, 00h, 14h
;		db	 09h, 00h, 16h, 0Bh, 02h, 18h
;		db	 0Dh, 04h, 19h, 10h, 06h, 1Bh
;		db	 12h, 08h, 1Dh, 14h, 0Ah, 1Fh
;		db	 16h, 0Ch, 21h, 18h, 0Eh, 22h
;		db	 1Bh, 0Fh, 24h, 1Dh, 11h, 26h
;		db	 1Fh, 13h, 28h, 21h, 15h, 2Ah
;		db	 23h, 17h, 2Bh, 26h, 19h, 2Dh
;		db	 28h, 1Bh, 2Fh, 2Ah, 1Dh, 26h
;		db	 00h, 00h, 23h, 00h, 00h, 21h
;		db	 00h, 00h, 1Eh, 00h, 00h, 1Ch
;		db	 00h, 00h, 19h, 00h, 00h, 17h
;		db	 00h, 00h, 14h, 00h, 00h, 12h
;		db	 00h, 00h, 0Fh, 00h, 00h, 0Dh
;;		db	 00h, 00h, 0Ah, 00h, 00h, 08h
;		db	 00h, 00h, 05h, 00h, 00h, 03h
;		db	 00h, 00h, 00h, 00h, 00h, 3Fh
;		db	 00h, 00h, 3Bh, 02h, 02h, 37h
;		db	 04h, 04h, 32h, 06h, 06h
;		db	'.', 8, 8, '*', 0Ah, 0Ah, '&', 0Ch
;		db	0Ch, '"'
;		db	 0Eh, 0Eh, 1Dh, 10h, 10h, 19h
;		db	 12h, 12h, 15h, 14h, 14h, 11h
;		db	 16h, 16h, 0Dh, 18h, 18h, 08h
;		db	 1Ah, 1Ah, 04h, 1Ch, 1Ch, 00h
;		db	 1Eh, 1Eh, 00h
;		db	47 dup (0)
;		db	 3Fh, 00h, 00h, 3Bh, 02h, 02h
;		db	 37h, 04h, 04h, 32h, 06h, 06h
;		db	'.', 8, 8, '*', 0Ah, 0Ah, '&', 0Ch
;		db	0Ch, '"'
;		db	 0Eh, 0Eh, 1Dh, 10h, 10h, 19h
;;		db	 12h, 12h, 15h, 14h, 14h, 11h
;		db	 16h, 16h, 0Dh, 18h, 18h, 08h
;		db	 1Ah, 1Ah, 04h, 1Ch, 1Ch, 00h
;		db	 1Eh, 1Eh, 2Ch, 23h, 3Fh, 2Ah
;		db	 20h, 36h, 27h, 1Eh, 2Dh, 25h
;		db	 1Bh, 24h, 22h, 18h, 1Ch, 20h
;		db	 15h, 13h, 1Dh, 13h, 0Ah, 1Bh
;		db	 10h, 01h, 1Eh, 1Eh, 1Eh, 1Eh
;		db	 1Eh
;		db	27h, '???222&&&'
;		db	 19h, 19h, 19h, 0Dh, 0Dh, 0Dh
;		db	 00h, 00h, 00h, 2Fh, 3Dh, 00h
;		db	 26h, 31h, 00h, 23h, 2Dh, 00h
;		db	 21h, 2Bh, 00h, 20h, 29h, 00h
;		db	 1Eh, 27h, 00h, 1Dh, 25h, 00h
;		db	 1Bh, 23h, 00h, 1Ah, 21h, 00h
;		db	 18h, 20h, 00h, 17h, 1Eh, 00h
;		db	 15h, 1Ch, 00h, 14h, 1Ah, 00h
;		db	 12h, 18h, 00h, 11h, 16h, 00h
;		db	 0Fh, 14h, 00h, 0Ch, 10h, 00h
;		db	 0Bh, 0Eh, 00h, 03h, 04h, 00h
;		db	 02h, 02h, 00h, 22h, 18h, 1Ch
;		db	 20h, 15h, 13h, 1Dh, 13h, 0Ah
;		db	 1Bh, 10h, 01h, 14h, 14h, 14h
;		db	 14h, 14h, 1Dh, 23h, 23h, 23h
;		db	 1Ch, 1Ch, 1Ch, 15h, 15h, 15h
;		db	 0Eh, 0Eh, 0Eh, 07h, 07h, 07h
;		db	 00h, 00h, 00h

apal:

        db	0
		db	 00h, 00h, 3Fh, 3Fh
		db	34 dup (0)
        db	0
		db	0, 0, 0, 0, 0, 0
        dw	0
		db	15 dup (0)
        db	0
		db	35 dup (0)
		db	 01h, 01h, 04h, 01h, 01h, 08h
		db	 02h, 02h, 0Dh, 03h, 02h, 11h
		db	 03h, 03h, 15h, 04h, 03h, 19h
		db	 05h, 04h, 1Dh, 05h, 04h, 22h
		db	 06h, 05h, 26h, 07h, 05h, 2Ah
		db	 07h, 06h, 2Eh, 08h, 06h, 32h
		db	 09h, 07h, 37h, 09h, 07h, 3Bh
		db	 0Ah, 08h, 3Fh, 0Dh, 0Bh, 3Fh
		db	 0Fh, 0Eh, 3Fh, 12h, 11h, 3Fh
		db	 14h, 14h, 3Fh, 17h, 16h, 3Fh
		db	 19h, 19h, 3Fh, 1Ch, 1Ch, 3Fh
		db	 1Eh, 1Fh
		db	'?!"?#%?&(?(+?+-?-0?03?26?'
		db	 00h, 00h, 00h, 01h, 00h, 02h
		db	 01h, 01h, 05h, 02h, 01h, 07h
		db	 02h, 01h, 0Ah, 03h, 01h, 0Ch
		db	 03h, 02h, 0Fh, 04h, 02h, 11h
		db	 04h, 02h, 14h, 05h, 02h, 16h
		db	 05h, 03h, 19h, 06h, 03h, 1Bh
		db	 06h, 03h, 1Eh, 07h, 03h, 20h
		db	 07h, 04h, 23h, 08h, 04h, 25h
		db	 08h, 04h, 25h, 0Ah, 06h, 26h
		db	 0Ch, 09h, 26h, 0Eh, 0Bh, 27h
		db	 10h, 0Dh, 27h, 12h, 0Fh, 28h
		db	 14h, 12h, 28h, 16h, 14h, 29h
		db	 17h, 16h, 29h, 19h, 18h, 2Ah
		db	 1Bh, 1Bh, 2Ah, 1Dh, 1Dh, 2Bh
		db	 1Fh, 1Fh
		db	'+!!,#$'
		db	',%&-', 1Bh
		db	 10h, 01h, 1Dh, 13h, 04h, 20h
		db	 16h, 06h, 22h, 19h, 09h, 24h
		db	 1Ch, 0Bh, 26h, 1Fh, 0Eh, 29h
		db	 22h, 10h, 2Bh, 25h, 13h, 2Dh
		db	 27h, 15h, 2Fh, 2Ah, 18h, 32h
		db	 2Dh, 1Ah, 34h, 30h, 1Dh, 36h
		db	 33h, 1Fh
		db	'86";9$'
		db	';:', 27h, '?'
		db	 00h, 00h, 3Bh, 00h, 00h, 37h
		db	 00h, 00h, 32h, 00h, 00h, 2Eh
		db	 00h, 00h, 2Ah, 00h, 00h, 26h
		db	 00h, 00h, 22h, 00h, 00h, 1Dh
		db	 00h, 00h, 19h, 00h, 00h, 15h
		db	 00h, 00h, 11h, 00h, 00h, 0Dh
		db	 00h, 00h, 08h, 00h, 00h, 04h
		db	 00h, 00h, 00h, 00h, 00h, 14h
		db	 09h, 00h, 16h, 0Bh, 02h, 18h
		db	 0Dh, 04h, 19h, 10h, 06h, 1Bh
		db	 12h, 08h, 1Dh, 14h, 0Ah, 1Fh
		db	 16h, 0Ch, 21h, 18h, 0Eh, 22h
		db	 1Bh, 0Fh, 24h, 1Dh, 11h, 26h
		db	 1Fh, 13h, 28h, 21h, 15h, 2Ah
		db	 23h, 17h, 2Bh, 26h, 19h, 2Dh
		db	 28h, 1Bh, 2Fh, 2Ah, 1Dh, 26h
		db	 00h, 00h, 23h, 00h, 00h, 21h
		db	 00h, 00h, 1Eh, 00h, 00h, 1Ch
		db	 00h, 00h, 19h, 00h, 00h, 17h
		db	 00h, 00h, 14h, 00h, 00h, 12h
		db	 00h, 00h, 0Fh, 00h, 00h, 0Dh
		db	 00h, 00h, 0Ah, 00h, 00h, 08h
		db	 00h, 00h, 05h, 00h, 00h, 03h
		db	 00h, 00h, 00h, 00h, 00h, 26h
		db	 00h, 2Eh, 22h, 00h, 29h, 1Eh
		db	 00h, 24h, 19h, 00h, 1Fh, 15h
		db	 00h, 1Ah, 11h, 00h, 14h, 0Dh
		db	 00h, 0Fh, 08h, 00h, 0Ah, 04h
		db	 00h, 05h, 00h, 00h, 00h, 3Fh
		db	 34h, 00h, 3Ah, 2Fh, 02h, 35h
		db	 2Bh, 05h, 2Fh, 26h, 07h, 2Ah
		db	 22h, 0Ah, 25h, 1Dh, 0Ch, 00h
		db	47 dup (0)
		db	 1Ah, 00h, 1Eh, 17h, 00h, 1Bh
		db	 14h, 00h, 17h, 11h, 00h, 14h
		db	 0Eh, 00h, 11h, 0Ch, 00h, 0Dh
		db	 09h, 00h, 0Ah, 06h, 00h, 07h
		db	 03h, 00h, 03h, 00h, 00h, 00h
		db	 37h, 28h, 00h, 32h, 24h, 01h
		db	 2Dh, 20h, 02h, 27h, 1Dh, 02h
		db	 22h, 19h, 03h, 1Dh, 15h, 04h
		db	 2Ch, 23h, 3Fh, 2Ah, 20h, 36h
		db	 27h, 1Eh, 2Dh, 25h, 1Bh, 24h
		db	 22h, 18h, 1Ch, 20h, 15h, 13h
		db	 1Dh, 13h, 0Ah, 1Bh, 10h, 01h
		db	 1Eh, 1Eh, 1Eh, 1Eh, 1Eh
		db	27h, '???222&&&'
		db	 19h, 19h, 19h, 0Dh, 0Dh, 0Dh
		db	 3Fh, 3Fh, 00h, 2Fh, 3Dh, 00h
		db	 26h, 31h, 00h, 23h, 2Dh, 00h
		db	 21h, 2Bh, 00h, 20h, 29h, 00h
		db	 1Eh, 27h, 00h, 1Dh, 25h, 00h
		db	 1Bh, 23h, 00h, 1Ah, 21h, 00h
		db	 18h, 20h, 00h, 17h, 1Eh, 00h
		db	 15h, 1Ch, 00h, 14h, 1Ah, 00h
		db	 12h, 18h, 00h, 11h, 16h, 00h
		db	 0Fh, 14h, 00h, 0Ch, 10h, 00h
		db	 0Bh, 0Eh, 00h, 03h, 04h, 00h
		db	 02h, 02h, 00h, 22h, 18h, 1Ch
		db	 20h, 15h, 13h, 1Dh, 13h, 0Ah
		db	 1Bh, 10h, 01h, 14h, 14h, 14h
		db	 14h, 14h, 1Dh, 23h, 23h, 23h
		db	 1Ch, 1Ch, 1Ch, 15h, 15h, 15h
		db	 0Eh, 0Eh, 0Eh, 09h, 09h, 09h
		db	 2Eh, 2Eh, 00h
;               mov ax,3d00h            ;Abre file nombre pc1.pix           
;               mov dx,offset nombre    ;furi y lo pone en el seg1 cs+1000  
;               int 21h                 ;                                   
;               jb ffin                  ;                                   
;---------------------------------------------------------------------------
;			   mov bx,ax
;			   
;			   
;			   mov ah,42h
;			   mov al,00
;			   mov cx,0000
;			   mov dx,0ff00h
;			   int 21h
;			   jb ffin
;
;
;
;
;               mov cx,64000            ;                                   
;               mov ax,cs               ;SIGUIENTE SEGMENTO = [seg1]        
;               add ax,1000h            ;                                   
;               mov ds,ax               ;                                   
;               XOR DX,DX               ;                                   
;               mov ax,3f00h            ;sierra                             
;               int 21h                 ;                                   
;               jb ffin                  ;                                   
;               mov ax,bx               ;                                   
;               mov ax,3e00h            ;                                   
;               int 21h                 ;                                   
;               jb ffin                  ;                                   
;               jmp fin                ;                                   
;
;
;ffin:			mov ax,0900
;				mov dx,offset mal
;				int 21h
;fin:			mov ax,4c00h
;				int 21h
;
;
;nombre          db 'pix.pix',00,00
;mal             db 'esto esta mal$',24,00,00

ans:

                db      1Bh, '[?7h', 1Bh, '[40m', 1Bh, '['
                db      '2J', 1Bh, '[0;1;30m[INTRO BY NEI'
                db      'K_RAIDER/COTE]', 1Bh, '[13C[GREE'
                db      'TS TO ALL GUYS FROM BELGUIUM WOW'
                db      '!]', 0Dh, 0Ah, 1Bh, '[28C', 1Bh, '['
                db      '0mTODAY iS:', 0Dh, 0Ah, 0Dh, 0Ah
                db      1Bh, '[10C', 1Bh, '[1;30m'
                db      0C4h,0C4h,0C4h, 1Bh, 5Bh, 30h
                db       6Dh,0C4h
                db      32 dup (0C4h)
                db      ' ', 1Bh, '[1;31m'
                db      0DCh, 20h, 1Bh, 5Bh, 30h, 6Dh
                db      0C4h
                db      9 dup (0C4h)
                db       1Bh, 5Bh, 31h, 3Bh, 33h, 30h
                db       6Dh,0C4h,0C4h,0C4h, 0Dh, 0Ah
                db       1Bh, 5Bh, 39h, 43h,0C4h,0C4h
                db      0C4h,0C4h, 1Bh, 5Bh, 30h, 6Dh
                db      0C4h,0C4h,0C4h,0C4h
                db      ' ', 1Bh, '[1;31m'
                db      0DFh,0DFh,0DFh,0DFh,0DFh,0DBh
                db       20h,0DFh,0DFh,0DFh,0DFh, 1Bh
                db       5Bh, 34h, 31h, 6Dh,0DFh, 1Bh
                db       5Bh, 34h, 30h, 6Dh,0DBh, 20h
                db      0DFh,0DFh,0DFh,0DFh,0DFh,0DBh
                db       20h,0DFh,0DFh,0DFh,0DFh,0DFh
                db      0DFh,0DFh, 20h,0DFh, 20h, 20h
                db       20h,0DBh, 20h, 1Bh, 5Bh, 30h
                db       6Dh,0C4h,0C4h,0C4h,0C4h,0C4h
                db      0C4h, 1Bh, 5Bh, 31h, 3Bh, 33h
                db       30h, 6Dh,0C4h,0C4h,0C4h,0C4h
                db       0Dh, 0Ah, 1Bh, 5Bh, 38h, 43h
                db      0C4h,0C4h,0C4h,0C4h,0C4h, 1Bh
                db       5Bh, 30h, 6Dh,0C4h,0C4h,0C4h
                db      0C4h
                db      ' ', 1Bh, '[1;31m'
                db      0DBh,0DFh,0DFh,0DFh, 1Bh, 5Bh
                db       34h, 31h, 6Dh,0DFh, 1Bh, 5Bh
                db       34h, 30h, 6Dh,0DBh, 20h, 1Bh
                db       5Bh, 30h, 6Dh,0C4h,0C4h,0C4h
                db      0C4h
                db      ' ', 1Bh, '[1;31m'
                db      0DBh, 20h,0DBh,0DFh,0DFh,0DFh
                db       1Bh, 5Bh, 34h, 31h, 6Dh,0DFh
                db       1Bh, 5Bh, 34h, 30h, 6Dh,0DBh
                db       20h,0DBh, 20h, 1Bh, 5Bh, 30h
                db       6Dh,0C4h,0C4h,0C4h,0C4h,0C4h
                db      ' ', 1Bh, '[1;31m'
                db      0DBh,0DFh,0DFh,0DFh,0DFh, 1Bh
                db       5Bh, 34h, 31h, 6Dh,0DFh, 1Bh
                db       5Bh, 34h, 30h, 6Dh,0DBh, 20h
                db       1Bh, 5Bh, 30h, 6Dh,0C4h,0C4h
                db      0C4h,0C4h, 1Bh, 5Bh, 31h, 3Bh
                db       33h, 30h, 6Dh,0C4h,0C4h,0C4h
                db      0C4h,0C4h, 0Dh, 0Ah, 1Bh, 5Bh
                db       37h, 43h,0C4h,0C4h,0C4h,0C4h
                db      0C4h,0C4h, 1Bh, 5Bh, 30h, 6Dh
                db      0C4h,0C4h,0C4h,0C4h
                db      ' ', 1Bh, '[1;31m'
                db      0DBh, 20h, 1Bh, 5Bh, 30h, 6Dh
                db      0C4h,0C4h
                db      ' ', 1Bh, '[1;31m'
                db      0DBh, 20h, 1Bh, 5Bh, 30h, 6Dh
                db      0C4h,0C4h,0C4h,0C4h
                db      ' ', 1Bh, '[1;31m'
                db      0DBh, 20h,0DBh, 20h, 1Bh, 5Bh
                db       30h, 6Dh,0C4h,0C4h
                db      ' ', 1Bh, '[1;31m'
                db      0DBh, 20h,0DBh, 20h, 1Bh, 5Bh
                db       30h, 6Dh,0C4h,0C4h,0C4h,0C4h
                db      0C4h
                db      ' ', 1Bh, '[1;31m'
                db      0DBh, 20h, 1Bh, 5Bh, 30h, 6Dh
                db      0C4h,0C4h,0C4h
                db      ' ', 1Bh, '[1;31m'
                db      0DBh, 20h, 1Bh, 5Bh, 30h, 6Dh
                db      0C4h,0C4h,0C4h,0C4h, 1Bh, 5Bh
                db       31h, 3Bh, 33h, 30h, 6Dh,0C4h
                db      0C4h,0C4h,0C4h,0C4h,0C4h, 0Dh
                db       0Ah, 1Bh, 5Bh, 37h, 43h,0C4h
                db      0C4h,0C4h,0C4h,0C4h,0C4h, 1Bh
                db       5Bh, 30h, 6Dh,0C4h,0C4h,0C4h
                db      0C4h
                db      ' ', 1Bh, '[1;31m'
                db      0DBh,0DDh, 1Bh, 5Bh, 30h, 6Dh
                db      0C4h,0C4h
                db      ' ', 1Bh, '[1;31m'
                db      0DBh, 20h, 1Bh, 5Bh, 30h, 6Dh
                db      0C4h,0C4h,0C4h,0C4h
                db      ' ', 1Bh, '[1;31m'
                db      0DBh, 20h,0DBh,0DDh, 1Bh, 5Bh
                db       30h, 6Dh,0C4h,0C4h
                db      ' ', 1Bh, '[1;31m'
                db      0DBh, 20h,0DBh, 1Bh, 5Bh, 34h
                db       31h, 6Dh,0DCh, 1Bh, 5Bh, 34h
                db       30h, 6Dh,0DCh,0DCh,0DCh,0DCh
                db      0DCh, 20h,0DBh,0DDh, 1Bh, 5Bh
                db       30h, 6Dh,0C4h,0C4h,0C4h
                db      ' ', 1Bh, '[1;31m'
                db      0DBh, 20h, 1Bh, 5Bh, 30h, 6Dh
                db      0C4h,0C4h,0C4h,0C4h, 1Bh, 5Bh
                db       31h, 3Bh, 33h, 30h, 6Dh,0C4h
                db      0C4h,0C4h,0C4h,0C4h,0C4h, 0Dh
                db       0Ah, 1Bh, 5Bh, 37h, 43h,0C4h
                db      0C4h,0C4h,0C4h,0C4h,0C4h, 1Bh
                db       5Bh, 30h, 6Dh,0C4h,0C4h
                db      ' ', 1Bh, '[1;30m______ ', 1Bh, '['
                db      '31m'
                db      0DBh, 20h, 1Bh, 5Bh, 33h, 30h
                db       6Dh
                db      11 dup (5Fh)
                db       20h, 1Bh, 5Bh, 33h, 31h, 6Dh
                db      0DBh
                db       20h, 1Bh, 5Bh, 33h, 30h, 6Dh
                db      7 dup (5Fh)
                db       20h, 1Bh, 5Bh, 33h, 31h, 6Dh
                db      0DBh
                db       20h, 1Bh, 5Bh, 33h, 30h, 6Dh
                db      7 dup (5Fh)
                db       20h, 1Bh, 5Bh, 30h, 6Dh,0C4h
                db      0C4h, 1Bh, 5Bh, 31h, 3Bh, 33h
                db       30h, 6Dh,0C4h,0C4h,0C4h,0C4h
                db      0C4h,0C4h, 0Dh, 0Ah, 1Bh, 5Bh
                db       38h, 43h,0C4h,0C4h,0C4h,0C4h
                db      0C4h, 1Bh, 5Bh, 30h, 6Dh,0C4h
                db      ' ', 1Bh, '[1;30m:', 1Bh, '[0;31m'
                db      'argentine traders & couriers kor'
                db      'poration', 1Bh, '[1;30m| ', 1Bh, '['
                db      '0m'
                db      0C4h, 1Bh, 5Bh, 31h, 3Bh, 33h
                db       30h, 6Dh,0C4h,0C4h,0C4h,0C4h
                db      0C4h, 0Dh, 0Ah, 1Bh, 5Bh, 39h
                db       43h,0C4h,0C4h,0C4h,0C4h, 1Bh
                db       5Bh, 30h, 6Dh,0C4h,0C4h
                db      1Bh, '[1;30m`------ ', 1Bh, '[31m'
                db      0DBh, 20h, 1Bh, 5Bh, 33h, 30h
                db       6Dh
                db      11 dup (2Dh)
                db       20h, 1Bh, 5Bh, 33h, 31h, 6Dh
                db      0DBh
                db       20h, 1Bh, 5Bh, 33h, 30h, 6Dh
                db      7 dup (2Dh)
                db       20h, 1Bh, 5Bh, 33h, 31h, 6Dh
                db      0DDh
                db       1Bh, 5Bh, 33h, 30h, 6Dh, 2Dh
                db      7 dup (2Dh)
                db       27h, 1Bh, 5Bh, 30h, 6Dh,0C4h
                db      0C4h, 1Bh, 5Bh, 31h, 3Bh, 33h
                db       30h, 6Dh,0C4h,0C4h,0C4h,0C4h
                db       0Dh, 0Ah, 1Bh, 5Bh, 31h, 30h
                db       43h,0C4h,0C4h,0C4h, 1Bh, 5Bh
                db       30h, 6Dh,0C4h
                db      8 dup (0C4h)
                db      ' ', 1Bh, '[1;31m'
                db      0DEh, 20h, 1Bh, 5Bh, 30h, 6Dh
                db      0C4h
                db      10 dup (0C4h)
                db      ' ', 1Bh, '[1;31m'
                db      0DEh, 20h, 1Bh, 5Bh, 30h, 6Dh
                db      0C4h,0C4h,0C4h,0C4h,0C4h,0C4h
                db      0C4h
                db      ' ', 1Bh, '[1;31m'
                db      0DDh, 1Bh, 5Bh, 30h, 6Dh
                db      11 dup (0C4h)
                db       1Bh, 5Bh, 31h, 3Bh, 33h, 30h
                db       6Dh,0C4h,0C4h,0C4h
                db       64h, 6Bh
                db      0Dh, 0Ah, 1Bh, '[26C', 1Bh, '[31m'
                db      'DA COMPLETE MEMBERLiST', 0Dh, 0Ah
                db      '    ', 1Bh, '[37mif ya aren', 1Bh
                db      '[0m', 27h, 1Bh, '[1mt in this li'
                db      'st', 1Bh, '[0m, ', 1Bh, '[1mDONT'
                db      ' PUT ATACK in yar affiliations', 1Bh
                db      '[0m..', 0Dh, 0Ah, 0Dh, 0Ah, 1Bh, '['
                db      '18C', 1Bh, '[1;30m[', 1Bh, '[0m-'
                db      1Bh, '[1mSpider', 1Bh, '[0m------'
                db      1Bh, '[1;30m]  Trader', 1Bh, '[6C'
                db      'XXXXXXX', 0Dh, 0Ah, 1Bh, '[18C[', 1Bh
                db      '[0m-', 1Bh, '[1m(G)EORGE', 1Bh, '['
                db      '0m----', 1Bh, '[1;30m]  Sfx/ansi'
                db      '    XXXXXXX', 0Dh, 0Ah, 1Bh, '[1'
                db      '8C[', 1Bh, '[0m-', 1Bh, '[1mEXOT'
                db      'IC', 1Bh, '[0m------', 1Bh, '[1;'
                db      '30m]  Trader', 1Bh, '[6CXXXXXXX', 0Dh
                db      0Ah, 1Bh, '[18C[', 1Bh, '[0m-', 1Bh
                db      '[1mThierry', 1Bh, '[0m-----', 1Bh
                db      '[1;30m]  Trader', 1Bh, '[6CXXXXX'
                db      'XX', 0Dh, 0Ah, 1Bh, '[18C[', 1Bh
                db      '[0m-', 1Bh, '[1mNeiK_RaiDeR', 1Bh
                db      '[0m-', 1Bh, '[1;30m]  CoDER', 1Bh
                db      '[7C44331XX', 0Dh, 0Ah, 1Bh, '[18'
                db      'C[', 1Bh, '[0m-', 1Bh, '[1mBLaCK'
                db      'iE', 1Bh, '[0m-----', 1Bh, '[1;3'
                db      '0m]  sPReaDeR    6826750', 0Dh, 0Ah
                db      1Bh, '[18C[', 1Bh, '[0m-', 1Bh, '['
                db      '1mDiSKiLLeR 2', 1Bh, '[0m-', 1Bh
                db      '[1;30m]  aRTiST', 1Bh, '[6CXXXXX'
                db      'XX', 0Dh, 0Ah, 1Bh, '[18C[', 1Bh
                db      '[0m-', 1Bh, '[1mBoti', 1Bh, '[0m'
                db      '--------', 1Bh, '[1;30m]  Beerdr'
                db      'inker XXXXXXX', 1Bh, '[0m', 1Bh, '['
                db      '255D',24h
                








codigo ends
blanco segment byte 
                                
          db 64000 dup (0)        
blanco ends                        






END	START
end
