#extension GL_ARB_texture_rectangle : enable

varying vec2 vTexCoord;
uniform sampler2DRect source;
uniform sampler2D noise;

void main()
{
	vec4 noiseValue = ((texture2D(noise, vTexCoord / vec2(960.0, 720.0) * 2.3) * 2.0) - 1.0) * 1.5 + 
					  ((texture2D(noise, vTexCoord / vec2(960.0, 720.0) * 0.1) * 2.0) - 1.0) * 0.3;
	vec4 sourceColour = texture2DRect(source, vTexCoord);
	float greyscale = dot(sourceColour.rgb, vec3(0.299, 0.587, 0.114));
	gl_FragColor = sourceColour + noiseValue * greyscale;
}
