// Description : Array and textureless GLSL 2D simplex noise function.
//      Author : Ian McEwan, Ashima Arts.
//  Maintainer : ijm
//     Lastmod : 20110822 (ijm)
//     License : Copyright (C) 2011 Ashima Arts. All rights reserved.
//               Distributed under the MIT License. See LICENSE file.
//               https://github.com/ashima/webgl-noise

#pragma OPENCL EXTENSION cl_amd_printf : enable


float3 mod289f3(float3 x) 
{
  return x - floor(x * (1.0 / 289.0)) * 289.0;
}


float2 mod289f2(float2 x) 
{
  return x - floor(x * (1.0 / 289.0)) * 289.0;
}

float3 permute(float3 x) 
{
  return mod289f3(((x*34.0)+1.0)*x);
}

float snoise(float2 v)
  {
  const float4 C = (float4)(0.211324865405187,  // (3.0-sqrt(3.0))/6.0
                      0.366025403784439,  // 0.5*(sqrt(3.0)-1.0)
                     -0.577350269189626,  // -1.0 + 2.0 * C.x
                      0.024390243902439); // 1.0 / 41.0
// First corner
  float2 i  = floor(v + dot(v, C.yy) );
  float2 x0 = v -   i + dot(i, C.xx);

// Other corners
  float2 i1;
  //i1.x = step( x0.y, x0.x ); // x0.x > x0.y ? 1.0 : 0.0
  //i1.y = 1.0 - i1.x;
  i1 = (x0.x > x0.y) ? (float2)(1.0, 0.0) : (float2)(0.0, 1.0);
  // x0 = x0 - 0.0 + 0.0 * C.xx ;
  // x1 = x0 - i1 + 1.0 * C.xx ;
  // x2 = x0 - 1.0 + 2.0 * C.xx ;
  float4 x12 = x0.xyxy + C.xxzz;
  x12.xy -= i1;

// Permutations
  i = mod289f2(i); // Avoid truncation effects in permutation
  float3 p = permute( permute( i.y + (float3)(0.0, i1.y, 1.0 ))
		+ i.x + (float3)(0.0, i1.x, 1.0 ));

  float3 m = max(0.5 - (float3)(dot(x0,x0), dot(x12.xy,x12.xy), dot(x12.zw,x12.zw)), 0.0);
  m = m*m ;
  m = m*m ;

// Gradients: 41 points uniformly over a line, mapped onto a diamond.
// The ring size 17*17 = 289 is close to a multiple of 41 (41*7 = 287)

  float3 temp;
  float3 x = 2.0 * fract(p * C.www, &temp) - 1.0;



  float3 h = fabs(x) - 0.5;
  float3 ox = floor(x + 0.5);
  float3 a0 = x - ox;

// Normalise gradients implicitly by scaling m
// Approximation of: m *= inversesqrt( a0*a0 + h*h );
  m *= 1.79284291400159 - 0.85373472095314 * ( a0*a0 + h*h );

// Compute final noise value at P
  float3 g;
  g.x  = a0.x  * x0.x  + h.x  * x0.y;
  g.yz = a0.yz * x12.xz + h.yz * x12.yw;
  return 130.0 * dot(m, g);
}

float fBm_noise(float2 x)
{
  float y = snoise(x);
  y += snoise(2 * x) * 0.5;
  y += snoise(4 * x) * 0.25;
  y += snoise(8 * x) * 0.125;
  //y += snoise(16 * x) * 0.0625;
  return (y / 1.875) * 0.5 + 0.5;
}

__kernel void SimplexNoise(__write_only image2d_t noiseTex, float deltaTime)
{
	uint2 pos = (uint2)(get_global_id(0), get_global_id(1));
	float2 fpos = convert_float2(pos)/256.0f;
	fpos = (fpos * 2 - 1) * 1;
	//printf("%v2f\n", fpos);

	fpos.x += sin(deltaTime * 0.103);
	fpos.y += cos(deltaTime * 0.079);

	float4 noize;
	noize.x = fBm_noise(fpos);
	noize.y = fBm_noise(fpos + 79.263);
	noize.z = fBm_noise(fpos + 208.54);
	noize.w = 1.0;

	write_imagef(noiseTex, convert_int2(pos), noize);
}