#version 150
#extension GL_ARB_explicit_attrib_location : enable

in vec2 TexCoord; // From the geometry shader

in vec4 eyePos;

uniform sampler2D texOne;
uniform sampler2D texTwo;
uniform sampler2D texThree;
layout( location = 0 ) out vec4 fragColor;
uniform mat4 cMat;

struct LightInfo
{
	vec3 position;
	vec3 color;
};

uniform LightInfo LightOne;

in vec3 colOut;

uniform mat4 invPMat;
uniform mat4 pMat;

void main()
{
	float fragAlpha = texture2D(texTwo, TexCoord).a;
	if(fragAlpha == 0.0) discard;

	vec3 diffuseColor = texture2D(texTwo, TexCoord).rgb;
	vec4 eyePosC = eyePos;
	eyePosC.z += texture2D(texOne, TexCoord).a*4;
	eyePosC.z += colOut.x/2;

	vec4 ndc = pMat * eyePosC;

	gl_FragDepth = ndc.z/ndc.w;//gl_FragCoord.z - ( (texture2D(texOne, TexCoord).a) *0.01);

	fragColor = vec4(colOut.x*diffuseColor,  fragAlpha);
}	