#version 150
#extension GL_ARB_explicit_attrib_location : enable
layout( points ) in;
layout( triangle_strip, max_vertices = 4 ) out;

uniform float halfSize;
uniform mat4 pMat;
out vec2 TexCoord;

in vec3 col[1];

out vec4 eyePos;
out vec3 colOut;

void main()
{
colOut = col[0];

float halfSizeScaled = halfSize * col[0].y;
gl_Position = pMat * (vec4(-halfSizeScaled,-halfSizeScaled,0.0,0.0) + gl_in[0].gl_Position);
eyePos = (vec4(-halfSizeScaled,-halfSizeScaled,0.0,0.0) + gl_in[0].gl_Position);
TexCoord = vec2(0.0,0.0);
EmitVertex();

gl_Position = pMat * (vec4(halfSizeScaled,-halfSizeScaled,0.0,0.0) + gl_in[0].gl_Position);
eyePos = (vec4(halfSizeScaled,-halfSizeScaled,0.0,0.0) + gl_in[0].gl_Position);
TexCoord = vec2(1.0,0.0);
EmitVertex();

gl_Position = pMat * (vec4(-halfSizeScaled,halfSizeScaled,0.0,0.0) + gl_in[0].gl_Position);
eyePos = (vec4(-halfSizeScaled,halfSizeScaled,0.0,0.0) + gl_in[0].gl_Position);
TexCoord = vec2(0.0,1.0);
EmitVertex();

gl_Position = pMat * (vec4(halfSizeScaled,halfSizeScaled,0.0,0.0) + gl_in[0].gl_Position);
eyePos = (vec4(halfSizeScaled,halfSizeScaled,0.0,0.0) + gl_in[0].gl_Position);
TexCoord = vec2(1.0,1.0);
EmitVertex();

EndPrimitive();
}