#version 150
#extension GL_ARB_explicit_attrib_location : enable

uniform sampler2D Tex;

out vec4 outColor;
in vec2 UV;

uniform vec3 colorCorrection;
uniform float transparency;
uniform float moveX;
uniform float moveY;
uniform float divX;
uniform float divY;

void main()
{
	vec3 rgb = pow(texture2D( Tex, vec2( (UV.x/divX)+moveX, ((-UV.y)/divY)+moveY ) ).rgb, vec3(2.2f))*colorCorrection;
	float alpha = texture2D( Tex, vec2( (UV.x/divX)+moveX, ((-UV.y)/divY)+moveY ) ).a;

	vec4 color = vec4(rgb, alpha);
	color *= vec4(transparency);
	outColor = color;
}