#version 150
#extension GL_ARB_explicit_attrib_location : enable

//<attributes>
layout(location = 0) in vec4 inPos;
layout(location = 1) in vec4 inPosTwo;
//</attributes>

uniform mat4 cMat;
uniform mat4 mvMat;
uniform float interpolation;

out vec3 col;

vec3 UnPackFloat(float src)
{
  return vec3(fract(src), fract(src * 256.0f), fract(src * 65536.0f));
}

void main()
{
	vec4 posOne = cMat * vec4(inPos.xyz,1.0);
	vec4 posTwo = mvMat * vec4(inPosTwo.xyz, 1.0);

	vec4 pos = (posOne * (1-interpolation)) + (posTwo*interpolation);

	gl_Position = pos;
	col = UnPackFloat(inPosTwo.w);
}