
#include "wav.h"
#include "readdir.h"


filelist_struct filelist[MAX_FILES];
WAV_struct WAV_list[MAX_FILES];

int amount_linkfiles;

s8 *sample_output_pointer;

int add_filename(int no,char *fname)
{
	int i;
	u8 *p;
	printf("\nadd_filename %i : %s",no,fname);

	p = samples_start + sample_list_names;
	p+=no*17;								// 16+1 chars per sample

	// skip first 3 chars
	if(*fname++ == 0) return -1;
	if(*fname++ == 0) return -1;
	if(*fname++ == 0) return -1;

	for(i=0;i<16;i++) p[i] = ' ';

	for(i=0;i<16;i++)
	{
		if( (*fname == 0) || (*fname=='.')) return 0;
		*p++ = *fname++;
	}
	return 0;
}

int add_sample_list(int no)
{
	u32 start,length;
	u8 *p;

	p = samples_start + sample_list;
	p+= no*8;				// start_of_sample,sample_length

	start  = (u32)(sample_output_pointer - samples_start);
	length = num_samples;

	write32(p,start);	p+=4;
	write32(p,length);	p+=4;

	return 0;
}



int read_directory()
{
	struct _finddata_t ffblk;
	long handle;
	int done, i,j;
	int max_files = MAX_FILES;
	u8 *q;
	u32 r, offset;

	amount_linkfiles = i = 0;
	sample_bytes_total   = 0;

	printf("input WAV-files:\n");
	printf("----------------\n");

	handle = _findfirst("*.WAV",&ffblk);
	
	if(handle == -1)
	{
		printf("\n*** ERROR READING DIRECTORY ***\n");
		return -1;
	}

	done = 0;
	while (!done)
	{
		filelist[i].length = ffblk.size;
		strcpy(filelist[i].fname,ffblk.name);

		// read first 4 bytes of filename for search id
		q = (u8*)&ffblk.name;
		r = q[0]<<24 | q[1]<<16 | q[2]<<8 | q[3];
		filelist[i].f0 =  r;		

		printf("  %s  -- %i bytes\n", ffblk.name,ffblk.size);

		done = _findnext(handle, &ffblk);

		i++;
		amount_linkfiles++;
		max_files--;
		if(!max_files) break;
	}
	printf("\n\n%i WAV-files found\n",amount_linkfiles);


	sort_filelist();

	//display_filelist();

	// set samples id to "null"
	for(i=0;i<MAX_FILES;i++)
	{
		WAV_list[i].id[0] = 'n';
		WAV_list[i].id[1] = 'u';
		WAV_list[i].id[2] = 'l';
		WAV_list[i].id[3] = 'l';
	}
	
	// add filename to sample_list_names
	for(i=0;i<amount_linkfiles;i++)
	{
		strcpy(WAV_list[i].fname,filelist[i].fname);
		add_filename(i,WAV_list[i].fname);
	}

	// process wav-files & write raw data

	sample_output_pointer = samples_start + sample_data;

	for(i=0;i<amount_linkfiles;i++)
	{
		printf("\nadding wav: %s",WAV_list[i].fname);

		if (load_and_convert_WAV(WAV_list[i].fname) == -1 ) return -1;

		add_sample_list(i);

		sample_output_pointer+=num_samples;

		for(j=0;j<SAMPLE_END_BYTES;j++) *sample_output_pointer++=0x00;
	}

	/*
	// fill up
	j = MAX_SAMPLESIZE  - sample_bytes_total;
	
	for(i=0;i<j;i++) *sample_output_pointer++=0x00;
	
	sample_output_pointer-=j;

	for(i=amount_linkfiles;i<MAX_FILES;i++)
	{
		printf("\nfilling up: %i",i);
		add_sample_list(i);
		add_filename(i, "00-empty sample");
	}
	*/

	printf("\n\n%i bytes for samples total\n\n\n",sample_bytes_total);

	return 0;
}


void sort_filelist()
{
	int i,j;
	char fname[256];
	u32	 f0;
	u32	 length;

	// bubblesort
	for(i=0;i<amount_linkfiles;i++)
	{
		for(j=i;j<amount_linkfiles;j++)
		{
			if(filelist[j].f0 < filelist[i].f0)
			{
				strcpy(fname,filelist[j].fname);
				f0 = 	filelist[j].f0;
				length= filelist[j].length;

				strcpy(filelist[j].fname, filelist[i].fname);
				filelist[j].f0 		= filelist[i].f0;
				filelist[j].length 	= filelist[i].length;

				strcpy(filelist[i].fname, fname);
				filelist[i].f0 		= f0;
				filelist[i].length 	= length;
			}
		}
	}
}


void display_filelist()
{
	int i;
	printf("\n\nSORTED FILES:\n\n");
	for(i=0;i<amount_linkfiles;i++)
	{
		printf("\n%s",filelist[i].fname);
	}
}

