/******************************************************************************
 * Application.h                                                              *
 ******************************************************************************
 * Project      : Futura (DevLib Demo)                                        *
 * License      : LGPL (full notice can be found at root directory)           *
 * Created by   : Arnaud Storq (norecess@devlib-central.org)                  *
 ******************************************************************************/
#ifndef __APPLICATION_H__
#define __APPLICATION_H__

// ---------------------------------------------------------------------------- INCLUDE
#include "Displayable.h"
#include "Background.h"
#include "Loading.h"
#include "Player.h"
#include "Ship.h"
#include "Level.h"

// ---------------------------------------------------------------------------- APPLICATION
class Application;

// ---------------------------------------------------------------------------- LANGUAGE TYPE
enum LanguageType
{
    LANGUAGE_FRENCH,
    LANGUAGE_ENGLISH
};

// ---------------------------------------------------------------------------- APPLICATION
class Application : public RENDERSYSTEM
{
public:
	~Application( );

    static Application *getInstance( );
    static void destroy( );

    void setLanguage( LanguageType languageType ) { m_languageType = languageType; }
    LanguageType getLanguage( ) { return m_languageType; }

    XML *getXML( ) { return m_xml; };
    XMLNode *getLanguageNode( );

    Font *getLittleFont( ) { return m_littleFont; }
    Font *getBigFont( ) { return m_bigFont; }
    vector< Ship * > &getShips( ) { return m_ships; }
    Texture *getHud( ) { return m_hud; }
    Texture *getDetail( ) { return m_detail; }
    Sound *getClickSelect( ) { return m_clickSelect; }
    Sound *getClickValidate( ) { return m_clickValidate; }
    Sound *getDeath( ) { return m_death; }
    Sound *getGo( ) { return m_go; }
    Sound *getJump( ) { return m_jump; }
    Texture *getFade( ) { return m_fade; }

    float getTime( ) { return m_time; }
    float getElapsedTime( ) { return m_elapsedTime; }

    Player *getPlayer1( ) { return m_player1; }
    Player *getPlayer2( ) { return m_player2; }

    Level *getLevel( ) { return m_level; };
    int getLevelIndex( ) { return m_levelIndex; };

    Background *getBackground( ) { return m_background; };
    Loading *getLoading( ) { return m_loading; };

    float getTileSpeed( TileType tileType );

    float getTickTime( ) { return m_tickTime; };

private:
    Application( );

    static Application *m_instance;

	void create( );
	void displayUpdate( float elapsedTime );
	void keyPress( Key key );
	void release( );

    XML *m_xml;

    Font *m_littleFont;
    Font *m_bigFont;

    vector< Ship * > m_ships;

    Texture *m_hud;
    Texture *m_detail;

    Level *m_level;
    int m_levelIndex;

    Sound *m_clickSelect;
    Sound *m_clickValidate;
    Sound *m_death;
    Sound *m_go;
    Sound *m_jump;

    Texture *m_fade;

    Player *m_player1;
    Player *m_player2;

    Displayable *m_displayable;

    float m_time;
    float m_elapsedTime;
    float m_tickTime;

    LanguageType m_languageType;

    Background *m_background;
    Loading *m_loading;

    float m_tileSpeedVerySlow;
    float m_tileSpeedSlow;
    float m_tileSpeedNormal;
    float m_tileSpeedFast;
    float m_tileSpeedVeryFast;

    ResourceReader *m_resourceReader;

    SoundSystem *m_soundSystem;
};

// ---------------------------------------------------------------------------- END
#endif // __APPLICATION_H__
