/******************************************************************************
 * Displayable.h                                                              *
 ******************************************************************************
 * Project      : Futura (DevLib Demo)                                        *
 * License      : LGPL (full notice can be found at root directory)           *
 * Created by   : Arnaud Storq (norecess@devlib-central.org)                  *
 ******************************************************************************/
#ifndef __DISPLAYABLE_H__
#define __DISPLAYABLE_H__

// ---------------------------------------------------------------------------- DISPLAYABLE TYPE
enum DisplayableType
{
    DISPLAYABLE_MENU,
    DISPLAYABLE_MENU_MAIN,
    DISPLAYABLE_MENU_INSTRUCTIONS,
    DISPLAYABLE_MENU_SELECTSHIP,
    DISPLAYABLE_GAME
};

// ---------------------------------------------------------------------------- DISPLAYABLE
class Displayable
{
public:
    virtual ~Displayable( ) { };

    virtual void displayUpdate( ) = 0;
    virtual void keyPress( Key key ) = 0;

    virtual bool isFinished( ) = 0;

    virtual DisplayableType getDisplayableType( ) = 0;
};

// ---------------------------------------------------------------------------- END
#endif // __DISPLAYABLE_H__
