#include "DevLib.h"
/******************************************************************************
 * Game.cpp                                                                   *
 ******************************************************************************
 * Project      : Futura (DevLib Demo)                                        *
 * License      : LGPL (full notice can be found at root directory)           *
 * Created by   : Arnaud Storq (norecess@devlib-central.org)                  *
 ******************************************************************************/
#include "Game.h"
#include "Player.h"
#include "Application.h"

// ---------------------------------------------------------------------------- CONSTRUCTOR
Game::Game( )
{
    m_isFinished = false;

    m_hasFinishedLevel = false;

    m_view = View::createView( );
}

// ---------------------------------------------------------------------------- DESTRUCTOR
Game::~Game( )
{
    delete m_view;
}

// ---------------------------------------------------------------------------- CREATE GAME
Game *Game::createGame( )
{
    return new Game( );
}

// ---------------------------------------------------------------------------- KEY PRESS
void Game::keyPress( Key key )
{
    Player *player1 = Application::getInstance( )->getPlayer1( );
    Player *player2 = Application::getInstance( )->getPlayer2( );

    if ( player1 )
        player1->keyPress( key );

    if ( player2 )
    {
        switch( key )
        {
        case KEY_X:
            key = KEY_LEFT;
            break;

        case KEY_V:         
            key = KEY_RIGHT;        
            break;

        case KEY_LCTRL:     
            key = KEY_SPACE;
            break;

        default:
            return;
        }
        
        player2->keyPress( key );
    }
}

// ---------------------------------------------------------------------------- DISPLAY UPDATE
void Game::displayUpdate( )
{
    Player *player1 = Application::getInstance( )->getPlayer1( );
    Player *player2 = Application::getInstance( )->getPlayer2( );
        
    if ( player1 )
    {
        player1->update( );
        
        if ( player2 )
            m_view->displayUpdate( VIEW_TOP, player1 );
        else
            m_view->displayUpdate( VIEW_FULLSCREEN, player1 );
    }

    if ( player2 )
    {
        player2->update( );

        m_view->displayUpdate( VIEW_BOTTOM, player2 );
    }

    if ( player1 )
    {
        if ( player2 )
        {
            if ( player2->hasFinishedLevel( ) && player1->hasFinishedLevel( ) )
            {
                m_hasFinishedLevel = true;
                m_isFinished = true;
            }
            else
            if ( ( player2->hasLost( ) && player2->getLifeCount( ) < 0 ) && ( player1->hasLost( ) && player1->getLifeCount( ) < 0 ) )
            {
                m_isFinished = true;
            }
        }
        else
        {
            if ( player1->hasFinishedLevel( ) )
            {
                m_hasFinishedLevel = true;
                m_isFinished = true;
            }
            else
            if ( player1->hasLost( ) && player1->getLifeCount( ) < 0 )
            {
                m_isFinished = true;
            }
        }
    }

    if ( m_isFinished )
    {
        Application::getInstance( )->getLoading( )->displayUpdate( );
    }
}
