/******************************************************************************
 * Game.h                                                                     *
 ******************************************************************************
 * Project      : Futura (DevLib Demo)                                        *
 * License      : LGPL (full notice can be found at root directory)           *
 * Created by   : Arnaud Storq (norecess@devlib-central.org)                  *
 ******************************************************************************/
#ifndef __GAME_H__
#define __GAME_H__

// ---------------------------------------------------------------------------- INCLUDE
#include "Displayable.h"
#include "View.h"

// ---------------------------------------------------------------------------- GAME
class Game : public Displayable
{
public:
	~Game( );

    static Game *createGame( );
    
    virtual void displayUpdate( );
    virtual void keyPress( Key key );

    virtual bool isFinished( ) { return m_isFinished; };

    virtual DisplayableType getDisplayableType( ) { return DISPLAYABLE_GAME; }

    bool hasFinishedLevel( ) { return m_hasFinishedLevel; };

private:
    Game( );

    View *m_view;
    
    bool m_isFinished;

    bool m_hasFinishedLevel;
};

// ---------------------------------------------------------------------------- END
#endif // __GAME_H__
