/******************************************************************************
 * Level.h                                                                    *
 ******************************************************************************
 * Project      : Futura (DevLib Demo)                                        *
 * License      : LGPL (full notice can be found at root directory)           *
 * Created by   : Arnaud Storq (norecess@devlib-central.org)                  *
 ******************************************************************************/
#ifndef __LEVEL_H__
#define __LEVEL_H__

// ---------------------------------------------------------------------------- INCLUDE
#include "Player.h"
#include "Background.h"
#include "Tile.h"

class Game;

// ---------------------------------------------------------------------------- LEVEL
class Level
{
public:
	~Level( );

    static Level *createLevel( int index );

    int getTrackWidth( );
    int getTrackHeight( );
    
    float getTrackSpeed( ) { return m_trackSpeed; };
    TileType getTrackTile( int x, int y );

    Tile *getTile( TileType tileType );
    float getTileSize( ) { return getTile( TILE_NORMAL )->getSize( ); };

    int getStartJumpCount( ) { return m_startJumpCount; };

    Texture *getShipEnvmap( ) { return m_shipEnvmap; };

    Sound *getMusic( ) { return m_music; };

private:
    Level( int index );

    int m_startJumpCount;
    
    // track
    vector< TileType > m_track;
    float m_trackSpeed;

    // tiles
    vector< Tile * > m_tiles;
    
    // music
    Sound *m_music;

    // ship envmap
    Texture *m_shipEnvmap;
};

// ---------------------------------------------------------------------------- END
#endif // __LEVEL_H__
