#include "DevLib.h"
/******************************************************************************
 * Loading.cpp                                                                *
 ******************************************************************************
 * Project      : Futura (DevLib Demo)                                        *
 * License      : LGPL (full notice can be found at root directory)           *
 * Created by   : Arnaud Storq (norecess@devlib-central.org)                  *
 ******************************************************************************/
#include "Loading.h"
#include "Application.h"

// ---------------------------------------------------------------------------- CONSTRUCTOR
Loading::Loading( )
{
}

// ---------------------------------------------------------------------------- DESTRUCTOR
Loading::~Loading( )
{
}

// ---------------------------------------------------------------------------- CREATE LOADING
Loading *Loading::createLoading( )
{
    return new Loading( );
}

// ---------------------------------------------------------------------------- DISPLAY UPDATE
void Loading::displayUpdate( )
{
    RenderSystem *rs = RenderSystemManager::getRenderSystem( );

    rs->setClearColor( 0x00000000 );
    rs->clear( CLEAR_MODE_TARGET );

    Font *littleFont = Application::getInstance( )->getLittleFont( );
    
    string loadingText = Application::getInstance( )->getLanguageNode( )->getChildElement( "loading" )->getChildElement( )->getString( );
        
    littleFont->render( ( rs->getWidth( ) - littleFont->getStringWidth( loadingText ) ) / 2, ( rs->getHeight( ) - littleFont->getCharacterHeight( ) ) / 2, loadingText );
}
