#include "DevLib.h"
/******************************************************************************
 * MenuInstructions.cpp                                                       *
 ******************************************************************************
 * Project      : Futura (DevLib Demo)                                        *
 * License      : LGPL (full notice can be found at root directory)           *
 * Created by   : Arnaud Storq (norecess@devlib-central.org)                  *
 ******************************************************************************/
#include "MenuInstructions.h"
#include "Application.h"

// ---------------------------------------------------------------------------- CREATE MENU INSTRUCTIONS
MenuInstructions *MenuInstructions::createMenuInstructions( )
{
    return new MenuInstructions( );
}

// ---------------------------------------------------------------------------- CONSTRUCTOR
MenuInstructions::MenuInstructions( )
{
    m_isFinished = false;
}

// ---------------------------------------------------------------------------- DESTRUCTOR
MenuInstructions::~MenuInstructions( )
{
}

// ---------------------------------------------------------------------------- KEY PRESS
void MenuInstructions::keyPress( Key key )
{
    if ( ( key == KEY_SPACE ) || ( key == KEY_RETURN ) )
    {
        m_isFinished = true;

        Application::getInstance( )->getClickValidate( )->play( );
    }
}

// ---------------------------------------------------------------------------- DISPLAY UPDATE
void MenuInstructions::displayUpdate( )
{
    Font *littleFont = Application::getInstance( )->getLittleFont( );
    Font *bigFont = Application::getInstance( )->getBigFont( );

    RenderSystem *rs = RenderSystemManager::getRenderSystem( );

    // Display title
    string instructionsTitle = Application::getInstance( )->getLanguageNode( )->getChildElement( "instructionsTitle" )->getChildElement( )->getString( );
    bigFont->render( ( rs->getWidth( ) - bigFont->getStringWidth( instructionsTitle ) ) / 2, rs->getHeight( ) / 16, instructionsTitle );

    // Display text
    int charHeight = littleFont->getCharacterHeight( );

    int x = rs->getWidth( ) / 4;
    int yLine = rs->getHeight( ) / 4;

    XMLNode *lineNode = Application::getInstance( )->getLanguageNode( )->getChildElement( "instructions" );
    int lineCount = lineNode->getChildCount( );
    for ( int line = 0; line < lineCount; ++line )
    {
        if ( lineNode->getChildElement( line )->getChildElement( ) )
        {
            string lineText = lineNode->getChildElement( line )->getChildElement( )->getString( );

            if ( lineText != "" )
            {
                littleFont->render( ( rs->getWidth( ) - littleFont->getStringWidth( lineText ) ) / 2, yLine, lineText );
            }
        }

        yLine += littleFont->getCharacterHeight( );
    }
}
