/******************************************************************************
 * MenuInstructions.h                                                         *
 ******************************************************************************
 * Project      : Futura (DevLib Demo)                                        *
 * License      : LGPL (full notice can be found at root directory)           *
 * Created by   : Arnaud Storq (norecess@devlib-central.org)                  *
 ******************************************************************************/
#ifndef __MENU_INSTRUCTIONS_H__
#define __MENU_INSTRUCTIONS_H__

// ---------------------------------------------------------------------------- INCLUDE
#include "Displayable.h"

// ---------------------------------------------------------------------------- MENU INSTRUCTIONS
class MenuInstructions : public Displayable
{
public:
	~MenuInstructions( );

    static MenuInstructions *createMenuInstructions( );

    virtual void displayUpdate( );
    virtual void keyPress( Key key );

    virtual bool isFinished( ) { return m_isFinished; };

    virtual DisplayableType getDisplayableType( ) { return DISPLAYABLE_MENU_INSTRUCTIONS; }

private:
    MenuInstructions( );

    bool m_isFinished;
};

// ---------------------------------------------------------------------------- END
#endif // __MENU_INSTRUCTIONS_H__
