#include "DevLib.h"
/******************************************************************************
 * MenuMain.cpp                                                               *
 ******************************************************************************
 * Project      : Futura (DevLib Demo)                                        *
 * License      : LGPL (full notice can be found at root directory)           *
 * Created by   : Arnaud Storq (norecess@devlib-central.org)                  *
 ******************************************************************************/
#include "MenuMain.h"
#include "Application.h"

// ---------------------------------------------------------------------------- ITEMS
static MenuMainSelection s_items[] = 
{
    MENUMAIN_SELECTION_ONEPLAYER,
    MENUMAIN_SELECTION_TWOPLAYERS,
    MENUMAIN_SELECTION_INSTRUCTIONS,
    MENUMAIN_SELECTION_QUIT
};

// ---------------------------------------------------------------------------- CREATE MENU MAIN
MenuMain *MenuMain::createMenuMain( )
{
    return new MenuMain( );
}

// ---------------------------------------------------------------------------- CONSTRUCTOR
MenuMain::MenuMain( )
{
    m_cursor = 0;

    string cursorFilename = Application::getInstance( )->getXML( )->getRoot( )->getChildElement( "menu" )->getChildElement( "cursor" )->getChildElement( )->getString( );
    m_cursor = Texture::createTexture( false, cursorFilename );
    m_cursor->createAlpha( 0xFF, true );

    m_item = 0;
    m_isFinished = false;
}

// ---------------------------------------------------------------------------- DESTRUCTOR
MenuMain::~MenuMain( )
{
    delete m_cursor;
}

// ---------------------------------------------------------------------------- KEY PRESS
void MenuMain::keyPress( Key key )
{
    if ( key == KEY_UP )
    {
        m_item--;

        if ( m_item < 0 )
            m_item = 0;
        else
            Application::getInstance( )->getClickSelect( )->play( );
    }

    if ( key == KEY_DOWN )
    {
        m_item++;

        if ( m_item > 3 )
            m_item = 3;
        else
            Application::getInstance( )->getClickSelect( )->play( );
    }

    if ( ( key == KEY_SPACE ) || ( key == KEY_RETURN ) )
    {
        m_isFinished = true;
        
        m_selection = s_items[ m_item ];

        Application::getInstance( )->getClickValidate( )->play( );
    }
}

// ---------------------------------------------------------------------------- DISPLAY UPDATE
void MenuMain::displayUpdate( )
{
    float time = Application::getInstance( )->getTime( );

    Font *littleFont = Application::getInstance( )->getLittleFont( );
    Font *bigFont = Application::getInstance( )->getBigFont( );

    RenderSystem *rs = RenderSystemManager::getRenderSystem( );

    // Clear Z-buffer 
    rs->clear( CLEAR_MODE_ZBUFFER );

    // Set matrix projection
    rs->setMatrixMode( MATRIX_MODE_PROJECTION );
    Matrix matrixProjection;
    matrixProjection.setPerspective(    0.00001f, // minimum Z-value
                                        1000.0f, // maximum Z-value
                                        45.0f, // focal
                                        ( (float) rs->getWidth( ) ) / ( (float) rs->getHeight( ) ) // ratio
                                    );
    rs->loadMatrix( matrixProjection );

    // Set view projection
    rs->setMatrixMode( MATRIX_MODE_MODELVIEW );	
    rs->loadIdentityMatrix( );

    // Display title
    string gameName = Application::getInstance( )->getLanguageNode( )->getChildElement( "gameName" )->getChildElement( )->getString( );
    bigFont->render( ( rs->getWidth( ) - bigFont->getStringWidth( gameName ) ) / 2, rs->getHeight( ) / 4, gameName );

    // Display menu
    int charHeight = littleFont->getCharacterHeight( );

    int x = rs->getWidth( ) / 4;
    int yCenter = rs->getHeight( ) / 2;
    int yChoice = yCenter + m_item * charHeight;

    rs->setRenderState( RS_BLENDING, RV_BLENDING_TEXTURE_ALPHA );
    
    Application::getInstance( )->getFade( )->render( 0, yChoice, rs->getWidth( ), yChoice + charHeight );

    int zoom = (int) ( (float) ( 5.0f + 5.0f * sinf( time * 5.0f ) ) );

    int posX = x - ( rs->getWidth( ) / 14 ) - zoom;
    int posY = yChoice + 1 - zoom;
    int width = m_cursor->getWidth( ) + zoom + zoom;
    int height = m_cursor->getHeight( ) + zoom + zoom;

    m_cursor->render( posX, 
                      posY, 
                      posX + width, 
                      posY + height );

    rs->setRenderState( RS_BLENDING, RV_BLENDING_NONE );

    XMLNode *itemNode = Application::getInstance( )->getLanguageNode( )->getChildElement( "menuItems" );
    int itemCount = itemNode->getChildCount( );
    for ( int item = 0; item < itemCount; ++item )
    {
        string itemText = itemNode->getChildElement( item )->getChildElement( )->getString( );

        littleFont->render( x, yCenter + item * charHeight, itemText );
    }
}
