/******************************************************************************
 * MenuSelectShip.h                                                           *
 ******************************************************************************
 * Project      : Futura (DevLib Demo)                                        *
 * License      : LGPL (full notice can be found at root directory)           *
 * Created by   : Arnaud Storq (norecess@devlib-central.org)                  *
 ******************************************************************************/
#ifndef __MENU_SELECTSHIP_H__
#define __MENU_SELECTSHIP_H__

// ---------------------------------------------------------------------------- INCLUDE
#include "Displayable.h"
#include "Ship.h"

// ---------------------------------------------------------------------------- MENU SELECTSHIP
class MenuSelectShip : public Displayable
{
public:
	~MenuSelectShip( );

    static MenuSelectShip *createMenuSelectShip( );

    virtual void displayUpdate( );
    virtual void keyPress( Key key );

    virtual bool isFinished( ) { return m_isFinished; };

    virtual DisplayableType getDisplayableType( ) { return DISPLAYABLE_MENU_SELECTSHIP; }

    void setPlayerCount( int playerCount ) { m_playerCount = playerCount; };

    Ship *getShipPlayer1( ) { return m_shipPlayer1; };
    Ship *getShipPlayer2( ) { return m_shipPlayer2; };

private:
    MenuSelectShip( );

    void displaySquares( int x, int y, float value, int charHeight );

    int m_playerCount;
    int m_player;
    int m_ship;

    Ship *m_shipPlayer1;
    Ship *m_shipPlayer2;

    float m_grip;
    float m_maxSpeed;
    float m_lenghtJump;

    bool m_isFinished;

    Texture *m_fill;
    Texture *m_shipEnvmap;
};

// ---------------------------------------------------------------------------- END
#endif // __MENU_SELECTSHIP_H__
