/******************************************************************************
 * View.h                                                                     *
 ******************************************************************************
 * Project      : Futura (DevLib Demo)                                        *
 * License      : LGPL (full notice can be found at root directory)           *
 * Created by   : Arnaud Storq (norecess@devlib-central.org)                  *
 ******************************************************************************/
#ifndef __VIEW_H__
#define __VIEW_H__

// ---------------------------------------------------------------------------- INCLUDE
#include "Player.h"

// ---------------------------------------------------------------------------- VIEW TYPE
enum ViewType
{
    VIEW_FULLSCREEN,
    VIEW_TOP,
    VIEW_BOTTOM
};

// ---------------------------------------------------------------------------- VIEW
class View
{
public:
	~View( );

    static View *createView( );

    void displayUpdate( ViewType type, Player *player );

private:
    View( );

    void displayView( Player *player );
    void displayHud( Player *player );

    bool m_3;
    bool m_2;
    bool m_1;
    bool m_go;
};

// ---------------------------------------------------------------------------- END
#endif // __VIEW_H__
