/*
	This file is part of CrocoLib.

	CrocoLib is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	CrocoLib is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public License
	along with Ceremony.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "crLIB.h"

#include <string.h> // memset

// ----------------------------------------------------------------------------
void callbackUnpack( )
{
	crSYNCWaitVBL( );
	crCRTCFlipScreen( );

	crAYPlay( );
}

// ----------------------------------------------------------------------------
int xChar = 0;
int xPixel = 16;

int yChar = 0;
int yPixel = 0;

char flip = 0;

// ----------------------------------------------------------------------------
struct SFont s_font;

struct SScroll s_vertScroll;
struct SScroll s_horizScroll;

static unsigned char *s_drawStringText = "TEST";
static unsigned char *s_scrollVertText = "ARNAUD!1234!DUANRA!5678!";

// ----------------------------------------------------------------------------
void updateScroll( )
{
	xPixel -= 4;
	if ( xPixel < 0 )
	{
		xPixel += 16;

		xChar++;
		if ( xChar == 1024 )
		{
			xChar = 0;
		}
	}
	
	yPixel++;	
	if ( yPixel == 8 )
	{
		yPixel = 0;

		yChar += 48; // 54; // 48;
		if ( yChar > 1024 )
		{
			yChar -= 1024;
		}
	}
}

// ----------------------------------------------------------------------------
void main( )
{	
	crDATAInit( 0x2000 );
	crInit( );

	crSYNCDisableSysInterrupts( );
    asm( "ld sp, $0400" );

	// font
	memcpy( 0xC000, crDATAGetPointer( DATA_FONT32X32 ), DATA_FONT32X32_SIZE );
	crBANKSetC4( );
	crPACKERUnpack( 0x4000, 0xC000 );
	crBANKSetC0( );	
	strcpy( s_font.fontCharSet, "'() +,-. 0123456789:ABCDEFGHIJKLMNOPQRSTUVWXYZ     ! =?" );
	s_font.fontAdress = 0x4000;
	s_font.fontBank = 0xC4;
	s_font.fontCharWidth = 32 / 4;
	s_font.fontCharHeight = 32;
	s_font.fontCharsPerLine = 10;
	crTEXTInitFont( s_font );
	
	crAYSetupPlayer( );

	crGASetMode( 0 );
	crGASetColor( BORDER, COLOR_BLACK );

	crPACKERUnpack( 0xC000, crDATAGetPointer( DATA_BALL ) );	
	
	// crASICUnlock( );
	// crASICSetSpriteData( 0, 0xC000 );

	crCRTCSetupScreen( CRTC_OVERSCAN_FULLSCREEN, CRTC_VIDEOPAGE_8000, CRTC_VIDEOPAGE_8000, CRTC_VIDEOPAGESIZE_32KB );

	memset( 0x8000, 0, 0x8000 );
	
	crASICUnlock( );
	crASICSetPalette( crDATAGetPointer( DATA_CHAOS_PAL ) + 8 );
	crPACKERUnpackWithCallback( 0x8000, crDATAGetPointer( DATA_CHAOS ), callbackUnpack );
	
	memset( 0x8000, 0, 0x8000 );
	// crPACKERUnpack( 0x8000, crDATAGetPointer( DATA_CHAOS ) );

	crASICSetPalette( crDATAGetPointer( DATA_FONT32X32_PAL ) + 8 );

	crASICCreateSplitScreen( 200 );//164 );

	crTEXTDrawString( (struct SFont *) &s_font, (unsigned int) s_drawStringText, 0x8000, 12, 80 );

	crASICUnlock( );
	crASICSetSpritePalette( crDATAGetPointer( DATA_BALL_PAL ) + 8 );	
	crASICEnableSprite( 0, ASIC_SPRITEMODE_320_640, 400, 200 );

	s_vertScroll.charOffset = 0;
	s_vertScroll.pageAdress = 0;
	s_vertScroll.posX = 0;
	s_vertScroll.posY = 120;
	s_vertScroll.textOffset = 0;


	s_horizScroll.charOffset = 0;
	s_horizScroll.pageAdress = 0;
	s_horizScroll.posX = 96;
	s_horizScroll.posY = 10;
	s_horizScroll.textOffset = 0;

	while ( 1 )
	{
		crCRTCSetScreenOffset( CRTC_VIDEOPAGE_8000, CRTC_VIDEOPAGESIZE_16KB, yChar );

		crSYNCWaitVBL( );
		// crCRTCFlipScreen( );
		
		crASICSetScrollOffset( 0, yPixel );
		crASICSetScreenOffset( ASIC_VIDEOPAGE_8000, ASIC_VIDEOPAGESIZE_16KB, xChar );
		
		crSYNCHalt( );
		crASICSetScrollOffset( xPixel, 0 );
		
		if ( flip == 0 )
		{
			flip = 1;

			/*crTEXTDrawScrollerX(	(struct SFont *) &s_font, 
									(unsigned int) "HORIZONTAL SCROLLER, AHAH!!!",
									(struct SScroll *) &s_horizScroll );*/
		}
		else
		{
			flip = 0;
		}

		crTEXTDrawScrollerY(	(struct SFont *) &s_font, 
								(unsigned int) s_scrollVertText,
								(struct SScroll *) &s_vertScroll );

		updateScroll( );
		crAYPlay( );
	}
}
