/*
This file is part of CrocoLib.

CrocoLib is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

CrocoLib is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with Ceremony.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "crASIC.h"

#include <string.h> // memcpy

// ----------------------------------------------------------------------------
void __LIB__ crASICSetSpritePalette( unsigned int source )
{	
	crASICBegin( );

	//memcpy( 0x6422, source + 2, 15 * 2 );

#asm
	;; copy colours into ASIC sprite palette registers
	ld hl, sprite_colours
	ld de, $6422;
	ld bc, 15 * 2;
	ldir;

	jp endpal;

.sprite_colours
	defw $111			;; colour for sprite pen 1
	defw $222			;; colour for sprite pen 2
	defw $333			;; colour for sprite pen 3
	defw $444			;; colour for sprite pen 4
	defw $555			;; colour for sprite pen 5
	defw $666			;; colour for sprite pen 6
	defw $777			;; colour for sprite pen 7
	defw $888			;; colour for sprite pen 8
	defw $999			;; colour for sprite pen 9
	defw $aaa			;; colour for sprite pen 10
	defw $bbb			;; colour for sprite pen 11
	defw $ccc			;; colour for sprite pen 12
	defw $ddd			;; colour for sprite pen 13
	defw $eee			;; colour for sprite pen 14
	defw $fff			;; colour for sprite pen 15

.endpal
#endasm

	crASICEnd( );
}
