/*
	This file is part of CrocoLib.

	CrocoLib is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	CrocoLib is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public License
	along with Ceremony.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "crASIC.h"
#include "crBANK.h"

// ----------------------------------------------------------------------------
void __LIB__ crASICSetupInterrupt( void (*customCallback)() )
{	
#asm
	pop bc;

	pop de;
	ld ( callHandler + 1 ), de;

	push de;
	push bc;

	di;
	ld b,$bc;
	ld hl,sequence;
	ld e,17;
.seq 
	ld a,(hl);
	out (c),a;
	inc hl;
	dec e;
	jr nz,seq;

	ld bc,$7fb8;
	out (c),c;

	ld a,0;
	ld ($6805),a;

	ld a,10;
	ld ($6800),a;

	ld bc,$7fa8;
	out (c),c;

	ei;

	di;

	im 2;

	ld a,$04;
	ld i,a;

	ld hl,interrupt_handlers;
	ld de,$0400;
	ld bc, end_interrupt_handlers-interrupt_handlers;
	ldir;

	ei;
	jp endInstallInter;

.interrupt_handlers
	defw interrupt_handler1
	defw interrupt_handler2
	defw interrupt_handler3
	defw interrupt_handler4
.end_interrupt_handlers	

.interrupt_handler1
	ei;
	reti;

.interrupt_handler2
	ei;
	reti;

.interrupt_handler3
	ei;
	reti;

.interrupt_handler4
	ld ( saveSP + 1 ), sp;
	
	push ix;
	push iy;
	push af;
	push bc;
	push de;
	push hl;
	exx;
	ex af, af;
	push ix;
	push iy;
	push af;
	push bc;
	push de;
	push hl;

	ld a, ( _g_bank );
	ld ( saveBank + 1 ), a;

	ld a, ( _g_asic );
	ld ( saveAsic + 1 ), a;

.callHandler
	call 0;

	ld b, $7f;
.saveAsic
	ld c, $00;
	out (c), c;
	ld a, c;
	ld ( _g_asic ), a;

	ld bc, $7f00;
	out (c), c;
.saveBank
	ld a, $c6;
	out (c), a;
	ld ( _g_bank ), a;

	pop hl;
	pop de;
	pop bc;
	pop af;
	pop iy;
	pop ix;
	ex af, af;
	exx;
	pop hl;
	pop de;
	pop bc;
	pop af;
	pop iy;
	pop ix;

.saveSP
	ld sp, 0;

	ei;
	reti;

.sequence
	defb $ff,$00,$ff,$77,$b3,$51,$a8,$d4,$62,$39,$9c,$46,$2b,$15,$8a,$cd,$ee

.endInstallInter
#endasm
}
