/*
	This file is part of CrocoLib.

	CrocoLib is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	CrocoLib is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public License
	along with Ceremony.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef __CROCOLIB_CRTC_H__
#define __CROCOLIB_CRTC_H__

// ----------------------------------------------------------------------------
enum ECRTCOverscanMode
{
	CRTC_OVERSCAN_DISABLE = 0,
	CRTC_OVERSCAN_HORIZONTAL,
	CRTC_OVERSCAN_VERTICAL,
	CRTC_OVERSCAN_FULLSCREEN,
	CRTC_OVERSCAN_FULLSCREEN_CONVIMGCPC
};

// ----------------------------------------------------------------------------
enum ECRTCVideoPage
{
	CRTC_VIDEOPAGE_0000 = 0, // 0b00
	CRTC_VIDEOPAGE_4000 = 1, // 0b01
	CRTC_VIDEOPAGE_8000 = 2, // 0b10
	CRTC_VIDEOPAGE_C000 = 3  // 0b11
};

// ----------------------------------------------------------------------------
enum ECRTCVideoPageSize
{
	CRTC_VIDEOPAGESIZE_16KB = 0, // 0b00
	CRTC_VIDEOPAGESIZE_32KB = 3  // 0b11
};

// ----------------------------------------------------------------------------
extern void __LIB__ crCRTCSetupScreen( unsigned char overscanMode, unsigned char videoPage1, unsigned char videoPage2, unsigned char videoPageSize );
extern void __LIB__ crCRTCSetScreenOffset( unsigned char videoPage, unsigned char videoPageSize, unsigned int offset );
extern void __LIB__ crCRTCFlipScreen( );
extern unsigned char  __LIB__ crCRTCIsScreenFlipped( );

extern unsigned int __FASTCALL__ __LIB__ crCRTCGetScanline( unsigned int y );
extern unsigned int __LIB__ *crCRTCGetScanlineBuffer( );

extern void __LIB__ crCRTCSetPosX( unsigned char posX );
extern unsigned char __LIB__ crCRTCGetPosX( );
extern void __LIB__ crCRTCSetPosY( unsigned char posY );
extern unsigned char __LIB__ crCRTCGetPosY( );
extern void __LIB__ crCRTCSetWidth( unsigned char width );
extern unsigned char __LIB__ crCRTCGetWidth( );
extern void __LIB__ crCRTCSetHeight( unsigned char height );
extern unsigned char __LIB__ crCRTCGetHeight( );

extern unsigned char __LIB__ crCRTCGetType( );

// ----------------------------------------------------------------------------
#endif // __CROCOLIB_CRTC_H__
