/*
	This file is part of CrocoLib.

	CrocoLib is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	CrocoLib is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public License
	along with Ceremony.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "crCRTC.h"

// ----------------------------------------------------------------------------
void __FASTCALL__ setCRTCRegister( unsigned int reg12reg13 )
{
#asm
	ld bc, $bc00 + 12;
	out (c), c;
	inc b;
	ld c, h;
	out (c), c;

	ld bc, $bc00 + 13;
	out (c), c;
	inc b;
	ld c, l;
	out (c), c;
#endasm
}

// ----------------------------------------------------------------------------
void __LIB__ crCRTCSetScreenOffset( unsigned char videoPage, unsigned char videoPageSize, unsigned int offset )
{
	setCRTCRegister( ( videoPage << 12 ) + ( videoPageSize << 10 ) + offset );
}
