/*
	This file is part of CrocoLib.

	CrocoLib is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	CrocoLib is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public License
	along with Ceremony.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "crGA.h"
#include "crBANK.h"

// ----------------------------------------------------------------------------
void __LIB__ crGASetMode( unsigned int videoMode )
{
	unsigned char bank = crBANKGetBank( );

	switch ( videoMode )
	{
	case 0:
		{
#asm
			ld bc, $7f00;		
			out (c), c;
			ld a, $8c;
			out (c), a;
#endasm
		}
		break;
	case 1:
		{
#asm
			ld bc, $7f00;		
			out (c), c;
			ld a, $8d;
			out (c), a;
#endasm
		}
		break;
	case 2:
		{
#asm
			ld bc, $7f00;		
			out (c), c;
			ld a, $8e;
			out (c), a;
#endasm
		}
		break;
	}

	switch ( bank )
	{
	case 0:
	case 0xC0:		crBANKSetC0( ); break;
	case 0xC4:		crBANKSetC4( ); break;
	case 0xC5:		crBANKSetC5( ); break;
	case 0xC6:		crBANKSetC6( ); break;
	case 0xC7:		crBANKSetC7( ); break;
	}
}

