/*
	This file is part of CrocoLib.

	CrocoLib is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	CrocoLib is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public License
	along with Ceremony.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "crGFX.h"

#include <string.h> // memset

// ----------------------------------------------------------------------------
unsigned int g_frameInterPtr;

// ----------------------------------------------------------------------------
void __LIB__ crGFXCreateMonoInterFrame(	unsigned char *screenPtr, // 6
										unsigned char *imagePtr1, // 4 
										unsigned char *imagePtr2 ) // 2
{
#asm
	di;
	pop bc;
	pop hl;
	ld ( scrPtr2 ), hl;
	pop hl;
	ld ( scrPtr1 ), hl;
	pop de;

	push de;
	push hl;
	ld hl, ( scrPtr1 );
	push hl;
	push bc;
	ei;
	
	ld a, 33; // y
	ld ( loopY + 1 ), a;	

	ld a, 30; // x
	ld ( loopX + 1 ), a;

	ld hl, ( scrPtr1 );
	ld bc, ( scrPtr2 );

.scanline
	ld a, ( bc );
	inc bc;

	xor ( hl );
	inc hl;

	or a;
	jp z, pixel2;

	ld a, $c5;
	jp drawPixel;
.pixel2
	ld a, $e5;

.drawPixel;
	ld ( de ), a;
	inc de;

.loopX
	ld a, 0;
	dec a;
	ld ( loopX + 1 ), a;
	jp nz, scanline;

	ld a, 30;
	ld ( loopX + 1 ), a;

	ld ( scrPtr2 ), bc;
	ld bc, 96 - 30;
	add hl, bc;
	ld ( scrPtr1 ), hl;
	ld hl, ( scrPtr2 );
	add hl, bc;
	ld ( scrPtr2 ), hl;
	ld b, h;
	ld c, l;
	ld hl, ( scrPtr1 );

.loopY
	ld a, 0;
	dec a;
	ld ( loopY + 1 ), a;
	jp nz, scanline;

	ld ( _g_frameInterPtr ), de;

	jp endInter;

.scrPtr1
	defw 0;
.scrPtr2
	defw 0;
.compare
	defb 0;
.endInter	
#endasm
}
